<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">Publish changelogs</h1>
<?php
$Changelogs = new Changelogs();
loadModuleConfigs('changelogs');

// Check if changelogs cache folder is writable
if($Changelogs->isChangelogsDirWritable()) {
	
	// Add changelogs process::
	if(check_value($_POST['changelogs_submit'])) {
		$Changelogs->addchangelogs($_POST['changelogs_title'],$_POST['changelogs_content'],$_POST['changelogs_author'],$_POST['changelogs_prefijo'],0);
		$Changelogs->cachechangelogs();
		$Changelogs->updatechangelogsCacheIndex();
		redirect(1, 'admincp/?module=managechangelogs');
	}
	
?>
	<form role="form" method="post">
		<div class="form-group">
			<label for="input_1">Title:</label>
			<input type="text" class="form-control" id="input_1" name="changelogs_title" />
		</div>
		<div class="form-group">
			<select class="form-control" id="changelogs_prefijo" name="changelogs_prefijo">
				<option selected>Prefijo</option>
				<option value="1">Agregado</option>
				<option value="2">Cambiado</option>
				<option value="3">Arreglado</option>
				<option value="4">Removido</option>
			</select>
		</div>
		<div class="form-group">
			<label for="changelogs_content"></label>
			<textarea name="changelogs_content" id="changelogs_content"></textarea>
		</div>
		<div class="form-group">
			<label for="input_2">Author:</label>
			<input type="text" class="form-control" id="input_2" name="changelogs_author" value="Administrator"/>
		</div>
		<button type="submit" class="btn btn-large btn-block btn-success" name="changelogs_submit" value="ok">Publicar</button>
	</form>

	<script src="//cdn.ckeditor.com/4.7.3/full/ckeditor.js"></script>
	<script type="text/javascript">//<![CDATA[
		CKEDITOR.replace('changelogs_content', {
			language: 'en',
			uiColor: '#f1f1f1'
		});
	//]]></script>
<?php	
} else {
	message('error','The changelogs cache folder is not writable.');
}
?>