<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

echo '<h1 class="page-header">Add changelogs Translation</h1>';

try {
	
	$Changelogs = new Changelogs();
	loadModuleConfigs('changelogs');

	// Check if changelogs cache folder is writable
	if(!$Changelogs->isChangelogsDirWritable()) throw new Exception('The changelogs cache folder is not writable.');
		
	// Add changelogs translation process
	if(check_value($_POST['changelogs_submit'])) {
		try {
			$Changelogs->setId($_POST['changelogs_id']);
			$Changelogs->setLanguage($_POST['changelogs_language']);
			$Changelogs->setTitle($_POST['changelogs_title']);
			$Changelogs->setContent($_POST['changelogs_content']);
			$Changelogs->addChangelogsTransation();
			$Changelogs->updateChangelogsCacheIndex();
			redirect(1, 'admincp/?module=managechangelogs');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}

	// Cache changelogs process
	if(check_value($_REQUEST['cache']) && $_REQUEST['cache'] == 1) {
		$cacheChangelogs = $Changelogs->cacheChangelogs();
		if(!$cacheChangelogs) throw new Exception('The changelogs could not be cached.');
		message('success','Changelogs successfully cached!');
	}
	
	$changelogsData = $Changelogs->loadChangelogsData($_GET['id']);
	if(!is_array($changelogsData)) throw new Exception('Could not load changelogs data.');
	
	$languagesList = getInstalledLanguagesList();
	if(!is_array($languagesList)) throw new Exception('There are no available languages.');
	
	echo '<form role="form" method="post">';
		echo '<input type="hidden" name="changelogs_id" value="'.$changelogsData['changelogs_id'].'" />';
		echo '<div class="form-group">';
			echo '<label for="input_1">Language:</label>';
			echo '<select class="form-control" name="changelogs_language" id="input_1">';
				echo '<option value="">Select a language ...</option>';
				foreach($languagesList as $language) {
					if($language == config('language_default', true)) continue;
					echo '<option value="'.$language.'" '.(check_value($_POST['changelogs_language']) ? $_POST['changelogs_language'] == $language ? 'selected' : '' : '').'>'.$language.'</option>';
				}
			echo '</select>';
		echo '</div>';
		echo '<div class="form-group">';
			echo '<label for="input_2">Title:</label>';
			echo '<input type="text" class="form-control" id="input_2" name="changelogs_title" value="'.(check_value($_POST['changelogs_title']) ? $_POST['changelogs_title'] : $changelogsData['changelogs_title']).'" />';
		echo '</div>';
		echo '<div class="form-group">';
			echo '<label for="changelogs_content"></label>';
			echo '<textarea name="changelogs_content" id="changelogs_content">'.(check_value($_POST['changelogs_content']) ? $_POST['changelogs_content'] : $changelogsData['changelogs_content']).'</textarea>';
		echo '</div>';
		echo '<button type="submit" class="btn btn-large btn-block btn-success" name="changelogs_submit" value="ok">Add changelogs Translation</button>';
	echo '</form>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}
?>

<script src="//cdn.ckeditor.com/4.7.3/full/ckeditor.js"></script>
<script type="text/javascript">//<![CDATA[
	CKEDITOR.replace('changelogs_content', {
		language: 'en',
		uiColor: '#f1f1f1'
	});
//]]></script>