<?php
echo '<h2>Configuracion general</h2>';

function saveChanges() {
	global $_POST;
	foreach($_POST as $setting) {
		if(!check_value($setting)) {
			message('error','No debes dejar ningun campo vacio.');
			return;
		}
	}
	$xmlPath = __PATH_MODULE_CONFIGS__.'droplist.xml';
	$xml = simplexml_load_file($xmlPath);
	
	$xml->active = $_POST['setting_1'];
	$xml->skill = $_POST['setting_2'];
	$xml->luck = $_POST['setting_3'];
	$xml->addo = $_POST['setting_4'];
	$xml->excelent = $_POST['setting_5'];
	$xml->ancient = $_POST['setting_6'];
	$xml->socket = $_POST['setting_7'];
	$xml->op380 = $_POST['setting_8'];
	
	
	$save = $xml->asXML($xmlPath);
	if($save) {
		message('success','Cambios guardados correctamente.');
	} else {
		message('error','Hubo un error al guardar los cambios.');
	}
}

if(check_value($_POST['submit_changes'])) {
	saveChanges();
}

loadModuleConfigs('droplist');

?>
<form action="" method="post">

<table class="table table-striped table-bordered table-hover module_config_tables" >
	<thead>
		<tr>
            <th></th>
			<th style="text-align:center;width:6%;">Estado</th>
			<th style="text-align:center;width:6%;">Skill</th>
			<th style="text-align:center;width:6%;">Luck</th>
			<th style="text-align:center;width:6%;">Add Op</th>
			<th style="text-align:center;width:6%;">Excelent</th>
			<th style="text-align:center;width:6%;">Ancient</th>
			<th style="text-align:center;width:6%;">Socket</th>
			<th style="text-align:center;width:6%;">Op 380</th>
		</tr>
	</thead>
	<tbody>
        <tr>
            <td><h5 style="text-align:center;">Aca podras configurar si deseas <b>mostrar</b> u <b>ocultar</b> las columnas a mostrar en la tabla del <b>DropList</b>.</h5></td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_1',mconfig('active'),'Activo','Desactivado'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_2',mconfig('skill'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_3',mconfig('luck'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_4',mconfig('addo'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_5',mconfig('excelent'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_6',mconfig('ancient'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_7',mconfig('socket'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_8',mconfig('op380'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
        </tr>
        <tr>
			<td colspan="9"><input type="submit" name="submit_changes" value="Guardar Cambios" class="btn btn-success"/></td>
		</tr>
    </tbody>
</table>
</form>

	

<?php
echo '<h1 class="page-header">Configuracion de Drop List</h1>';

try {
	$creditSystem = new CreditSystem(); 
	
	if(check_value($_GET['delete'])) {
		try {
			# cfg
			$newCfg = loadConfig('droplist');
			if(!is_array($newCfg)) throw new Exception('DropList esta vacio.');
			
			if(!check_value($_GET['delete'])) throw new Exception('Invalid id.');
			if(!array_key_exists($_GET['delete'], $newCfg)) throw new Exception('Invalid id.');
			
			unset($newCfg[$_GET['delete']]);
			
			# encode
			$DropListJson = json_encode($newCfg, JSON_PRETTY_PRINT);
			
			# save changes
			$cfgFile = fopen(__PATH_CONFIGS__.'droplist.json', 'w');
			if(!$cfgFile) throw new Exception('There was a problem opening the mercadopago file.');
			fwrite($cfgFile, $DropListJson);
			fclose($cfgFile);
			
			message('success', 'Changes successfully saved!');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	if(check_value($_POST['drop_submit'])) {
		try {
			# cfg
			$newCfg = loadConfig('droplist');
			if(!is_array($newCfg)) throw new Exception('DropList esta vacio.');
			
			if(!check_value($_POST['drop_id'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['drop_name'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['drop_level'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['drop_dropmap'])) throw new Exception('Debes rellenar todos los campos.');
			
			$elementId = $_POST['drop_id'];

			# build new element data array
            $newElementData = array(
				'name'      => $_POST['drop_name'],
				'level'     => $_POST['drop_level'],
				'skill'     => (bool) ($_POST['drop_skill'] == 1 ? true : false),
				'luck'      => (bool) ($_POST['drop_luck'] == 1 ? true : false),
				'addo'      => (bool) ($_POST['drop_addo'] == 1 ? true : false),
				'excelent'  => (bool) ($_POST['drop_excelent'] == 1 ? true : false),
				'ancient'   => (bool) ($_POST['drop_ancient'] == 1 ? true : false),
				'socket'    => (bool) ($_POST['drop_socket'] == 1 ? true : false),
				'a380'      => (bool) ($_POST['drop_a380'] == 1 ? true : false),
				'dropmap'   => $_POST['drop_dropmap'],
				'order'     => (int) $_POST['drop_order']
			);
			
			$newCfg[$elementId] = $newElementData;
			
			usort($newCfg, function($a, $b) {
				return $a['order'] - $b['order'];
			});
			
			$DropListJson = json_encode($newCfg, JSON_PRETTY_PRINT);
			
			$cfgFile = fopen(__PATH_CONFIGS__.'droplist.json', 'w');
			if(!$cfgFile) throw new Exception('There was a problem opening the mercadopago file.');
			fwrite($cfgFile, $DropListJson);
			fclose($cfgFile);
			
			message('success', 'Changes successfully saved!');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	if(check_value($_POST['new_submit'])) {
		try {
			# cfg
			$newCfg = loadConfig('droplist');
			if(!is_array($newCfg)) throw new Exception('DropList esta vacio.');
			
			if(!check_value($_POST['drop_name'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['drop_level'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['drop_dropmap'])) throw new Exception('Debes rellenar todos los campos.');
			
            $newElementData = array(
				'name'      => $_POST['drop_name'],
				'level'     => $_POST['drop_level'],
				'skill'     => (bool) ($_POST['drop_skill'] == 1 ? true : false),
				'luck'      => (bool) ($_POST['drop_luck'] == 1 ? true : false),
				'addo'      => (bool) ($_POST['drop_addo'] == 1 ? true : false),
				'excelent'  => (bool) ($_POST['drop_excelent'] == 1 ? true : false),
				'ancient'   => (bool) ($_POST['drop_ancient'] == 1 ? true : false),
				'socket'    => (bool) ($_POST['drop_socket'] == 1 ? true : false),
				'a380'      => (bool) ($_POST['drop_a380'] == 1 ? true : false),
				'dropmap'   => $_POST['drop_dropmap'],
				'order'     => (int) $_POST['drop_order']
			);
			
			$newCfg[] = $newElementData;
			
			usort($newCfg, function($a, $b) {
				return $a['order'] - $b['order'];
			});
			
			# encode
			$DropListJson = json_encode($newCfg, JSON_PRETTY_PRINT);
			
			# save changes
			$cfgFile = fopen(__PATH_CONFIGS__.'droplist.json', 'w');
			if(!$cfgFile) throw new Exception('Hay un problema al abrir la configuracion de DropList.');
			fwrite($cfgFile, $DropListJson);
			fclose($cfgFile);
			
			message('success', 'Se actualizo la DropList exitosamente!');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	$cfg = loadConfig('droplist');
	if(!is_array($cfg)) throw new Exception('mercadopago configs empty.');
	
	echo '<table class="table table-responsive table-condensed table-bordered table-hover table-striped" >';
	echo '<thead>';
        echo '<tr>';
			echo '<th colspan="13" style="text-align:center;">Modificar Item Existente</th>';
		echo '</tr>';
		echo '<tr>';
			echo '<th></th>';
			echo '<th style="text-align:center;">Orden</th>';
			echo '<th style="text-align:center;">Item</th>';
			echo '<th style="text-align:center;width:7%;">Nivel</th>';
			echo '<th style="text-align:center;width:6%;">Skill</th>';
			echo '<th style="text-align:center;width:6%;">Luck</th>';
			echo '<th style="text-align:center;width:6%;">Add Op</th>';
			echo '<th style="text-align:center;width:6%;">Excelent</th>';
			echo '<th style="text-align:center;width:6%;">Ancient</th>';
			echo '<th style="text-align:center;width:6%;">Socket</th>';
			echo '<th style="text-align:center;width:6%;">Op 380</th>';
			echo '<th style="text-align:center;">Drop</th>';
			echo '<th></th>';
		echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
		foreach($cfg as $id => $DropListElement) {
			echo '<form action="?module=adddrop" method="post">';
			echo '<input type="hidden" name="drop_id" value="'.$id.'"/>';
			echo '<tr>';
				echo '<td class="text-center" style="vertical-align:middle;"><a href="?module=adddrop&delete='.$id.'" class="btn btn-danger btn-xs"><span class="fa fa-times" aria-hidden="true"></span></a></td>';
				echo '<td style="max-width:70px;"><input type="text" name="drop_order" class="form-control" style="text-align:center;" value="'.$DropListElement['order'].'"/></td>';
				echo '<td><input type="text" name="drop_name" class="form-control" style="text-align:center;" value="'.$DropListElement['name'].'"/></td>';
				echo '<td><input type="text" name="drop_level" class="form-control" style="text-align:center;" value="'.$DropListElement['level'].'"/></td>';
				echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="drop_skill" value="1" '.($DropListElement['skill'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="drop_luck" value="1" '.($DropListElement['luck'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="drop_addo" value="1" '.($DropListElement['addo'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="drop_excelent" value="1" '.($DropListElement['excelent'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="drop_ancient" value="1" '.($DropListElement['ancient'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="drop_socket" value="1" '.($DropListElement['socket'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
                    echo '<label class="radio-inline" style="padding:unset !important;">';
                        echo '<input type="checkbox" name="drop_a380" value="1" '.($DropListElement['a380'] ? 'checked' : '').'>';
                    echo '</label>';
                echo '</td>';
                echo '<td><input type="text" name="drop_dropmap" class="form-control" style="text-align:center;" value="'.$DropListElement['dropmap'].'"/></td>';
				echo '<td class="text-center" style="vertical-align:middle;"><button type="submit" name="drop_submit" value="ok" class="btn btn-primary">Guardar</button></td>';
			echo '</tr>';
			echo '</form>';
		}
    echo '</tbody>';
    echo '</table>';	


	echo '<table class="table table-responsive table-condensed table-bordered table-hover table-striped" >';
	echo '<thead>';
        echo '<tr>';
			echo '<th colspan="13" style="text-align:center;">Agregar Nuevo Item</th>';
		echo '</tr>';
		echo '<tr>';
			echo '<th></th>';
			echo '<th style="text-align:center;">Orden</th>';
			echo '<th style="text-align:center;">Item</th>';
			echo '<th style="text-align:center;width:7%;">Nivel</th>';
			echo '<th style="text-align:center;width:6%;">Skill</th>';
			echo '<th style="text-align:center;width:6%;">Luck</th>';
			echo '<th style="text-align:center;width:6%;">Add Op</th>';
			echo '<th style="text-align:center;width:6%;">Excelent</th>';
			echo '<th style="text-align:center;width:6%;">Ancient</th>';
			echo '<th style="text-align:center;width:6%;">Socket</th>';
			echo '<th style="text-align:center;width:6%;">Op 380</th>';
			echo '<th style="text-align:center;">Drop</th>';
			echo '<th></th>';
		echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
		echo '<form action="?module=adddrop" method="post">';
		echo '<tr>';		
		echo '<form action="?module=adddrop" method="post">';
			echo '<tr>';
				echo '<td class="text-center" style="vertical-align:middle;"><a href="?module=adddrop&delete='.$id.'" class="btn btn-danger btn-xs"><span class="fa fa-times" aria-hidden="true"></span></a></td>';
				echo '<td style="max-width:70px;"><input type="text" name="drop_order" class="form-control"/></td>';

                echo '<td><input type="text" name="drop_name" class="form-control" /></td>';
                echo '<td><input type="text" name="drop_level" class="form-control" /></td>';


				echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline">';
						echo '<input type="checkbox" name="drop_skill" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline">';
						echo '<input type="checkbox" name="drop_luck" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline">';
						echo '<input type="checkbox" name="drop_addo" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline">';
						echo '<input type="checkbox" name="drop_excelent" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline">';
						echo '<input type="checkbox" name="drop_ancient" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline">';
						echo '<input type="checkbox" name="drop_socket" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline">';
						echo '<input type="checkbox" name="drop_a380" value="1">';
					echo '</label>';
				echo '</td>';
				
                echo '<td><input type="text" name="drop_dropmap" class="form-control" /></td>';

				echo '<td class="text-center" style="vertical-align:middle;"><button type="submit" name="new_submit" value="ok" class="btn btn-success">Agregar</button></td>';
			echo '</tr>';
			echo '</form>';
	echo '</tbody>';
	echo '</table>';
	
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}
