<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">Publicar Guia</h1>
<?php
$Guides = new Guides();
loadModuleConfigs('guides');

// Check if guides cache folder is writable
if($Guides->isGuidesDirWritable()) {
	
	// Add guides process::
	if(check_value($_POST['guides_submit'])) {
		$Guides->addGuides($_POST['guides_title'],$_POST['guides_content'],$_POST['guides_author'],0);
		$Guides->cacheGuides();
		$Guides->updateGuidesCacheIndex();
		redirect(1, 'admincp/?module=manageguides');
	}
	
?>
	<form role="form" method="post">
		<div class="form-group">
			<label for="input_1">Titulo:</label>
			<input type="text" class="form-control" id="input_1" name="guides_title" />
		</div>
		<div class="form-group">
			<label for="guides_content"></label>
			<textarea name="guides_content" id="guides_content"></textarea>
		</div>
		<div class="form-group">
			<label for="input_2">Autor:</label>
			<input type="text" class="form-control" id="input_2" name="guides_author" value="Administrator"/>
		</div>
		<button type="submit" class="btn btn-large btn-block btn-success" name="guides_submit" value="ok">Publicar</button>
	</form>

	<script src="//cdn.ckeditor.com/4.7.3/full/ckeditor.js"></script>
	<script type="text/javascript">//<![CDATA[
		CKEDITOR.replace('guides_content', {
			language: 'en',
			uiColor: '#f1f1f1'
		});
	//]]></script>
<?php	
} else {
	message('error','La carpeta de Guias no es re-escribible.');
}
?>