<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

echo '<h1 class="page-header">Add Guides Translation</h1>';

try {
	
	$Guides = new Guides();
	loadModuleConfigs('guides');

	// Check if guides cache folder is writable
	if(!$Guides->isGuidesDirWritable()) throw new Exception('The guides cache folder is not writable.');
		
	// Add guides translation process
	if(check_value($_POST['guides_submit'])) {
		try {
			$Guides->setId($_POST['guides_id']);
			$Guides->setLanguage($_POST['guides_language']);
			$Guides->setTitle($_POST['guides_title']);
			$Guides->setContent($_POST['guides_content']);
			$Guides->addGuidesTransation();
			$Guides->updateGuidesCacheIndex();
			redirect(1, 'admincp/?module=manageguides');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}

	// Cache guides process
	if(check_value($_REQUEST['cache']) && $_REQUEST['cache'] == 1) {
		$cacheGuides = $Guides->cacheGuides();
		if(!$cacheGuides) throw new Exception('The guides could not be cached.');
		message('success','Guides successfully cached!');
	}
	
	$guidesData = $Guides->loadGuidesData($_GET['id']);
	if(!is_array($guidesData)) throw new Exception('Could not load guides data.');
	
	$languagesList = getInstalledLanguagesList();
	if(!is_array($languagesList)) throw new Exception('There are no available languages.');
	
	echo '<form role="form" method="post">';
		echo '<input type="hidden" name="guides_id" value="'.$guidesData['guides_id'].'" />';
		echo '<div class="form-group">';
			echo '<label for="input_1">Language:</label>';
			echo '<select class="form-control" name="guides_language" id="input_1">';
				echo '<option value="">Select a language ...</option>';
				foreach($languagesList as $language) {
					if($language == config('language_default', true)) continue;
					echo '<option value="'.$language.'" '.(check_value($_POST['guides_language']) ? $_POST['guides_language'] == $language ? 'selected' : '' : '').'>'.$language.'</option>';
				}
			echo '</select>';
		echo '</div>';
		echo '<div class="form-group">';
			echo '<label for="input_2">Title:</label>';
			echo '<input type="text" class="form-control" id="input_2" name="guides_title" value="'.(check_value($_POST['guides_title']) ? $_POST['guides_title'] : $guidesData['guides_title']).'" />';
		echo '</div>';
		echo '<div class="form-group">';
			echo '<label for="guides_content"></label>';
			echo '<textarea name="guides_content" id="guides_content">'.(check_value($_POST['guides_content']) ? $_POST['guides_content'] : $guidesData['guides_content']).'</textarea>';
		echo '</div>';
		echo '<button type="submit" class="btn btn-large btn-block btn-success" name="guides_submit" value="ok">Add guides Translation</button>';
	echo '</form>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}
?>

<script src="//cdn.ckeditor.com/4.7.3/full/ckeditor.js"></script>
<script type="text/javascript">//<![CDATA[
	CKEDITOR.replace('guides_content', {
		language: 'en',
		uiColor: '#f1f1f1'
	});
//]]></script>