<?php
echo '<h2>Configuracion general</h2>';

function saveChanges() {
	global $_POST;
	foreach($_POST as $setting) {
		if(!check_value($setting)) {
			message('error','No debes dejar ningun campo vacio.');
			return;
		}
	}
	$xmlPath = __PATH_MODULE_CONFIGS__.'iteminfo.xml';
	$xml = simplexml_load_file($xmlPath);
	
	$xml->active = $_POST['setting_1'];
	$xml->darklord = $_POST['setting_2'];
	$xml->summoner = $_POST['setting_3'];
	$xml->fighter = $_POST['setting_4'];
	$xml->maxlevel = $_POST['setting_5'];
	
	
	$save = $xml->asXML($xmlPath);
	if($save) {
		message('success','Cambios guardados correctamente.');
	} else {
		message('error','Hubo un error al guardar los cambios.');
	}
}

if(check_value($_POST['submit_changes'])) {
	saveChanges();
}

loadModuleConfigs('iteminfo');

?>
<form action="" method="post">

<table class="table table-striped table-bordered table-hover module_config_tables" >
	<thead>
		<tr>
            <th></th>
			<th style="text-align:center;width:6%;">Estado</th>
			<th style="text-align:center;width:6%;">Dark Lord</th>
			<th style="text-align:center;width:6%;">Summoner</th>
			<th style="text-align:center;width:6%;">Rage Fighter</th>
			<th style="text-align:center;width:6%;">Max Level</th>
		</tr>
	</thead>
	<tbody>
        <tr>
            <td><h5 style="text-align:center;">Aca podras configurar si deseas <b>mostrar</b> u <b>ocultar</b> las columnas de las <b>razas</b>.</h5></td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_1',mconfig('active'),'Activo','Desactivado'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_2',mconfig('darklord'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_3',mconfig('summoner'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
            <td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes('setting_4',mconfig('fighter'),'Mostrar','Ocultar'); ?>
                </label>
            </td>
			<td class="text-center" style="vertical-align:middle;">
                <label class="radio-inline" style="padding:unset !important;">
				    <?php enabledisableCheckboxes2('setting_5',mconfig('maxlevel'),'+15','+13','+11'); ?>
                </label>
            </td>

			
        </tr>
        <tr>
			<td colspan="9"><input type="submit" name="submit_changes" value="Guardar Cambios" class="btn btn-success"/></td>
		</tr>
    </tbody>
</table>
</form>

	

<?php
echo '<h1 class="page-header">Configuracion de Item Info List</h1>';

try {
	$creditSystem = new CreditSystem(); 
	
	if(check_value($_GET['delete'])) {
		try {
			# cfg
			$newCfg = loadConfig('iteminfo');
			if(!is_array($newCfg)) throw new Exception('Item Info esta vacio.');
			
			if(!check_value($_GET['delete'])) throw new Exception('Invalid id.');
			if(!array_key_exists($_GET['delete'], $newCfg)) throw new Exception('Invalid id.');
			
			unset($newCfg[$_GET['delete']]);
			
			# encode
			$DropListJson = json_encode($newCfg, JSON_PRETTY_PRINT);
			
			# save changes
			$cfgFile = fopen(__PATH_CONFIGS__.'iteminfo.json', 'w');
			if(!$cfgFile) throw new Exception('There was a problem opening the mercadopago file.');
			fwrite($cfgFile, $DropListJson);
			fclose($cfgFile);
			
			message('success', 'Changes successfully saved!');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	if(check_value($_POST['itemi_submit'])) {
		try {
			# cfg
			$newCfg = loadConfig('iteminfo');
			if(!is_array($newCfg)) throw new Exception('ItemInfo esta vacio.');
			
			if(!check_value($_POST['itemi_id'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['itemi_name'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['itemi_defense'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['itemi_dmg'])) throw new Exception('Debes rellenar todos los campos.');
			
			$elementId = $_POST['itemi_id'];

			# build new element data array
            $newElementData = array(
				'name'      => $_POST['itemi_name'],
				'type'      => $_POST['itemi_type'],
				'defense'   => $_POST['itemi_defense'],
				'dmg'     	=> $_POST['itemi_dmg'],
				'dmg2'     	=> $_POST['itemi_dmg2'],
				'sm'     	=> (bool) ($_POST['itemi_sm'] == 1 ? true : false),
				'bk'      	=> (bool) ($_POST['itemi_bk'] == 1 ? true : false),
				'elf'      	=> (bool) ($_POST['itemi_elf'] == 1 ? true : false),
				'mg'  		=> (bool) ($_POST['itemi_mg'] == 1 ? true : false),
				'dl'   		=> (bool) ($_POST['itemi_dl'] == 1 ? true : false),
				'sum'    	=> (bool) ($_POST['itemi_sum'] == 1 ? true : false),
				'rf'      	=> (bool) ($_POST['itemi_rf'] == 1 ? true : false),
				'setmg'     => (bool) ($_POST['itemi_setmg'] == 1 ? true : false),
				'order'     => (int) $_POST['itemi_order']
			);
			
			$newCfg[$elementId] = $newElementData;
			
			usort($newCfg, function($a, $b) {
				return $a['order'] - $b['order'];
			});
			
			$DropListJson = json_encode($newCfg, JSON_PRETTY_PRINT);
			
			$cfgFile = fopen(__PATH_CONFIGS__.'iteminfo.json', 'w');
			if(!$cfgFile) throw new Exception('There was a problem opening the mercadopago file.');
			fwrite($cfgFile, $DropListJson);
			fclose($cfgFile);
			
			message('success', 'Changes successfully saved!');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	if(check_value($_POST['new_submit'])) {
		try {
			# cfg
			$newCfg = loadConfig('iteminfo');
			if(!is_array($newCfg)) throw new Exception('iteminfo esta vacio.');
			
			if(!check_value($_POST['itemi_name'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['itemi_defense'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['itemi_dmg'])) throw new Exception('Debes rellenar todos los campos.');
			
            $newElementData = array(
				'name'      => $_POST['itemi_name'],
				'type'      => $_POST['itemi_type'],
				'defense'   => $_POST['itemi_defense'],
				'dmg'     	=> $_POST['itemi_dmg'],
				'dmg2'     	=> $_POST['itemi_dmg2'],
				'sm'     	=> (bool) ($_POST['itemi_sm'] == 1 ? true : false),
				'bk'      	=> (bool) ($_POST['itemi_bk'] == 1 ? true : false),
				'elf'      	=> (bool) ($_POST['itemi_elf'] == 1 ? true : false),
				'mg'  		=> (bool) ($_POST['itemi_mg'] == 1 ? true : false),
				'dl'   		=> (bool) ($_POST['itemi_dl'] == 1 ? true : false),
				'sum'    	=> (bool) ($_POST['itemi_sum'] == 1 ? true : false),
				'rf'      	=> (bool) ($_POST['itemi_rf'] == 1 ? true : false),
				'setmg'     => (bool) ($_POST['itemi_setmg'] == 1 ? true : false),
				'order'     => (int) $_POST['itemi_order']
			);
			
			$newCfg[] = $newElementData;
			
			usort($newCfg, function($a, $b) {
				return $a['order'] - $b['order'];
			});
			
			# encode
			$DropListJson = json_encode($newCfg, JSON_PRETTY_PRINT);
			
			# save changes
			$cfgFile = fopen(__PATH_CONFIGS__.'iteminfo.json', 'w');
			if(!$cfgFile) throw new Exception('Hay un problema al abrir la configuracion de iteminfo.');
			fwrite($cfgFile, $DropListJson);
			fclose($cfgFile);
			
			message('success', 'Se actualizo la iteminfo exitosamente!');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	$cfg = loadConfig('iteminfo');
	if(!is_array($cfg)) throw new Exception('mercadopago configs empty.');
	
	echo '<table class="table table-responsive table-condensed table-bordered table-hover table-striped" >';
	echo '<thead>';
        echo '<tr>';
			echo '<th colspan="13" style="text-align:center;">Modificar Item Existente</th>';
		echo '</tr>';
		echo '<tr>';
			echo '<th></th>';
			echo '<th style="text-align:center;">Orden</th>';
			echo '<th style="text-align:center;">Tipo</th>';
			echo '<th style="text-align:center;">Item</th>';
			echo '<th style="text-align:center;width:7%;">Defensa</th>';
			echo '<th style="text-align:center;width:6%;">DMG Min</th>';
			echo '<th style="text-align:center;width:6%;">DMG Max</th>';
			echo '<th style="text-align:center;width:6%;">SM</th>';
			echo '<th style="text-align:center;width:6%;">BK</th>';
			echo '<th style="text-align:center;width:6%;">ELF</th>';
			echo '<th style="text-align:center;width:6%;">MG</th>';
			echo '<th style="text-align:center;width:6%;">DL</th>';
			echo '<th style="text-align:center;width:6%;">SUM</th>';
			echo '<th style="text-align:center;width:6%;">RF</th>';
			echo '<th style="text-align:center;width:6%;">Set MG/RF</th>';
			echo '<th></th>';
		echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
		foreach($cfg as $id => $DropListElement) {
			echo '<form action="?module=additeminfo" method="post">';
			echo '<input type="hidden" name="itemi_id" value="'.$id.'"/>';
			echo '<tr>';
				echo '<td class="text-center" style="vertical-align:middle;"><a href="?module=additeminfo&delete='.$id.'" class="btn btn-danger btn-xs"><span class="fa fa-times" aria-hidden="true"></span></a></td>';
				echo '<td style="max-width:70px;"><input type="text" name="itemi_order" class="form-control" style="text-align:center;" value="'.$DropListElement['order'].'"/></td>';

				if($DropListElement['type'] == 1){
					$Tipo = "Sword";
				}elseif($DropListElement['type'] == 2){
					$Tipo = "Axe";
				}elseif($DropListElement['type'] == 3){
					$Tipo = "Mace";
				}elseif($DropListElement['type'] == 4){
					$Tipo = "Spear";
				}elseif($DropListElement['type'] == 5){
					$Tipo = "Bow";
				}elseif($DropListElement['type'] == 6){
					$Tipo = "Staff";
				}elseif($DropListElement['type'] == 7){
					$Tipo = "Shield";
				}elseif($DropListElement['type'] == 8){
					$Tipo = "Set";
				}elseif($DropListElement['type'] == 9){
					$Tipo = "Wings";
				}


				echo '<td style="text-align:center;"><select class="form-control form-control-lg" name="itemi_type" id="itemi_type">
							<option selected>'.$Tipo.'</option>
							<option value="1">Sword</option>
							<option value="2">Axe</option>
							<option value="3">Mace</option>
							<option value="4">Spear</option>
							<option value="5">Bow</option>
							<option value="6">Staff</option>
							<option value="7">Shield</option>
							<option value="8">Set</option>
							<option value="9">Wings</option>
						</select>
				</td>';
				echo '<td><input type="text" name="itemi_name" class="form-control" style="text-align:center;" value="'.$DropListElement['name'].'"/></td>';
				echo '<td><input type="text" name="itemi_defense" class="form-control" style="text-align:center;" value="'.$DropListElement['defense'].'"/></td>';
				echo '<td><input type="text" name="itemi_dmg" class="form-control" style="text-align:center;" value="'.$DropListElement['dmg'].'"/></td>';
				echo '<td><input type="text" name="itemi_dmg2" class="form-control" style="text-align:center;" value="'.$DropListElement['dmg2'].'"/></td>';
				echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="itemi_sm" value="1" '.($DropListElement['sm'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="itemi_bk" value="1" '.($DropListElement['bk'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="itemi_elf" value="1" '.($DropListElement['elf'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="itemi_mg" value="1" '.($DropListElement['mg'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="itemi_dl" value="1" '.($DropListElement['dl'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding:unset !important;">';
						echo '<input type="checkbox" name="itemi_sum" value="1" '.($DropListElement['sum'] ? 'checked' : '').'>';
					echo '</label>';
				echo '</td>';
                echo '<td class="text-center" style="vertical-align:middle;">';
                    echo '<label class="radio-inline" style="padding:unset !important;">';
                        echo '<input type="checkbox" name="itemi_rf" value="1" '.($DropListElement['rf'] ? 'checked' : '').'>';
                    echo '</label>';
                echo '</td>';
				echo '<td class="text-center" style="vertical-align:middle;">';
                    echo '<label class="radio-inline" style="padding:unset !important;">';
                        echo '<input type="checkbox" name="itemi_setmg" value="1" '.($DropListElement['setmg'] ? 'checked' : '').'>';
                    echo '</label>';
                echo '</td>';
				echo '<td class="text-center" style="vertical-align:middle;"><button type="submit" name="itemi_submit" value="ok" class="btn btn-primary">Guardar</button></td>';
			echo '</tr>';
			echo '</form>';
		}
    echo '</tbody>';
    echo '</table>';	


	echo '<table class="table table-responsive table-condensed table-bordered table-hover table-striped" >';
	echo '<thead>';
        echo '<tr>';
			echo '<th colspan="13" style="text-align:center;">Agregar Nuevo Item</th>';
		echo '</tr>';
		echo '<tr>';
			echo '<th></th>';
			echo '<th style="text-align:center;">Orden</th>';
			echo '<th style="text-align:center;">Tipo</th>';
			echo '<th style="text-align:center;">Item</th>';
			echo '<th style="text-align:center;width:7%;">Defensa</th>';
			echo '<th style="text-align:center;width:7%;">DMG Min</th>';
			echo '<th style="text-align:center;width:7%;">DMG Max</th>';
			echo '<th style="text-align:center;width:6%;">SM</th>';
			echo '<th style="text-align:center;width:6%;">BK</th>';
			echo '<th style="text-align:center;width:6%;">ELF</th>';
			echo '<th style="text-align:center;width:6%;">MG</th>';
			echo '<th style="text-align:center;width:6%;">DL</th>';
			echo '<th style="text-align:center;width:6%;">SUM</th>';
			echo '<th style="text-align:center;width:6%;">RF</th>';
			echo '<th style="text-align:center;width:6%;">Set MG/RF</th>';
			echo '<th></th>';
		echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
		echo '<form action="?module=additeminfo" method="post">';
		echo '<tr>';		
		echo '<form action="?module=additeminfo" method="post">';
			echo '<tr>';
				echo '<td class="text-center" style="vertical-align:middle;"><a href="?module=additeminfo&delete='.$id.'" class="btn btn-danger btn-xs"><span class="fa fa-times" aria-hidden="true"></span></a></td>';
				echo '<td style="max-width:70px;"><input type="text" name="itemi_order" class="form-control"/></td>';

                echo '<td style="text-align:center;"><select class="form-control form-control-lg" name="itemi_type" id="itemi_type">
				<option selected>Tipo</option>
				<option value="1">Sword</option>
				<option value="2">Axe</option>
				<option value="3">Mace</option>
				<option value="4">Spear</option>
				<option value="5">Bow</option>
				<option value="6">Staff</option>
				<option value="7">Shield</option>
				<option value="8">Set</option>
				<option value="9">Wings</option>
			  </select></td>';
                echo '<td><input type="text" name="itemi_name" class="form-control" /></td>';
                echo '<td><input type="text" name="itemi_defense" class="form-control" /></td>';
                echo '<td><input type="text" name="itemi_dmg" class="form-control" /></td>';
                echo '<td><input type="text" name="itemi_dmg2" class="form-control" /></td>';


				echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding-left: unset;">';
						echo '<input type="checkbox" name="itemi_sm" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding-left: unset;">';
						echo '<input type="checkbox" name="itemi_bk" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding-left: unset;">';
						echo '<input type="checkbox" name="itemi_elf" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding-left: unset;">';
						echo '<input type="checkbox" name="itemi_mg" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding-left: unset;">';
						echo '<input type="checkbox" name="itemi_dl" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding-left: unset;">';
						echo '<input type="checkbox" name="itemi_sum" value="1">';
					echo '</label>';
				echo '</td>';

                echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding-left: unset;">';
						echo '<input type="checkbox" name="itemi_rf" value="1">';
					echo '</label>';
				echo '</td>';

				echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline" style="padding-left: unset;">';
						echo '<input type="checkbox" name="itemi_setmg" value="1">';
					echo '</label>';
				echo '</td>';
				

				echo '<td class="text-center" style="vertical-align:middle;"><button type="submit" name="new_submit" value="ok" class="btn btn-success">Agregar</button></td>';
			echo '</tr>';
			echo '</form>';
	echo '</tbody>';
	echo '</table>';
	
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}
