<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

echo '<h1 class="page-header">Edit changelogs Translation</h1>';

try {
	
	$Changelogs = new Changelogs();
	loadModuleConfigs('changelogs');

	// Check if changelogs cache folder is writable
	if(!$Changelogs->isChangelogsDirWritable()) throw new Exception('The changelogs cache folder is not writable.');
		
	// Edit changelogs translation process
	if(check_value($_POST['changelogs_submit'])) {
		try {
			$Changelogs->setId($_POST['changelogs_id']);
			$Changelogs->setLanguage($_POST['changelogs_language']);
			$Changelogs->setTitle($_POST['changelogs_title']);
			$Changelogs->setContent($_POST['changelogs_content']);
			$Changelogs->updateChangelogsTransation();
			redirect(1, 'admincp/?module=managechangelogs');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	$Changelogs->setId($_GET['id']);
	$Changelogs->setLanguage($_GET['language']);
	$changelogsData = $Changelogs->loadChangelogsTranslationData();
	if(!is_array($changelogsData)) throw new Exception('Could not load changelogs data.');
	
	echo '<form role="form" method="post">';
		echo '<input type="hidden" name="changelogs_id" value="'.$changelogsData['changelogs_id'].'" />';
		echo '<input type="hidden" name="changelogs_language" value="'.$changelogsData['changelogs_language'].'" />';
		echo '<div class="form-group">';
			echo '<label for="input_1">Language:</label>';
			echo '<select class="form-control" name="changelogs_language" id="input_1" disabled="disabled">';
				echo '<option>'.$changelogsData['changelogs_language'].'</option>';
			echo '</select>';
		echo '</div>';
		echo '<div class="form-group">';
			echo '<label for="input_2">Title:</label>';
			echo '<input type="text" class="form-control" id="input_2" name="changelogs_title" value="'.(check_value($_POST['changelogs_title']) ? $_POST['changelogs_title'] : $changelogsData['changelogs_title']).'" />';
		echo '</div>';
		echo '<div class="form-group">';
			echo '<label for="changelogs_content"></label>';
			echo '<textarea name="changelogs_content" id="changelogs_content">'.(check_value($_POST['changelogs_content']) ? $_POST['changelogs_content'] : $changelogsData['changelogs_content']).'</textarea>';
		echo '</div>';
		echo '<button type="submit" class="btn btn-large btn-block btn-warning" name="changelogs_submit" value="ok">Update changelogs Translation</button>';
	echo '</form>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}
?>

<script src="//cdn.ckeditor.com/4.7.3/full/ckeditor.js"></script>
<script type="text/javascript">//<![CDATA[
	CKEDITOR.replace('changelogs_content', {
		language: 'en',
		uiColor: '#f1f1f1'
	});
//]]></script>