<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">Editar Guia</h1>
<?php
$Guides = new Guides();
loadModuleConfigs('guides');

// Check if guides cache folder is writable
if($Guides->isguidesDirWritable()) {
	
	// Edit guides process::
	if(check_value($_POST['guides_submit'])) {
		$Guides->editGuides($_REQUEST['id'],$_POST['guides_title'],$_POST['guides_content'],$_POST['guides_author'],0,$_POST['guides_date']);
		$Guides->cacheGuides();
		$Guides->updateGuidesCacheIndex();
		redirect(1, 'admincp/?module=manageguides');
	}
	
	// Load guides
	$editGuides = $Guides->loadGuidesData($_REQUEST['id']);
	if($editGuides) {
?>
		<form role="form" method="post">
			<div class="form-group">
				<label for="input_1">Title:</label>
				<input type="text" class="form-control" id="input_1" name="guides_title" value="<?php echo $editGuides['guides_title']; ?>"/>
			</div>
			<div class="form-group">
				<label for="guides_content"></label>
				<textarea name="guides_content" id="guides_content"><?php echo $editGuides['guides_content']; ?></textarea>
			</div>
			<div class="form-group">
				<label for="input_2">Author:</label>
				<input type="text" class="form-control" id="input_2" name="guides_author" value="<?php echo $editGuides['guides_author']; ?>"/>
			</div>
			<div class="form-group">
				<label for="input_4">guides Date:</label>
				<input type="text" class="form-control" id="input_4" name="guides_date" value="<?php echo date("Y-m-d H:i", $editGuides['guides_date']); ?>"/>
			</div>
			<button type="submit" class="btn btn-large btn-block btn-success" name="guides_submit" value="ok">Update Guides</button>
		</form>
		
		<script src="//cdn.ckeditor.com/4.7.3/full/ckeditor.js"></script>
		<script type="text/javascript">//<![CDATA[
			CKEDITOR.replace('guides_content', {
				language: 'en',
				uiColor: '#f1f1f1'
			});
		//]]></script>
<?php	
	} else {
		message('error','Could not load guides data.');
	}
} else {
	message('error','The guides cache folder is not writable.');
}

?>