<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

echo '<h1 class="page-header">Editar Traduccion de Guia</h1>';

try {
	
	$Guides = new Guides();
	loadModuleConfigs('guides');

	// Check if Guides cache folder is writable
	if(!$Guides->isGuidesDirWritable()) throw new Exception('The Guides cache folder is not writable.');
		
	// Edit guides translation process
	if(check_value($_POST['guides_submit'])) {
		try {
			$Guides->setId($_POST['guides_id']);
			$Guides->setLanguage($_POST['guides_language']);
			$Guides->setTitle($_POST['guides_title']);
			$Guides->setContent($_POST['guides_content']);
			$Guides->updateGuidesTransation();
			redirect(1, 'admincp/?module=manageguides');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	$Guides->setId($_GET['id']);
	$Guides->setLanguage($_GET['language']);
	$GuidesData = $Guides->loadGuidesTranslationData();
	if(!is_array($guidesData)) throw new Exception('Could not load guides data.');
	
	echo '<form role="form" method="post">';
		echo '<input type="hidden" name="guides_id" value="'.$guidesData['guides_id'].'" />';
		echo '<input type="hidden" name="guides_language" value="'.$guidesData['guides_language'].'" />';
		echo '<div class="form-group">';
			echo '<label for="input_1">Language:</label>';
			echo '<select class="form-control" name="guides_language" id="input_1" disabled="disabled">';
				echo '<option>'.$guidesData['guides_language'].'</option>';
			echo '</select>';
		echo '</div>';
		echo '<div class="form-group">';
			echo '<label for="input_2">Title:</label>';
			echo '<input type="text" class="form-control" id="input_2" name="guides_title" value="'.(check_value($_POST['guides_title']) ? $_POST['guides_title'] : $guidesData['guides_title']).'" />';
		echo '</div>';
		echo '<div class="form-group">';
			echo '<label for="guides_content"></label>';
			echo '<textarea name="guides_content" id="guides_content">'.(check_value($_POST['guides_content']) ? $_POST['guides_content'] : $guidesData['guides_content']).'</textarea>';
		echo '</div>';
		echo '<button type="submit" class="btn btn-large btn-block btn-warning" name="guides_submit" value="ok">Update guides Translation</button>';
	echo '</form>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}
?>

<script src="//cdn.ckeditor.com/4.7.3/full/ckeditor.js"></script>
<script type="text/javascript">//<![CDATA[
	CKEDITOR.replace('guides_content', {
		language: 'en',
		uiColor: '#f1f1f1'
	});
//]]></script>