<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">[GIFT Code] Agregar Items</h1>
<?php
	$database = (config('SQL_USE_2_DB',true) ? $dB2 : $dB);
	
	if(check_value($_POST['submit_add'])) {
		try {
			if(!check_value($_POST['item_index'])) throw new Exception("<b>[GIFT Code]</b> Por favor no dejes ningun campo vacio.");
			if(!check_value($_POST['item_x'])) throw new Exception("<b>[GIFT Code]</b> Por favor no dejes ningun campo vacio.");
			if(!check_value($_POST['item_y'])) throw new Exception("<b>[GIFT Code]</b> Por favor no dejes ningun campo vacio.");

			$AddItemData = array(
				'iGroup' 				=> $_POST['item_group'],
				'iIndex' 				=> $_POST['item_index'],
				'iItemX'				=> $_POST['item_x'],
				'iItemY'				=> $_POST['item_y'],
			);
			
			$addItem = $database->query("INSERT INTO WEBENGINE_GIFT_CODE_ITEMS (iGrupo, iIndex, X, Y) VALUES (:iGroup, :iIndex, :iItemX, :iItemY)", $AddItemData);
			if(!$addItem) throw new Exception("<b>[GIFT Code]</b> No se pudo agregar el item.");
			
			message('success', '<b>[GIFT Code]</b> El item fue agregado correctamente.');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
?>
<div class="row">
	<div class="col-md-6">
		<div class="card">
			<div class="card-body">
				<form action="" method="post" role="form">

				<div class="input-group mb-3">
					<label class="input-group-text" for="CategoriaSelect">Categoria</label>
					<select class="form-select" id="CategoriaSelect" name="item_group">
						<option value="0" selected>[0] - Sword</option>
						<option value="1">[1] - Axes</option>
						<option value="2">[2] - Maces</option>
						<option value="3">[3] - Spears</option>
						<option value="4">[4] - Bows</option>
						<option value="5">[5] - Staffs</option>
						<option value="6">[6] - Shields</option>
						<option value="7">[7] - Helmets</option>
						<option value="8">[8] - Armors</option>
						<option value="9">[9] - Pants</option>
						<option value="10">[10] - Gloves</option>
						<option value="11">[11] - Boots</option>
						<option value="12">[12] - Wings</option>
						<option value="13">[13] - Jewel/Misc</option>
						<option value="14">[14] - Wings and Orbs and Spheres</option>
						<option value="15">[15] - Scrolls</option>
					</select>
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text">Index</span>
					<input type="number" class="form-control" name="item_index" aria-label="Index" placeholder="Index de Item">
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text">Ancho de Item (X)</span>
					<input type="number" class="form-control" name="item_x" aria-label="x" placeholder="Ancho de Slot de Item">
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text">Alto de Item (Y)</span>
					<input type="number" class="form-control" name="item_y" aria-label="x" placeholder="Alto de Slot de Item">
				</div>
					<input type="submit" name="submit_add" class="btn btn-primary" value="Agregar Item"/>
				</form>
			</div>
		</div>
	</div>
</div>