<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">Gift Code - Logs</h1>
<?php
try{
	$database = (config('SQL_USE_2_DB',true) ? $dB2 : $dB);

	$GiftCode   =   new GiftCode();
	
	if(check_value($_GET['eliminar'])) {
		try {
			if(!Validator::UnsignedNumber($_GET['eliminar'])) throw new Exception("<b>[GiftCode]</b> El ID del log a eliminar es invailido.");
			
			$ItemInfo = $database->query_fetch_single("SELECT * FROM WEBENGINE_GIFT_CODE_LOGS WHERE id = ?", array($_GET['eliminar']));
			if(!is_array($ItemInfo)) throw new Exception("<b>[GiftCode]</b> El Log no existe.");

			// Eliminar log
			$database->query("DELETE FROM WEBENGINE_GIFT_CODE_LOGS WHERE id = ?", array($_GET['eliminar']));
			
			message('success', '<b>[GiftCode]</b> El log fue eliminado correctamente.');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
?>
<div class="row">
	<div class="col-md-12">
	<!-- Modal -->

		<div class="panel-body">
				<div class="tab-pane"><br />
				<?php
					$ListLogs = $GiftCode->GetLogs();
					if(is_array($ListLogs)) {
		echo '<div class="row">';
			echo '<div class="col-md-12">';
				echo '<div class="card">';
					echo '<div class="card-body">';
						echo '<h3>Ultimos codigos canjeados</h3>';
						echo '<div class="table-responsive">';
						echo '<table id="zero_config" class="table table-striped table-sm align-middle text-center">';
							echo '<thead class="table-dark text-white">';
							echo '<tr>';
								echo '<th style="color:#f1f1f1;"></th>';
								echo '<th style="color:#f1f1f1;">Codigo</th>';
								echo '<th style="color:#f1f1f1;">Usuario</th>';
								echo '<th style="color:#f1f1f1;">Personaje</th>';
								echo '<th style="color:#f1f1f1;">Fecha</th>';
							echo '</tr>';
							echo '</thead>';
							echo '<tbody>';
							foreach($ListLogs as $Logs) {
								echo '<tr>';
									echo '<form action="?module=giftcode_logs" method="post">';
										echo '<td class="text-center" style="vertical-align:middle;"><a href="index.php?module='.$_REQUEST['module'].'&eliminar='.$Logs['id'].'" class="btn btn-danger btn-xs"><span class="fa fa-times" aria-hidden="true"></span></a></td>';
										echo '<td><span style="text-align:center;"><b>'.$Logs['Codigo'].'</b></span></td>';
										echo '<td><span style="text-align:center;">'.$Logs['Usuario'].'</span></td>';
										echo '<td><span style="text-align:center;">'.$Logs['Personaje'].'</span></td>';
										echo '<td><span style="text-align:center;"><b>'.$Logs['Fecha'].'</b></span></td>';	
									echo '</form>';
								echo '</tr>';
							}
						echo '</tbody>';
						echo '</table>';

						echo '</div>';

					echo '</div>';
				echo '</div>';
			echo '</div>';
		echo '</div>';			
					} else {
						message('warning', '<b>[GiftCode]</b> No hay codigos canjeados en los Logs.', ' ');
					}
}catch(Exception $ex) {
	message('error', $ex->getMessage());
}
				?>
				</div>
		</div>
	</div>
</div>