<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">Administrar Lista de Cambios</h1>
<?php
$Changelogs = new Changelogs();

if($Changelogs->isChangelogsDirWritable()) {

	# Changelogs detele
	if(check_value($_REQUEST['delete'])) {
		$deleteChangelogs = $Changelogs->removeChangelogs($_REQUEST['delete']);
		$Changelogs->cacheChangelogs();
		$Changelogs->updateChangelogsCacheIndex();
		if($deleteChangelogs) {
			redirect(1, 'admincp/?module=managechangelogs');
		} else {
			message('error','Invalid changelogs ID');
		}
	}
	
	# Changelogs translation delete
	if(check_value($_GET['deletetranslation']) && check_value($_GET['language'])) {
		try {
			$Changelogs->setId($_GET['deletetranslation']);
			$Changelogs->setLanguage($_GET['language']);
			$Changelogs->deleteChangelogsTranslation();
			$Changelogs->updateChangelogsCacheIndex();
			redirect(1, 'admincp/?module=managechangelogs');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	# Changelogs cache
	if(check_value($_REQUEST['cache']) && $_REQUEST['cache'] == 1) {
		$cacheChangelogs = $Changelogs->cacheChangelogs();
		$Changelogs->updateChangelogsCacheIndex();
		if($cacheChangelogs) {
			message('success','Changelogs successfully cached');
		} else {
			message('error','There are no changelogs to cache.');
		}
	}
	
	$changelogs_list = $Changelogs->retrieveChangelogs();
	if(is_array($changelogs_list)) {
		
		foreach($changelogs_list as $row) {
			
			$Changelogs->setId($row['changelogs_id']);
			
			echo '<div class="panel panel-default">';
				echo '<div class="panel-heading">';
					echo '<a href="'.__BASE_URL__.'changelogs/'.$row['changelogs_id'].'/" target="_blank">'.$row['changelogs_title'].'</a>';
					echo '<a class="btn btn-danger btn-xs pull-right" href="'.admincp_base("managechangelogs&delete=".$row['changelogs_id']).'"><i class="fa fa-trash"></i> delete</a>';
					echo '<a class="btn btn-warning btn-xs pull-right" style="margin-right:5px;" href="'.admincp_base("editchangelogs&id=".$row['changelogs_id']).'"><i class="fa fa-edit"></i> edit</a>';
					echo '<a class="btn btn-xs btn-default pull-right" style="margin-right:5px;" href="'.admincp_base("addchangelogstranslation&id=".$row['changelogs_id']).'"><i class="fa fa-plus"></i> Add Translation</a>';
				echo '</div>';
				echo '<div class="panel-body">';
					echo '<div class="row">';
						echo '<div class="col-xs-6">';
							echo '<table class="table">';
								echo '<tr>';
									echo '<th>changelogs Id:</th>';
									echo '<td>'.$row['changelogs_id'].'</td>';
								echo '</tr>';
								echo '<tr>';
									echo '<th>Author:</th>';
									echo '<td>'.$row['changelogs_author'].'</td>';
								echo '</tr>';
								echo '<tr>';
									echo '<th>Date:</th>';
									echo '<td>'.date("Y-m-d H:i",$row['changelogs_date']).'</td>';
								echo '</tr>';
							echo '</table>';
						echo '</div>';
						echo '<div class="col-xs-6">';
							echo 'Translations:';
							
							$changelogsTranslations = $Changelogs->getChangelogsTranslationsDataList();
							if(is_array($changelogsTranslations)) {
								echo '<ul>';
									foreach($changelogsTranslations as $translation) {
										echo '<li>[<span style="color:red;">'.$translation['changelogs_language'].'</span>] '.$translation['changelogs_title'].' <a href="'.admincp_base('editchangelogstranslation&id='.$translation['changelogs_id'].'&language='.$translation['changelogs_language']).'" class="btn btn-xs btn-default">edit</a> <a href="'.admincp_base('managechangelogs&deletetranslation='.$translation['changelogs_id'].'&language='.$translation['changelogs_language']).'" class="btn btn-xs btn-default">delete</a></li>';
									}
								echo '</ul>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
			
		}
		
	}
	
	echo '<a class="btn btn-success" href="'.admincp_base("managechangelogs&cache=1").'">UPDATE Changelogs CACHE</a>';

} else {
	message('error','The changelogs cache folder is not writable.');
}

?>