<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">Administrador de Guias</h1>
<?php
$Guides = new Guides();

if($Guides->isGuidesDirWritable()) {

	# guides detele
	if(check_value($_REQUEST['delete'])) {
		$deleteGuides = $Guides->removeguides($_REQUEST['delete']);
		$Guides->cacheguides();
		$Guides->updateguidesCacheIndex();
		if($deleteGuides) {
			redirect(1, 'admincp/?module=manageguides');
		} else {
			message('error','Invalid guides ID');
		}
	}
	
	# guides translation delete
	if(check_value($_GET['deletetranslation']) && check_value($_GET['language'])) {
		try {
			$Guides->setId($_GET['deletetranslation']);
			$Guides->setLanguage($_GET['language']);
			$Guides->deleteGuidesTranslation();
			$Guides->updateGuidesCacheIndex();
			redirect(1, 'admincp/?module=manageguides');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	# guides cache
	if(check_value($_REQUEST['cache']) && $_REQUEST['cache'] == 1) {
		$cacheGuides = $Guides->cacheGuides();
		$Guides->updateGuidesCacheIndex();
		if($cacheGuides) {
			message('success','Cache de Guias ejectuado correctamente.');
		} else {
			message('error','No hay cache de Guias.');
		}
	}
	
	$guides_list = $Guides->retrieveGuides();
	if(is_array($guides_list)) {
		
		foreach($guides_list as $row) {
			
			$Guides->setId($row['guides_id']);
			
			echo '<div class="panel panel-default">';
				echo '<div class="panel-heading">';
					echo '<a href="'.__BASE_URL__.'guides/'.$row['guides_id'].'/" target="_blank">'.$row['guides_title'].'</a>';
					echo '<a class="btn btn-danger btn-xs pull-right" href="'.admincp_base("manageguides&delete=".$row['guides_id']).'"><i class="fa fa-trash"></i> delete</a>';
					echo '<a class="btn btn-warning btn-xs pull-right" style="margin-right:5px;" href="'.admincp_base("editguides&id=".$row['guides_id']).'"><i class="fa fa-edit"></i> edit</a>';
					echo '<a class="btn btn-xs btn-default pull-right" style="margin-right:5px;" href="'.admincp_base("addguidestranslation&id=".$row['guides_id']).'"><i class="fa fa-plus"></i> Add Translation</a>';
				echo '</div>';
				echo '<div class="panel-body">';
					echo '<div class="row">';
						echo '<div class="col-xs-6">';
							echo '<table class="table">';
								echo '<tr>';
									echo '<th>Guides Id:</th>';
									echo '<td>'.$row['guides_id'].'</td>';
								echo '</tr>';
								echo '<tr>';
									echo '<th>Author:</th>';
									echo '<td>'.$row['guides_author'].'</td>';
								echo '</tr>';
								echo '<tr>';
									echo '<th>Date:</th>';
									echo '<td>'.date("Y-m-d H:i",$row['guides_date']).'</td>';
								echo '</tr>';
							echo '</table>';
						echo '</div>';
						echo '<div class="col-xs-6">';
							echo 'Translations:';
							
							$guidesTranslations = $Guides->getGuidesTranslationsDataList();
							if(is_array($guidesTranslations)) {
								echo '<ul>';
									foreach($guidesTranslations as $translation) {
										echo '<li>[<span style="color:red;">'.$translation['guides_language'].'</span>] '.$translation['guides_title'].' <a href="'.admincp_base('editguidestranslation&id='.$translation['guides_id'].'&language='.$translation['guides_language']).'" class="btn btn-xs btn-default">edit</a> <a href="'.admincp_base('manageguides&deletetranslation='.$translation['guides_id'].'&language='.$translation['guides_language']).'" class="btn btn-xs btn-default">delete</a></li>';
									}
								echo '</ul>';
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';
			echo '</div>';
			
		}
		
	}
	
	echo '<a class="btn btn-success" href="'.admincp_base("manageguides&cache=1").'">Actualizar Cache de Guias</a>';

} else {
	message('error','Carpeta Guias no es re-escribible.');
}

?>