<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">Mercado de Personajes</h1>
<?php
function saveChanges() {
	global $_POST;
	foreach($_POST as $setting) {
		if(!check_value($setting)) {
			message('error','Missing data (complete all fields).');
			return;
		}
	}
	
	$xmlPath = __PATH_MODULE_CONFIGS__.'marketchar.xml';
	
	$xml = simplexml_load_file($xmlPath);
	$xml->active = $_POST['setting_1'];
	$xml->comission = $_POST['setting_2'];
	$xml->comission_porc = $_POST['setting_3'];
	$xml->moneda = $_POST['setting_4'];
	$xml->precio_min = $_POST['setting_5'];
	$xml->tabla_moneda = $_POST['setting_6'];
	$xml->precio_level = $_POST['setting_7'];
	$xml->precio_reset = $_POST['setting_8'];
	$xml->precio_mreset = $_POST['setting_9'];
	$xml->moneda_v = $_POST['setting_10'];

	$save2 = $xml->asXML($xmlPath);
	
	if($save2) {
		message('success','[Market] Settings successfully saved.');
	} else {
		message('error','[Market] There has been an error while saving changes.');
	}
}

if(check_value($_POST['submit_changes'])) {
	saveChanges();
}
loadModuleConfigs('marketchar');
?>
<form action="" method="post">
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
			<th>Estado<br/><span>Activar/desactivar Mercado de Personajes.</span></th>
			<td>
				<? enabledisableCheckboxes('setting_1',mconfig('active'),'Activar','Desactivar'); ?>
			</td>
		</tr>

		<tr>
			<th>Comision<br/><span>Activar/Desactivar Comision de venta de personaje</span></th>
			<td>
				<? enabledisableCheckboxes('setting_2',mconfig('comission'),'Activar','Desactivar'); ?>
			</td>
		</tr>

		<tr>
			<th>Comision %<br/><span>Coloca el % de comision que tendran al vender un personaje</span></th>
			<td>
				<input class="input-xxlarge" type="number" name="setting_3" value="<?php echo mconfig('comission_porc')?>"/>
			</td>
		</tr>

		<tr>
			<th>Tabla de Moneda<br/><span>Coloca el nombre de la tabla donde guardas tu moneda a usar.</span></th>
			<td>
				<input class="input-xxlarge" type="text" name="setting_6" value="<?php echo mconfig('tabla_moneda')?>"/>
			</td>
		</tr>

		<tr>
			<th>Moneda<br/><span>Coloca el nombre exacto de la moneda <b>( Ejemplo: [ WCoinC, WCoinP, GoblinPoint ] )</b> a usar.</span></th>
			<td>
				<input class="input-xxlarge" type="text" name="setting_4" value="<?php echo mconfig('moneda')?>"/>
			</td>
		</tr>

		<tr>
			<th>Moneda Visual<br/><span>Coloca el nombre que quieras que se vea <b>( Ejemplo: [ Gold Coins, Pepito Coins, Ruud Coin ] )</b> a usar.</span></th>
			<td>
				<input class="input-xxlarge" type="text" name="setting_10" value="<?php echo mconfig('moneda_v')?>"/>
			</td>
		</tr>

		<tr>
			<th>Precio Minimo<br/><span>Coloca el precio minimo para publicar una venta.</span></th>
			<td>
				<input class="input-xxlarge" type="number" name="setting_5" value="<?php echo mconfig('precio_min')?>"/>
			</td>
		</tr>
		
		<tr>
			<th>Level Minimo<br/><span>Coloca los levels minimo necesarios para publicar una venta.</span></th>
			<td>
				<input class="input-xxlarge" type="number" name="setting_7" value="<?php echo mconfig('precio_level')?>"/>
			</td>
		</tr>

		<tr>
			<th>Resets Minimo<br/><span>Coloca los resets minimo necesarios para publicar una venta.</span></th>
			<td>
				<input class="input-xxlarge" type="number" name="setting_8" value="<?php echo mconfig('precio_reset')?>"/>
			</td>
		</tr>

		<tr>
			<th>Master Resets Minimo<br/><span>Coloca los master resets minimo necesarios para publicar una venta.</span></th>
			<td>
				<input class="input-xxlarge" type="number" name="setting_9" value="<?php echo mconfig('precio_mreset')?>"/>
			</td>
		</tr>

		<tr>
			<td colspan="2"><input type="submit" name="submit_changes" value="Guardar Cambios" class="btn btn-success"/></td>
		</tr>
	</table>
</form>