<?php
/**
 * WebEngine
 * http://muengine.net/
 * 
 * @version 1.0.9
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2017 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h2>Profiles Settings</h2>
<?php
function saveChanges() {
	global $_POST;
	foreach($_POST as $setting) {
		if(!check_value($setting)) {
			message('error','Missing data (complete all fields).');
			return;
		}
	}
	$xmlPath = __PATH_MODULE_CONFIGS__.'profiles.xml';
	$xml = simplexml_load_file($xmlPath);
	
	$xml->active = $_POST['setting_1'];
	$xml->stats = $_POST['setting_2'];
	$xml->online = $_POST['setting_3'];
	$xml->inventario = $_POST['setting_4'];
	
	$save = $xml->asXML($xmlPath);
	if($save) {
		message('success','Settings successfully saved.');
	} else {
		message('error','There has been an error while saving changes.');
	}
}

if(check_value($_POST['submit_changes'])) {
	saveChanges();
}

loadModuleConfigs('profiles');
?>
<form action="" method="post">
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
			<th>Status<br/><span>Enable/disable the profile modules.</span></th>
			<td>
				<? enabledisableCheckboxes('setting_1',mconfig('active'),'Enabled','Disabled'); ?>
			</td>
		</tr>
		<tr>
			<th>Stats<br/><span>Show/Hide stats in the profile player.</span></th>
			<td>
				<? enabledisableCheckboxes('setting_2',mconfig('stats'),'Show','Hide'); ?>
			</td>
		</tr>
		<tr>
			<th>Mas Info Status<br/><span>Show/Hide more info Status in the profile player.</span></th>
			<td>
				<? enabledisableCheckboxes('setting_3',mconfig('online'),'Show','Hide'); ?>
			</td>
		</tr>
		<tr>
			<th>Inventory<br/><span>Show/Hide inventory in the profile player.</span></th>
			<td>
				<? enabledisableCheckboxes('setting_4',mconfig('inventario'),'Show','Hide'); ?>
			</td>
		</tr>
		<tr>
			<td colspan="2"><input type="submit" name="submit_changes" value="Save Changes" class="btn btn-success"/></td>
		</tr>
	</table>
</form>