
<h1 class="page-header">MercadoPago Settings</h1>
<?php
function saveChanges() {
	global $_POST;
	foreach($_POST as $setting) {
		if(!check_value($setting)) {
			message('error','Datos Perdidos (Faltan completar algunas filas).');
			return;
		}
	}
	
	// MercadoPago
	$xmlPath = __PATH_MODULE_CONFIGS__.'mercadopago.xml';
	$xml = simplexml_load_file($xmlPath);
	$xml->active = $_POST['setting_1'];
	$xml->coins_status = $_POST['setting_2'];
	$xml->vip_status = $_POST['setting_3'];
	$xml->mercadopago_desc = $_POST['setting_4'];
	$xml->access_token = $_POST['setting_5'];
	$xml->mercadopago_return_url = $_POST['setting_6'];
	$xml->mercadopago_api_return_url = $_POST['setting_7'];

	$save2 = $xml->asXML($xmlPath);
	

	if($save2) {
		message('success','[MercadoPago] Settings successfully saved.');
	} else {
		message('error','[MercadoPago] There has been an error while saving changes.');
	}

}

if(check_value($_POST['submit_changes'])) {
	saveChanges();
}

loadModuleConfigs('mercadopago');

$creditSystem = new CreditSystem();
?>
<form action="" method="post">
	<table class="table table-striped table-bordered table-hover module_config_tables">
		<tr>
			<th><b>[ Status ]</b><br/><span>Enable or Disable the MercadoPago module..</span></th>
			<td>
				<? enabledisableCheckboxes('setting_1',mconfig('active'),'Enabled','Disabled'); ?>
			</td>
		</tr>
		<tr>
			<th><b>[ Coins Status ]</b><br/><span>Enable or Disable COINS donations.</span></th>
			<td>
				<? enabledisableCheckboxes('setting_2',mconfig('coins_status'),'Enabled','Disabled'); ?>
			</td>
		</tr>
		<tr>
			<th><b>[ Vip Status ]</b><br/><span>Enable or Disable VIP donations.</span></th>
			<td>
				<? enabledisableCheckboxes('setting_3',mconfig('vip_status'),'Enabled','Disabled'); ?>
			</td>
		</tr>
		<tr>
			<th><b>[ MercadoPago Description ]</b><br/><span>Enter the Mercado Pago Description.</span></th>
			<td>
				<input style="width: 100%;" class="input-xxlarge" type="text" name="setting_4" value="<?=mconfig('mercadopago_desc')?>"/>
			</td>
		</tr>
		<tr>
			<th><b>[ MercadoPago ACCESS TOKEN ]</b><br/><span>Enter the ACCESS TOKEN of your MercadoPago account. <a href="https://www.mercadopago.com.ar/developers/panel/credentials" target="_blank">( Credentials )</a>.</span></span></th>
			<td>
				<input style="width: 100%;" class="input-xxlarge" type="text" name="setting_5" value="<?=mconfig('access_token')?>"/>
			</td>
		</tr>
		<tr>
			<th><b>[ Return/Cancel URL ]</b><br/><span>URL where the client will be redirected to if the donation is cancelled or completed..</span></th>
			<td>
				<input style="width: 100%;" class="input-xxlarge" type="text" name="setting_6" value="<?=mconfig('mercadopago_return_url')?>"/>
			</td>
		</tr>
		<tr>
			<th><b>[ IPN Notify URL ]</b><br/><span>URL of WebEngine's MercadoPago API. <br>( By default it has to be in: <b><?php echo __BASE_URL__;?>api/mercadopago.php</b> ).<br/></span></th>
			<td>
				<input style="width: 100%;" class="input-xxlarge" type="text" name="setting_7" value="<?=mconfig('mercadopago_api_return_url')?>"/>
			</td>
		</tr>
		<tr>
			<td colspan="2"><input type="submit" name="submit_changes" value="Save Changes" class="btn btn-success"/></td>
		</tr>
	</table>
</form>