<?php
echo '<h2>Configuracion general</h2>';

function saveChanges() {
	global $_POST;
	foreach($_POST as $setting) {
		if(!check_value($setting)) {
			message('error','No debes dejar ningun campo vacio.');
			return;
		}
	}
	$xmlPath = __PATH_MODULE_CONFIGS__.'shopsemi.xml';
	$xml = simplexml_load_file($xmlPath);
	
	$xml->active = $_POST['setting_1'];
	$xml->onlyprice = $_POST['setting_2'];
	$xml->mercadopago = $_POST['setting_3'];
	$xml->paypal = $_POST['setting_4'];
	$xml->bcp = $_POST['setting_5'];
	$xml->numwp = $_POST['setting_6'];
	$xml->coins = $_POST['setting_10'];
	$xml->vips = $_POST['setting_11'];
	$xml->sword = $_POST['setting_12'];
	$xml->axe = $_POST['setting_13'];
	$xml->mace = $_POST['setting_14'];
	$xml->spear = $_POST['setting_15'];
	$xml->bow = $_POST['setting_16'];
	$xml->staff = $_POST['setting_17'];
	$xml->shield = $_POST['setting_18'];
	$xml->wings = $_POST['setting_19'];
	$xml->otros = $_POST['setting_20'];
	$xml->set = $_POST['setting_21'];
	$xml->helm = $_POST['setting_22'];
	$xml->armor = $_POST['setting_23'];
	$xml->pants = $_POST['setting_24'];
	$xml->gloves = $_POST['setting_25'];
	$xml->boots = $_POST['setting_26'];
	
	
	$save = $xml->asXML($xmlPath);
	if($save) {
		message('success','Cambios guardados correctamente.');
	} else {
		message('error','Hubo un error al guardar los cambios.');
	}
}

if(check_value($_POST['submit_changes'])) {
	saveChanges();
}

loadModuleConfigs('shopsemi');

?>
<form action="" method="post">

<table class="table table-striped table-bordered table-hover module_config_tables" >
	<tr>
		<th>Estado<br/><span>Activado/Desactivado el shop.</span></th>
		<td>
			<?php enabledisableCheckboxes('setting_1',mconfig('active'),'Activo','Desactivado'); ?>
		</td>
	</tr>
	<tr>
		<th>Mostrar solo Precios<br/><span>Activado/Desactivado solo precios. Esto hace que no muestre los botones, pero si los precios.</span></th>
		<td>
			<?php enabledisableCheckboxes('setting_2',mconfig('onlyprice'),'Activado','Desactivado'); ?>
		</td>
	</tr>
	<tr>
		<th>Boton MercadoPago<br/><span>Mostrar/Ocultar boton y precio MercadoPago.</span></th>
		<td>
			<?php enabledisableCheckboxes('setting_3',mconfig('mercadopago'),'Mostrar','Ocultar'); ?>
		</td>
	</tr>
	<tr>
		<th>Boton PayPal<br/><span>Mostrar/Ocultar boton y precio PayPal.</span></th>
		<td>
			<?php enabledisableCheckboxes('setting_4',mconfig('paypal'),'Mostrar','Ocultar'); ?>
		</td>
	</tr>
	<tr>
		<th>Boton BCP<br/><span>Mostrar/Ocultar boton y precio BCP.</span></th>
		<td>
			<?php enabledisableCheckboxes('setting_5',mconfig('bcp'),'Mostrar','Ocultar'); ?>
		</td>
	</tr>
	<tr>
		<th>Numero WhatsApp<br/><span>Coloca el numero de WhatsApp que aparecera en el boton del shop.</span></th>
		<td>
			<input class="input-xxlarge" type="text" name="setting_6" value="<?php echo mconfig('numwp')?>"/>
		</td>
	</tr>
</table>
	<h3>Configuracion de Categorias</h3>
	<table class="table table-striped table-bordered table-hover module_config_tables" >
		<tr><th colspan="2"><h5 style="text-align:center;">Aca podras configurar si deseas <b>mostrar</b> u <b>ocultar</b> los botones de categorias del <b>Shop</b>.</h5></th></tr>
		<tr>
			<th>Coins<br/><span>Mostrar/Ocultar boton <b>Coins</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_10',mconfig('coins'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Vips<br/><span>Mostrar/Ocultar boton <b>Vips</b>  en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_11',mconfig('vips'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Sword<br/><span>Mostrar/Ocultar boton <b>Sword</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_12',mconfig('sword'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Axe<br/><span>Mostrar/Ocultar boton <b>Axe</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_13',mconfig('axe'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Mace<br/><span>Mostrar/Ocultar boton <b>Mace</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_14',mconfig('mace'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Spear<br/><span>Mostrar/Ocultar boton <b>Spear</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_15',mconfig('spear'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Bow<br/><span>Mostrar/Ocultar boton <b>Bow</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_16',mconfig('bow'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Staff<br/><span>Mostrar/Ocultar boton <b>Staff</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_17',mconfig('staff'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Shield<br/><span>Mostrar/Ocultar boton <b>Shield</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_18',mconfig('shield'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Wings<br/><span>Mostrar/Ocultar boton <b>Wings</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_19',mconfig('wings'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Otros<br/><span>Mostrar/Ocultar boton <b>Otros</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_20',mconfig('otros'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Set<br/><span>Mostrar/Ocultar boton <b>Set</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_21',mconfig('set'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Helm<br/><span>Mostrar/Ocultar boton <b>Helm</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_22',mconfig('helm'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Armor<br/><span>Mostrar/Ocultar boton <b>Armor</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_23',mconfig('armor'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Pants<br/><span>Mostrar/Ocultar boton <b>Pants</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_24',mconfig('pants'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Gloves<br/><span>Mostrar/Ocultar boton <b>Gloves</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_25',mconfig('gloves'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
		<tr>
			<th>Boots<br/><span>Mostrar/Ocultar boton <b>Boots</b> en el Shop.</span></th>
			<td>
				<?php enabledisableCheckboxes('setting_26',mconfig('boots'),'Mostrar','Ocultar'); ?>
			</td>
		</tr>
        <tr>
			<td colspan="9"><input type="submit" name="submit_changes" value="Guardar Cambios" class="btn btn-success"/></td>
		</tr>
</table>

</form>

	

<?php

try {
	$creditSystem = new CreditSystem(); 
	
	if(check_value($_GET['delete'])) {
		try {
			# cfg
			$newCfg = loadConfig('shopsemi');
			if(!is_array($newCfg)) throw new Exception('Shop esta vacio.');
			
			if(!check_value($_GET['delete'])) throw new Exception('Invalid id.');
			if(!array_key_exists($_GET['delete'], $newCfg)) throw new Exception('Invalid id.');
			
			unset($newCfg[$_GET['delete']]);
			
			# encode
			$ShopSemiJson = json_encode($newCfg, JSON_PRETTY_PRINT);
			
			# save changes
			$cfgFile = fopen(__PATH_CONFIGS__.'shopsemi.json', 'w');
			if(!$cfgFile) throw new Exception('There was a problem opening the mercadopago file.');
			fwrite($cfgFile, $ShopSemiJson);
			fclose($cfgFile);
			
			message('success', 'Changes successfully saved!');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	if(check_value($_POST['shop_submit'])) {
		try {
			# cfg
			$newCfg = loadConfig('shopsemi');
			if(!is_array($newCfg)) throw new Exception('Shop esta vacio.');
			
			if(!check_value($_POST['shop_id'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_name'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_img'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_pricemp'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_linkmp'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_pricepp'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_linkpp'])) throw new Exception('Debes rellenar todos los campos.');
			
			$elementId = $_POST['shop_id'];

			# build new element data array
            $newElementData = array(
				'name'      	=> $_POST['shop_name'],
				'category'      => $_POST['shop_type'],
				'img'     		=> $_POST['shop_img'],
				'descripcion'   => $_POST['shop_descripcion'],
				'pricemp'     	=> $_POST['shop_pricemp'],
				'linkmp'     	=> $_POST['shop_linkmp'],
				'pricepp'     	=> $_POST['shop_pricepp'],
				'linkpp'     	=> $_POST['shop_linkpp'],
				'pricebcp'     	=> $_POST['shop_pricebcp'],
				'linkbcp'     	=> $_POST['shop_linkbcp'],
				'colorbg'     	=> $_POST['shop_colorbg'],
				'classic'      => (bool) ($_POST['shop_classic'] == 1 ? true : false),
				'order'     => (int) $_POST['shop_order']
			);
			
			$newCfg[$elementId] = $newElementData;
			
			usort($newCfg, function($a, $b) {
				return $a['order'] - $b['order'];
			});
			
			$ShopSemiJson = json_encode($newCfg, JSON_PRETTY_PRINT);
			
			$cfgFile = fopen(__PATH_CONFIGS__.'shopsemi.json', 'w');
			if(!$cfgFile) throw new Exception('There was a problem opening the mercadopago file.');
			fwrite($cfgFile, $ShopSemiJson);
			fclose($cfgFile);
			
			message('success', 'Changes successfully saved!');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	if(check_value($_POST['new_submit'])) {
		try {
			# cfg
			$newCfg = loadConfig('shopsemi');
			if(!is_array($newCfg)) throw new Exception('Shop esta vacio.');
			
			if(!check_value($_POST['shop_name'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_img'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_pricemp'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_linkmp'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_pricepp'])) throw new Exception('Debes rellenar todos los campos.');
			if(!check_value($_POST['shop_linkpp'])) throw new Exception('Debes rellenar todos los campos.');
			
            $newElementData = array(
				'name'      	=> $_POST['shop_name'],
				'category'      => $_POST['shop_type'],
				'img'     		=> $_POST['shop_img'],
				'descripcion'   => $_POST['shop_descripcion'],
				'pricemp'     	=> $_POST['shop_pricemp'],
				'linkmp'     	=> $_POST['shop_linkmp'],
				'pricepp'     	=> $_POST['shop_pricepp'],
				'linkpp'     	=> $_POST['shop_linkpp'],
				'pricebcp'     	=> $_POST['shop_pricebcp'],
				'linkbcp'     	=> $_POST['shop_linkbcp'],
				'colorbg'     	=> $_POST['shop_colorbg'],
				'classic'      => (bool) ($_POST['shop_classic'] == 1 ? true : false),
				'order'     => (int) $_POST['shop_order']
			);
			
			$newCfg[] = $newElementData;
			
			usort($newCfg, function($a, $b) {
				return $a['order'] - $b['order'];
			});
			
			# encode
			$ShopSemiJson = json_encode($newCfg, JSON_PRETTY_PRINT);
			
			# save changes
			$cfgFile = fopen(__PATH_CONFIGS__.'shopsemi.json', 'w');
			if(!$cfgFile) throw new Exception('Hay un problema al abrir la configuracion de Shop.');
			fwrite($cfgFile, $ShopSemiJson);
			fclose($cfgFile);
			
			message('success', 'Se actualizo la Shop exitosamente!');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	$cfg = loadConfig('shopsemi');
	if(!is_array($cfg)) throw new Exception('Shop esta vacio.');
	
	echo '<table class="table table-responsive table-condensed table-bordered table-hover table-striped" >';
	echo '<thead>';
        echo '<tr>';
			echo '<th colspan="13" style="text-align:center;">Modificar Item Existente</th>';
		echo '</tr>';
		echo '<tr>';
			echo '<th></th>';
			echo '<th style="text-align:center;">Orden</th>';
			echo '<th style="text-align:center;">Tipo</th>';
			echo '<th style="text-align:center;">Nombre</th>';
			echo '<th style="text-align:center;">Imagen</th>';
			echo '<th style="text-align:center;">Descripcion</th>';
			echo '<th style="text-align:center;">Precio MercadoPago</th>';
			echo '<th style="text-align:center;">Link MercadoPago</th>';
			echo '<th style="text-align:center;">Precio PayPal</th>';
			echo '<th style="text-align:center;">ID Boton PayPal</th>';
			echo '<th style="text-align:center;">Precio BCP</th>';
			echo '<th style="text-align:center;">Link BCP</th>';
			echo '<th style="text-align:center;">Color BG</th>';
			echo '<th style="text-align:center;">Estilo Clasico</th>';
			echo '<th></th>';
		echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
		foreach($cfg as $id => $ShopSemiElement) {
			echo '<form action="?module=shopsemi" method="post">';
			echo '<input type="hidden" name="shop_id" value="'.$id.'"/>';
			echo '<tr>';
				echo '<td class="text-center" style="vertical-align:middle;"><a href="?module=shopsemi&delete='.$id.'" class="btn btn-danger btn-xs"><span class="fa fa-times" aria-hidden="true"></span></a></td>';
				echo '<td style="max-width:70px;"><input type="text" name="shop_order" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['order'].'"/></td>';

				if($ShopSemiElement['category'] == 1){
					$Tipo = "Coins";
				}else if($ShopSemiElement['category'] == 2){
					$Tipo = "Vips";
				}else if($ShopSemiElement['category'] == 3){
					$Tipo = "Sword";
				}elseif($ShopSemiElement['category'] == 4){
					$Tipo = "Axe";
				}elseif($ShopSemiElement['category'] == 5){
					$Tipo = "Mace";
				}elseif($ShopSemiElement['category'] == 6){
					$Tipo = "Spear";
				}elseif($ShopSemiElement['category'] == 7){
					$Tipo = "Bow";
				}elseif($ShopSemiElement['category'] == 8){
					$Tipo = "Staff";
				}elseif($ShopSemiElement['category'] == 9){
					$Tipo = "Shield";
				}elseif($ShopSemiElement['category'] == 10){
					$Tipo = "Helm";
				}elseif($ShopSemiElement['category'] == 11){
					$Tipo = "Armor";
				}elseif($ShopSemiElement['category'] == 12){
					$Tipo = "Pants";
				}elseif($ShopSemiElement['category'] == 13){
					$Tipo = "Gloves";
				}elseif($ShopSemiElement['category'] == 14){
					$Tipo = "Boots";
				}elseif($ShopSemiElement['category'] == 15){
					$Tipo = "Set";					
				}elseif($ShopSemiElement['category'] == 16){
					$Tipo = "Wings";
				}elseif($ShopSemiElement['category'] == 17){
					$Tipo = "Otros";
				}else{
					$Tipo = "Sin Categoria";
				}

				echo '<td style="text-align:center;"><select class="form-control form-control-lg" name="shop_type" id="shop_type">
					<option value="'.$ShopSemiElement['category'].'" selected>'.$Tipo.'</option>
					<option disabled>-----</option>
					<option value="1">Coins</option>
					<option value="2">Vips</option>
					<option value="3">Sword</option>
					<option value="4">Axe</option>
					<option value="5">Mace</option>
					<option value="6">Spear</option>
					<option value="7">Bow</option>
					<option value="8">Staff</option>
					<option value="9">Shield</option>
					<option value="10">Helm</option>
					<option value="11">Armor</option>
					<option value="12">Pants</option>
					<option value="13">Gloves</option>
					<option value="14">Boots</option>
					<option value="15">Set</option>
					<option value="16">Wings</option>
					<option value="17">Otros</option>
				</select></td>';
				echo '<td><input type="text" name="shop_name" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['name'].'"/></td>';
				echo '<td><input type="text" name="shop_img" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['img'].'"/></td>';
				echo '<td><input type="text" name="shop_descripcion" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['descripcion'].'"/></td>';
				echo '<td><input type="text" name="shop_pricemp" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['pricemp'].'"/></td>';
				echo '<td><input type="text" name="shop_linkmp" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['linkmp'].'"/></td>';
				echo '<td><input type="text" name="shop_pricepp" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['pricepp'].'"/></td>';
				echo '<td><input type="text" name="shop_linkpp" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['linkpp'].'"/></td>';
				echo '<td><input type="text" name="shop_pricebcp" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['pricebcp'].'"/></td>';
				echo '<td><input type="text" name="shop_linkbcp" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['linkbcp'].'"/></td>';
				echo '<td><input type="text" name="shop_colorbg" class="form-control" style="text-align:center;" value="'.$ShopSemiElement['colorbg'].'"/></td>';
				echo '<td class="text-center" style="vertical-align:middle;">';
                    echo '<label class="radio-inline" style="padding:unset !important;">';
                        echo '<input type="checkbox" name="shop_classic" value="1" '.($ShopSemiElement['classic'] ? 'checked' : '').'>';
                    echo '</label>';
                echo '</td>';
				echo '<td class="text-center" style="vertical-align:middle;"><button type="submit" name="shop_submit" value="ok" class="btn btn-primary">Guardar</button></td>';
			echo '</tr>';
			echo '</form>';
		}
    echo '</tbody>';
    echo '</table>';	


	echo '<table class="table table-responsive table-condensed table-bordered table-hover table-striped" >';
	echo '<thead>';
        echo '<tr>';
			echo '<th colspan="13" style="text-align:center;">Agregar Nuevo Item</th>';
		echo '</tr>';
		echo '<tr>';
			echo '<th></th>';
			echo '<th style="text-align:center;">Orden</th>';
			echo '<th style="text-align:center;">Categoria</th>';
			echo '<th style="text-align:center;">Nombre</th>';
			echo '<th style="text-align:center;">Imagen</th>';
			echo '<th style="text-align:center;">Descripcion</th>';
			echo '<th style="text-align:center;">Precio MercadoPago</th>';
			echo '<th style="text-align:center;">Link MercadoPago</th>';
			echo '<th style="text-align:center;">Precio PayPal</th>';
			echo '<th style="text-align:center;">ID Boton PayPal</th>';
			echo '<th style="text-align:center;">Precio BCP</th>';
			echo '<th style="text-align:center;">Link BCP</th>';
			echo '<th style="text-align:center;">Color BG</th>';
			echo '<th style="text-align:center;">Estilo Clasico</th>';
			echo '<th></th>';
		echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
		echo '<form action="?module=shopsemi" method="post">';
		echo '<tr>';		
		echo '<form action="?module=shopsemi" method="post">';
			echo '<tr>';
				echo '<td class="text-center" style="vertical-align:middle;"><a href="?module=shopsemi&delete='.$id.'" class="btn btn-danger btn-xs"><span class="fa fa-times" aria-hidden="true"></span></a></td>';
				echo '<td style="max-width:70px;"><input type="text" name="shop_order" class="form-control"/></td>';

				echo '<td style="text-align:center;"><select class="form-control form-control-lg" name="shop_type" id="shop_type">
					<option selected>Categoria</option>
					<option disabled>-----</option>
					<option value="1">Coins</option>
					<option value="2">Vips</option>
					<option value="3">Sword</option>
					<option value="4">Axe</option>
					<option value="5">Mace</option>
					<option value="6">Spear</option>
					<option value="7">Bow</option>
					<option value="8">Staff</option>
					<option value="9">Shield</option>
					<option value="10">Helm</option>
					<option value="11">Armor</option>
					<option value="12">Pants</option>
					<option value="13">Gloves</option>
					<option value="14">Boots</option>
					<option value="15">Set</option>
					<option value="16">Wings</option>
					<option value="17">Otros</option>
				</select></td>';
                echo '<td><input type="text" name="shop_name" class="form-control" /></td>';
                echo '<td><input type="text" name="shop_img" class="form-control" /></td>';
                echo '<td><input type="text" name="shop_descripcion" class="form-control" /></td>';
                echo '<td><input type="text" name="shop_pricemp" class="form-control" /></td>';
                echo '<td><input type="text" name="shop_linkmp" class="form-control" /></td>';
                echo '<td><input type="text" name="shop_pricepp" class="form-control" /></td>';
                echo '<td><input type="text" name="shop_linkpp" class="form-control" /></td>';
				echo '<td><input type="text" name="shop_pricebcp" class="form-control" /></td>';
                echo '<td><input type="text" name="shop_linkbcp" class="form-control" /></td>';
                echo '<td><input type="text" name="shop_colorbg" class="form-control" /></td>';

				echo '<td class="text-center" style="vertical-align:middle;">';
					echo '<label class="radio-inline">';
						echo '<input type="checkbox" name="shop_classic" value="1">';
					echo '</label>';
				echo '</td>';

				echo '<td class="text-center" style="vertical-align:middle;"><button type="submit" name="new_submit" value="ok" class="btn btn-success">Agregar</button></td>';
			echo '</tr>';
			echo '</form>';
	echo '</tbody>';
	echo '</table>';
	
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}
