<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">[Webshop] Agregar Items</h1>
<?php
	$database = (config('SQL_USE_2_DB',true) ? $dB2 : $dB);
	
	if(check_value($_POST['submit_add'])) {
		try {
			if(!check_value($_POST['item_index'])) throw new Exception("<b>[Webshop]</b> Por favor no dejes ningun campo vacio.");
			if(!check_value($_POST['item_name'])) throw new Exception("<b>[Webshop]</b> Por favor no dejes ningun campo vacio.");
			if(!check_value($_POST['item_descripcion'])) throw new Exception("<b>[Webshop]</b> Por favor no dejes ningun campo vacio.");
			if(!check_value($_POST['item_precio'])) throw new Exception("<b>[Webshop]</b> Por favor no dejes ningun campo vacio.");
			if(!check_value($_POST['item_x'])) throw new Exception("<b>[Webshop]</b> Por favor no dejes ningun campo vacio.");
			if(!check_value($_POST['item_y'])) throw new Exception("<b>[Webshop]</b> Por favor no dejes ningun campo vacio.");

			$AddItemData = array(
				'iGroup' 				=> $_POST['item_group'],
				'iIndex' 				=> $_POST['item_index'],
				'iName' 				=> $_POST['item_name'],
				'iDesc' 				=> $_POST['item_descripcion'],
				'iPrice' 				=> $_POST['item_precio'],
				'iActivo' 				=> $_POST['item_activo'] == 1 ? 1 : 0,
				'iSocket' 				=> $_POST['item_socket'] == 1 ? 1 : 0,
				'iHarmony' 				=> $_POST['item_harmony'] == 1 ? 1 : 0,
				'iAncient' 				=> $_POST['item_ancient'],
				'iOp380' 				=> $_POST['item_op380'] == 1 ? 1 : 0,
				'iMinLevel' 			=> $_POST['item_minlevel'],
				'iMaxLevel' 			=> $_POST['item_maxlevel'],
				'iMinLevelLife' 		=> $_POST['item_minlevellife'],
				'iMaxLevelLife' 		=> $_POST['item_maxlevellife'],
				'iMinOpExe' 			=> $_POST['item_minopexe'],
				'iMaxOpExe' 			=> $_POST['item_maxopexe'],
				'iMaxSockets' 			=> $_POST['item_maxsockets'],
				'iItemX'				=> $_POST['item_x'],
				'iItemY'				=> $_POST['item_y'],
			);
			
			$addItem = $database->query("INSERT INTO WEBENGINE_ITEMS_WEBSHOP (iGrupo, iIndex, Name, Descripcion, Precio, Activo, Socket, Harmony, Ancient, Op380, MinLevel, MaxLevel, MinLevelLife, MaxLevelLife, MinOpExe, MaxOpExe, MaxSockets, X, Y) VALUES (:iGroup, :iIndex, :iName, :iDesc, :iPrice, :iActivo, :iSocket, :iHarmony, :iAncient, :iOp380, :iMinLevel, :iMaxLevel, :iMinLevelLife, :iMaxLevelLife, :iMinOpExe, :iMaxOpExe, :iMaxSockets, :iItemX, iItemY)", $AddItemData);
			if(!$addItem) throw new Exception("<b>[Webshop]</b> No se pudo agregar el item.");
			
			message('success', '<b>[Webshop]</b> El item fue agregado correctamente.');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
?>
<div class="row">
	<div class="col-md-6">
		<div class="card">
			<div class="card-body">
				<form action="" method="post" role="form">

				<div class="input-group mb-3">
					<label class="input-group-text" for="CategoriaSelect">Categoria</label>
					<select class="form-select" id="CategoriaSelect" name="item_group">
						<option value="0" selected>Sword</option>
						<option value="1">Axes</option>
						<option value="2">Maces</option>
						<option value="3">Spears</option>
						<option value="4">Bows</option>
						<option value="5">Staffs</option>
						<option value="6">Shields</option>
						<option value="7">Helmets</option>
						<option value="8">Armors</option>
						<option value="9">Pants</option>
						<option value="10">Gloves</option>
						<option value="11">Boots</option>
						<option value="12">Wings</option>
						<option value="13">Jewel/Misc</option>
						<option value="14">Wings and Orbs and Spheres</option>
						<option value="15">Scrolls</option>
					</select>
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text">Index</span>
					<input type="number" class="form-control" name="item_index" aria-label="Index" placeholder="Index de Item">
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text">Nombre</span>
					<input type="text" class="form-control" name="item_name" aria-label="Nombre" placeholder="Coloque el Nombre de Item">
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text">Descripcion</span>
					<input type="text" class="form-control" name="item_descripcion" aria-label="Descripcion" placeholder="Coloque una Descripcion para Item">
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text">Precio</span>
					<input type="number" class="form-control" name="item_precio" aria-label="Precio" placeholder="Coloque el Precio del Item">
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text" style="width:10%;">Activo</span>
					<input class="form-check-input form-control" type="checkbox" value="1" id="item_activo" name="item_activo" style="margin-top:0;width:1%;">
					<span class="input-group-text text-muted" style="width:79%;">[ Mostrar o no en el Webshop ]</span>
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text" style="width:10%;">Socket</span>
					<input class="form-check-input form-control" type="checkbox" value="1" id="item_socket" name="item_socket" style="margin-top:0;width:1%;">
					<span class="input-group-text text-muted" style="width:79%;">[ El item puede usar Sockets ]</span>
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text" style="width:10%;">Harmony</span>
					<input class="form-check-input form-control" type="checkbox" value="1" id="item_harmony" name="item_harmony" style="margin-top:0;width:1%;">
					<span class="input-group-text text-muted" style="width:79%;">[ El item puede usar Harmony ]</span>
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text" style="width:10%;">Op380</span>
					<input class="form-check-input form-control" type="checkbox" value="1" id="item_op380" name="item_op380" style="margin-top:0;width:1%;">
					<span class="input-group-text text-muted" style="width:79%;">[ El item puede usar Opcion 380 ]</span>
				</div>
				<div class="input-group mb-3">
					<label class="input-group-text" for="item_ancient">Ancient</label>
					<select class="form-select" id="item_ancient" name="item_ancient">
						<option value="0" selected>Ninguno</option>
						<option value="1">1 Set</option>
						<option value="2">2 Sets</option>
					</select>
					<span class="input-group-text text-muted">[ Cuantos Sets ACC tiene el Item ]</span>
				</div>
				<div class="input-group mb-3">
					<label class="input-group-text" for="MinLevel">Nivel Minimo</label>
					<select class="form-select" id="MinLevel" name="item_minlevel">
						<option value="0" selected>+ 0</option>
						<option value="1">+ 1</option>
						<option value="2">+ 2</option>
						<option value="3">+ 3</option>
						<option value="4">+ 4</option>
						<option value="5">+ 5</option>
						<option value="6">+ 6</option>
						<option value="7">+ 7</option>
						<option value="8">+ 8</option>
						<option value="9">+ 9</option>
						<option value="10">+ 10</option>
						<option value="11">+ 11</option>
						<option value="12">+ 12</option>
						<option value="13">+ 13</option>
						<option value="14">+ 14</option>
						<option value="15">+ 15</option>
					</select>
					<span class="input-group-text text-muted">[ Minimo nivel de item para ser Comprado ]</span>
				</div>
				<div class="input-group mb-3">
					<label class="input-group-text" for="MaxLevel">Nivel Maximo</label>
					<select class="form-select" id="MaxLevel" name="item_maxlevel">
						<option value="0" selected>+ 0</option>
						<option value="1">+ 1</option>
						<option value="2">+ 2</option>
						<option value="3">+ 3</option>
						<option value="4">+ 4</option>
						<option value="5">+ 5</option>
						<option value="6">+ 6</option>
						<option value="7">+ 7</option>
						<option value="8">+ 8</option>
						<option value="9">+ 9</option>
						<option value="10">+ 10</option>
						<option value="11">+ 11</option>
						<option value="12">+ 12</option>
						<option value="13">+ 13</option>
						<option value="14">+ 14</option>
						<option value="15">+ 15</option>
					</select>
					<span class="input-group-text text-muted">[ Maximo nivel de item para ser Comprado ]</span>
				</div>

				<div class="input-group mb-3">
					<label class="input-group-text" for="MinLevelLife">Opcion Life Minimo</label>
					<select class="form-select" id="MinLevelLife" name="item_minlevellife">
						<option value="0" selected>+ 0</option>
						<option value="1">+ 4</option>
						<option value="2">+ 8</option>
						<option value="3">+ 12</option>
						<option value="4">+ 16</option>
						<option value="5">+ 20</option>
						<option value="6">+ 24</option>
						<option value="7">+ 28</option>
					</select>
					<span class="input-group-text text-muted">[ Minimo nivel de Opcion Life para ser Comprado ]</span>
				</div>
				<div class="input-group mb-3">
					<label class="input-group-text" for="MaxLevelLife">Opcion Life Maximo</label>
					<select class="form-select" id="MaxLevelLife" name="item_maxlevellife">
						<option value="0" selected>+ 0</option>
						<option value="1">+ 4</option>
						<option value="2">+ 8</option>
						<option value="3">+ 12</option>
						<option value="4">+ 16</option>
						<option value="5">+ 20</option>
						<option value="6">+ 24</option>
						<option value="7">+ 28</option>
					</select>
					<span class="input-group-text text-muted">[ Maximo nivel de Opcion Life para ser Comprado ]</span>
				</div>
				<div class="input-group mb-3">
					<label class="input-group-text" for="MinOpExe">Minimo de Op Exe</label>
					<select class="form-select" id="MinOpExe" name="item_minopexe">
						<option value="0" selected>0 [ Sin Opciones ]</option>
						<option value="1">1 Opcion</option>
						<option value="2">2 Opciones</option>
						<option value="3">3 Opciones</option>
						<option value="4">4 Opciones</option>
						<option value="5">5 Opciones</option>
						<option value="6">6 Opciones</option>
					</select>
					<span class="input-group-text text-muted">[ Minima cantidad de Opciones Exe para ser Comprado ]</span>
				</div>
				<div class="input-group mb-3">
					<label class="input-group-text" for="MaxOpExe">Maximo de Op Exe</label>
					<select class="form-select" id="MaxOpExe" name="item_maxopexe">
						<option value="0" selected>0 [ Sin Opciones ]</option>
						<option value="1">1 Opcion</option>
						<option value="2">2 Opciones</option>
						<option value="3">3 Opciones</option>
						<option value="4">4 Opciones</option>
						<option value="5">5 Opciones</option>
						<option value="6">6 Opciones</option>
					</select>
					<span class="input-group-text text-muted">[ Maxima cantidad de Opciones Exe para ser Comprado ]</span>
				</div>
				<div class="input-group mb-3">
					<label class="input-group-text" for="MaxOpSocket">Maximo de Op Sockets</label>
					<select class="form-select" id="MaxOpSocket" name="item_maxsockets">
						<option value="0" selected>Sin Opcion Socket</option>
						<option value="1">1 Opcion Socket</option>
						<option value="2">2 Opciones Sockets</option>
						<option value="3">3 Opciones Sockets</option>
						<option value="4">4 Opciones Sockets</option>
						<option value="5">5 Opciones Sockets</option>
					</select>
					<span class="input-group-text text-muted">[ Maxima cantidad de Opciones Sockets para ser Comprado ]</span>
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text">Ancho de Item (X)</span>
					<input type="number" class="form-control" name="item_x" aria-label="x" placeholder="Ancho de Slot de Item">
				</div>
				<div class="input-group mb-3">
					<span class="input-group-text">Alto de Item (Y)</span>
					<input type="number" class="form-control" name="item_y" aria-label="x" placeholder="Alto de Slot de Item">
				</div>
					<input type="submit" name="submit_add" class="btn btn-primary" value="Agregar Item"/>
				</form>
			</div>
		</div>
	</div>
</div>