<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">Shop - Configuracion de Items</h1>
<?php
try{


	$database = (config('SQL_USE_2_DB',true) ? $dB2 : $dB);

	$ClassShop	= new WebShopNew();
	
	if(check_value($_GET['eliminar'])) {
		try {
			if(!Validator::UnsignedNumber($_GET['eliminar'])) throw new Exception("<b>[Webshop]</b> El ID del item a eliminar es invailido.");
			
			$ItemInfo = $database->query_fetch_single("SELECT * FROM WEBENGINE_ITEMS_WEBSHOP WHERE Id = ?", array($_GET['eliminar']));
			if(!is_array($ItemInfo)) throw new Exception("<b>[Webshop]</b> El Item no existe.");

			// Eliminar Item
			$database->query("DELETE FROM WEBENGINE_ITEMS_WEBSHOP WHERE Id = ?", array($_GET['eliminar']));
			
			message('success', '<b>[Webshop]</b> El item fue eliminado correctamente.');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
	if(check_value($_POST['editar_submit'])) {
		try {
			$Item_ID				=			$_POST['item_id'];
			$Item_Group				=			$_POST['item_iGrupo'];
			$Item_iIndex			=			$_POST['item_iIndex'];
			$Item_Name				=			$_POST['item_Name'];
			$Item_Descripcion		=			$_POST['item_Descripcion'];
			$Item_Precio			=			$_POST['item_Precio'];
			$Item_Activo			=			$_POST['item_Activo'] == 1 ? 1 : 0;
			$Item_Socket			=			$_POST['item_Socket'] == 1 ? 1 : 0;
			$Item_Harmony			=			$_POST['item_Harmony'] == 1 ? 1 : 0;
			$Item_Ancient			=			$_POST['item_Ancient'];
			$Item_Op380				=			$_POST['item_Op380'] == 1 ? 1 : 0;
			$Item_MinLevel			=			$_POST['item_MinLevel'];
			$Item_MaxLevel			=			$_POST['item_MaxLevel'];
			$Item_MinLevelLife		=			$_POST['item_MinLevelLife'];
			$Item_MaxLevelLife		=			$_POST['item_MaxLevelLife'];
			$Item_MaxSockets		=			$_POST['item_MaxSockets'];
			$Item_MinOpExe			=			$_POST['item_MinOpExe'];
			$Item_MaxOpExe			=			$_POST['item_MaxOpExe'];
			$Item_X					=			$_POST['item_x'];
			$Item_Y					=			$_POST['item_y'];

			$ItemInfo = $database->query_fetch_single("SELECT * FROM WEBENGINE_ITEMS_WEBSHOP WHERE Id = ?", array($Item_ID));
			if(!is_array($ItemInfo)) throw new Exception("<b>[Webshop]</b> El Item no existe.");

			# Editar Item
			$query		=		"UPDATE WEBENGINE_ITEMS_WEBSHOP SET ";
			$query		.=		"iGrupo = ".$Item_Group.", ";
			$query		.=		"iIndex = ".$Item_iIndex.", ";
			$query		.=		"Name = '".$Item_Name."', ";
			$query		.=		"Descripcion = '".$Item_Descripcion."', ";
			$query		.=		"Precio = ".$Item_Precio.", ";
			$query		.=		"Activo = ".$Item_Activo.", ";
			$query		.=		"Socket = ".$Item_Socket.", ";
			$query		.=		"Harmony = ".$Item_Harmony.", ";
			$query		.=		"Ancient = ".$Item_Ancient.", ";
			$query		.=		"Op380 = ".$Item_Op380.", ";
			$query		.=		"MinLevel = ".$Item_MinLevel.", ";
			$query		.=		"MaxLevel = ".$Item_MaxLevel.", ";
			$query		.=		"MinLevelLife = ".$Item_MinLevelLife.", ";
			$query		.=		"MaxLevelLife = ".$Item_MaxLevelLife.", ";
			$query		.=		"MaxSockets = ".$Item_MaxSockets.", ";
			$query		.=		"MinOpExe = ".$Item_MinOpExe.", ";
			$query		.=		"MaxOpExe = ".$Item_MaxOpExe." ";
			$query		.=		"X = ".$Item_X." ";
			$query		.=		"Y = ".$Item_Y." ";
			$query		.=		"WHERE Id = ".$Item_ID."";		

			$database->query($query);						
			message('success', '<b>[Webshop]</b> El item fue editado correctamente.');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
?>
<div class="row">
	<div class="col-md-12">
		<div class="panel-body">
				<div class="tab-pane"><br />
				<?php
					$ListItems = $ClassShop->ObtainItemsEditor();
					if(is_array($ListItems)) {
		echo '<div class="row">';
			echo '<div class="col-md-12">';
				echo '<div class="card">';
					echo '<div class="card-body">';
						echo '<h3>Lista de Items</h3>';
						echo '<div class="table-responsive">';
						echo '<table id="zero_config" class="table table-striped table-sm align-middle">';
							echo '<thead class="table-dark text-white text-center">';
							echo '<tr>';
								echo '<th style="color:#f1f1f1;"></th>';
								echo '<th style="color:#f1f1f1;">Grupo</th>';
								echo '<th style="color:#f1f1f1;">Index</th>';
								echo '<th style="color:#f1f1f1;" width="20%">Nombre</th>';
								echo '<th style="color:#f1f1f1;">Descripcion</th>';
								echo '<th style="color:#f1f1f1;">Precio</th>';
								echo '<th style="color:#f1f1f1;">Activo</th>';
								echo '<th style="color:#f1f1f1;">Socket</th>';
								echo '<th style="color:#f1f1f1;">Harmony</th>';
								echo '<th style="color:#f1f1f1;">Ancient</th>';
								echo '<th style="color:#f1f1f1;">Op380</th>';
								echo '<th style="color:#f1f1f1;">MinLevel</th>';
								echo '<th style="color:#f1f1f1;">MaxLevel</th>';
								echo '<th style="color:#f1f1f1;">MinLevelLife</th>';
								echo '<th style="color:#f1f1f1;">MaxLevelLife</th>';
								echo '<th style="color:#f1f1f1;">MaxSockets</th>';
								echo '<th style="color:#f1f1f1;">MinOpExe</th>';
								echo '<th style="color:#f1f1f1;">MaxOpExe</th>';
								echo '<th style="color:#f1f1f1;" width="20%">X</th>';
								echo '<th style="color:#f1f1f1;" width="20%">Y</th>';
								echo '<th style="color:#f1f1f1;">Item</th>';
								echo '<th style="color:#f1f1f1;"></th>';
							echo '</tr>';
							echo '</thead>';
							echo '<tbody>';
							foreach($ListItems as $Items) {
								echo '<tr>';
									echo '<form action="?module=webshop_items_edit" method="post">';
									echo '<input type="hidden" name="item_id" value="'.$Items['Id'].'"/>';
										echo '<td class="text-center" style="vertical-align:middle;"><a href="index.php?module='.$_REQUEST['module'].'&eliminar='.$Items['Id'].'" class="btn btn-danger btn-xs"><span class="fa fa-times" aria-hidden="true"></span></a></td>';
										echo '<td><input type="text" name="item_iGrupo" class="form-control" style="text-align:center;" value="'.$Items['iGrupo'].'"/></td>';
										echo '<td><input type="text" name="item_iIndex" class="form-control" style="text-align:center;" value="'.$Items['iIndex'].'"/></td>';
										echo '<td><input type="text" name="item_Name" class="form-control" style="text-align:center;width:unset !important;" value="'.$Items['Name'].'"/></td>';
										echo '<td><input type="text" name="item_Descripcion" class="form-control" style="text-align:center;width:unset !important;" value="'.$Items['Descripcion'].'"/></td>';
										echo '<td><input type="text" name="item_Precio" class="form-control" style="text-align:center;width:unset !important;" value="'.$Items['Precio'].'"/></td>';
										echo '<td class="text-center" style="vertical-align:middle;">';
											echo '<label class="radio-inline" style="padding:unset !important;">';
												echo '<input type="checkbox" name="item_Activo" value="1" '.($Items['Activo'] ? 'checked' : '').'>';
											echo '</label>';
										echo '</td>';
										echo '<td class="text-center" style="vertical-align:middle;">';
											echo '<label class="radio-inline" style="padding:unset !important;">';
												echo '<input type="checkbox" name="item_Socket" value="1" '.($Items['Socket'] ? 'checked' : '').'>';
											echo '</label>';
										echo '</td>';
										echo '<td class="text-center" style="vertical-align:middle;">';
											echo '<label class="radio-inline" style="padding:unset !important;">';
												echo '<input type="checkbox" name="item_Harmony" value="1" '.($Items['Harmony'] ? 'checked' : '').'>';
											echo '</label>';
										echo '</td>';
										echo '<td><input type="number" name="item_Ancient" class="form-control" style="text-align:center;" value="'.$Items['Ancient'].'"/></td>';
										echo '<td class="text-center" style="vertical-align:middle;">';
											echo '<label class="radio-inline" style="padding:unset !important;">';
												echo '<input type="checkbox" name="item_Op380" value="1" '.($Items['Op380'] ? 'checked' : '').'>';
											echo '</label>';
										echo '</td>';
										echo '<td><input type="number" name="item_MinLevel" class="form-control" style="text-align:center;" value="'.$Items['MinLevel'].'"/></td>';
										echo '<td><input type="number" name="item_MaxLevel" class="form-control" style="text-align:center;" value="'.$Items['MaxLevel'].'"/></td>';
										echo '<td><input type="number" name="item_MinLevelLife" class="form-control" style="text-align:center;" value="'.$Items['MinLevelLife'].'"/></td>';
										echo '<td><input type="number" name="item_MaxLevelLife" class="form-control" style="text-align:center;" value="'.$Items['MaxLevelLife'].'"/></td>';
										echo '<td><input type="number" name="item_MaxSockets" class="form-control" style="text-align:center;" value="'.$Items['MaxSockets'].'"/></td>';
										echo '<td><input type="number" name="item_MinOpExe" class="form-control" style="text-align:center;" value="'.$Items['MinOpExe'].'"/></td>';
										echo '<td><input type="number" name="item_MaxOpExe" class="form-control" style="text-align:center;" value="'.$Items['MaxOpExe'].'"/></td>';
										echo '<td><input type="number" name="item_x" class="form-control" style="text-align:center;width:70px !important;" value="'.$Items['X'].'"/></td>';
										echo '<td><input type="number" name="item_y" class="form-control" style="text-align:center;width:70px !important;" value="'.$Items['Y'].'"/></td>';
										echo '<td><span style="text-align:center;">'.$Items['Name'].'</span></td>';

										echo '<td><button type="submit" name="editar_submit" id="editar_submit" value="ok" class="btn btn-primary btn-xs">Editar</button></td>';	
									echo '</form>';
								echo '</tr>';
							}
						echo '</tbody>';
						echo '</table>';

						echo '</div>';

					echo '</div>';
				echo '</div>';
			echo '</div>';
		echo '</div>';			
					} else {
						message('warning', 'No hay datos.', ' ');
					}
}catch(Exception $ex) {
	message('error', $ex->getMessage());
}
				?>
				</div>
		</div>
	</div>
</div>