<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
?>
<h1 class="page-header">Shop - Logs</h1>
<?php
try{
	$database = (config('SQL_USE_2_DB',true) ? $dB2 : $dB);

	$ClassShop	= new WebShopNew();
	
	if(check_value($_GET['eliminar'])) {
		try {
			if(!Validator::UnsignedNumber($_GET['eliminar'])) throw new Exception("<b>[Webshop]</b> El ID del log a eliminar es invailido.");
			
			$ItemInfo = $database->query_fetch_single("SELECT * FROM WEBENGINE_WEBSHOP_LOGS WHERE id = ?", array($_GET['eliminar']));
			if(!is_array($ItemInfo)) throw new Exception("<b>[Webshop]</b> El Log no existe.");

			// Eliminar log
			$database->query("DELETE FROM WEBENGINE_WEBSHOP_LOGS WHERE id = ?", array($_GET['eliminar']));
			
			message('success', '<b>[Webshop]</b> El log fue eliminado correctamente.');
		} catch(Exception $ex) {
			message('error', $ex->getMessage());
		}
	}
	
?>
<div class="row">
	<div class="col-md-12">
	<!-- Modal -->

		<div class="panel-body">
				<div class="tab-pane"><br />
				<?php
					$ListLogs = $ClassShop->GetLogs();
					if(is_array($ListLogs)) {
		echo '<div class="row">';
			echo '<div class="col-md-12">';
				echo '<div class="card">';
					echo '<div class="card-body">';
						echo '<h3>Ultimos items comprados</h3>';
						echo '<div class="table-responsive">';
						echo '<table id="zero_config" class="table table-striped table-sm align-middle text-center">';
							echo '<thead class="table-dark text-white">';
							echo '<tr>';
								echo '<th style="color:#f1f1f1;"></th>';
								echo '<th style="color:#f1f1f1;">Usuario</th>';
								echo '<th style="color:#f1f1f1;">Personaje</th>';
								echo '<th style="color:#f1f1f1;">Nombre Item</th>';
								echo '<th style="color:#f1f1f1;">Nivel Item</th>';
								echo '<th style="color:#f1f1f1;">Skill</th>';
								echo '<th style="color:#f1f1f1;">Luck</th>';
								echo '<th style="color:#f1f1f1;">Opcion Life</th>';
								echo '<th style="color:#f1f1f1;">Opcion Excelent</th>';
								echo '<th style="color:#f1f1f1;">Ancient</th>';
								echo '<th style="color:#f1f1f1;">Harmony</th>';
								echo '<th style="color:#f1f1f1;">Opcion 380</th>';
								echo '<th style="color:#f1f1f1;">Socket 1</th>';
								echo '<th style="color:#f1f1f1;">Socket 2</th>';
								echo '<th style="color:#f1f1f1;">Socket 3</th>';
								echo '<th style="color:#f1f1f1;">Socket 4</th>';
								echo '<th style="color:#f1f1f1;">Socket 5</th>';
								echo '<th style="color:#f1f1f1;">Precio</th>';
								echo '<th style="color:#f1f1f1;">Moneda</th>';
								echo '<th style="color:#f1f1f1;">Coins Restantes</th>';
								echo '<th style="color:#f1f1f1;">Fecha</th>';
								
							echo '</tr>';
							echo '</thead>';
							echo '<tbody>';
							foreach($ListLogs as $Logs) {
								
								echo '<tr>';
									echo '<form action="?module=shoplouis_logs" method="post">';
									if($Logs['Grupo'] == 6){ $iOptionText = $Logs['OpLife']*5; }
									else { $iOptionText = $Logs['OpLife']*4;  }

									# Opciones Exe
									$OpExe = explode("-", $Logs['OpExe']);

									$Op1 = $OpExe[0];
									$Op2 = $OpExe[1];
									$Op3 = $OpExe[2];
									$Op4 = $OpExe[3];
									$Op5 = $OpExe[4];
									$Op6 = $OpExe[5];

									// Opciones
									if(in_array($Logs['Grupo'], $ClassShop->iType_Weapon_Array)) $TextOp1 = '- Excellent Damage Rate <b class="text-primary">+10%</b>';
									else if(in_array($Logs['Grupo'], $ClassShop->iType_Set_Array)) $TextOp1 = '- Increase Maximun Life <b class="text-primary">+4%</b>';
									if(in_array($Logs['Grupo'], $ClassShop->iType_Weapon_Array)) $TextOp2 = '- Increase Damage <b class="text-primary">+level/20</b>';
									else if(in_array($Logs['Grupo'], $ClassShop->iType_Set_Array)) $TextOp2 = '- Increase Maximun Mana <b class="text-primary">+4%</b>';
									if(in_array($Logs['Grupo'], $ClassShop->iType_Weapon_Array)) $TextOp3 = '- Increase Damage <b class="text-primary">+2%</b>';
									else if(in_array($Logs['Grupo'], $ClassShop->iType_Set_Array)) $TextOp3 = '- Damage Decrease <b class="text-primary">+4%</b>';
									if(in_array($Logs['Grupo'], $ClassShop->iType_Weapon_Array)) $TextOp4 = '- Increase attacking (wizardry) speed <b class="text-primary">+7</b>';
									else if(in_array($Logs['Grupo'], $ClassShop->iType_Set_Array)) $TextOp4 = '- Reflect Damage <b class="text-primary">+5%</b>';
									if(in_array($Logs['Grupo'], $ClassShop->iType_Weapon_Array)) $TextOp5 = '- Increase recovery life when kill monster <b class="text-primary">+life/8</b>';
									else if(in_array($Logs['Grupo'], $ClassShop->iType_Set_Array)) $TextOp5 = '- Defense Success Rate <b class="text-primary">+10%</b>';
									if(in_array($Logs['Grupo'], $ClassShop->iType_Weapon_Array)) $TextOp6 = '- Increase recovery mana when kill monster <b class="text-primary">+mana/8</b>';
									else if(in_array($Logs['Grupo'], $ClassShop->iType_Set_Array)) $TextOp6 = '- Increase Zen Drop Rate <b class="text-primary">+70%</b>';

									if($Op1 > 0) $TextExe = "".$TextOp1."<br>";
									if($Op2 > 0) $TextExe .= "".$TextOp2."<br>";
									if($Op3 > 0) $TextExe .= "".$TextOp3."<br>";
									if($Op4 > 0) $TextExe .= "".$TextOp4."<br>";
									if($Op5 > 0) $TextExe .= "".$TextOp5."<br>";
									if($Op6 > 0) $TextExe .= "".$TextOp6."<br>";
									# Fin Opciones exe

									$Luck		=	$Logs['Luck'] ? '<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';
									$Skill		=	$Logs['Skill'] ? '<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';
									$Acc		=	$Logs['Acc'] ? '<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';
									$Harmony	=	$Logs['Harmony'] ? '<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';
									$Op380		=	$Logs['Op380'] ? '<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';
									$Socket1	=	$Logs['Socket1'] != 255 ?	'<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';
									$Socket2	=	$Logs['Socket2'] != 255 ?	'<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';
									$Socket3	=	$Logs['Socket3'] != 255 ?	'<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';
									$Socket4	=	$Logs['Socket4'] != 255 ?	'<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';
									$Socket5	=	$Logs['Socket5'] != 255 ?	'<i class="fas fa-check-circle" style="color:green;"></i>' : '<i class="fas fa-times-circle" style="color:red;"></i>';

										echo '<td class="text-center" style="vertical-align:middle;"><a href="index.php?module='.$_REQUEST['module'].'&eliminar='.$Logs['id'].'" class="btn btn-danger btn-xs"><span class="fa fa-times" aria-hidden="true"></span></a></td>';
										echo '<td><span style="text-align:center;">'.$Logs['Usuario'].'</span></td>';
										echo '<td><span style="text-align:center;">'.$Logs['Personaje'].'</span></td>';
										echo '<td><span style="text-align:center;">'.$Logs['Item'].'</span></td>';
										echo '<td><span style="text-align:center;">+ '.$Logs['NivelItem'].'</span></td>';
										echo '<td><span style="text-align:center;">'.$Skill.'</span></td>';
										echo '<td><span style="text-align:center;">'.$Luck.'</span></td>';
										echo '<td><span style="text-align:center;">+ '.$iOptionText.'</span></td>';
										if($TextExe) echo "<td><button type='button' class='btn btn-lg btn-primary' class='btn btn-primary' data-bs-toggle='modal' data-bs-target='#exampleModal_".$Logs['id']."'><i class='fas fa-eye'></i></button></td>";
										else echo '<td><i class="fas fa-times-circle" style="color:red;"></i></td>';
										echo '<td><span style="text-align:center;">'.$Acc.'</span></td>';
										echo '<td><span style="text-align:center;">'.$Harmony.'</span></td>';
										echo '<td><span style="text-align:center;">'.$Op380.'</span></td>';
										echo '<td><span style="text-align:center;">'.$Socket1.'</span></td>';
										echo '<td><span style="text-align:center;">'.$Socket2.'</span></td>';
										echo '<td><span style="text-align:center;">'.$Socket3.'</span></td>';
										echo '<td><span style="text-align:center;">'.$Socket4.'</span></td>';
										echo '<td><span style="text-align:center;">'.$Socket5.'</span></td>';
										echo '<td><span style="text-align:center;color:green;"><b>'.number_format($Logs['PrecioTotal'],0,',','.').'</b></span></td>';
										echo '<td><span style="text-align:center;"><b>'.$Logs['Moneda'].'</b></span></td>';
										echo '<td><span style="text-align:center;color:red;"><b>'.number_format($Logs['SaldoRestante'],0,',','.').'</b></span></td>';
										echo '<td><span style="text-align:center;">'.$Logs['Fecha'].'</span></td>';
									echo '</form>';
								echo '</tr>';

								echo '<div class="modal fade" id="exampleModal_'.$Logs['id'].'" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
								<div class="modal-dialog modal-dialog-centered">
								  <div class="modal-content">
									<div class="modal-header bg-dark text-white">
									  <h5 class="modal-title" id="exampleModalLabel">'.$Logs['Item'].' <b class="text-primary">+ '.$Logs['NivelItem'].' + '.$iOptionText.'</b></h5>
									  <button type="button" class="btn-close text-primary" data-bs-dismiss="modal" aria-label="Close"></button>
									</div>
									<div class="modal-body">
									<h4>Opciones Excelent</h4><hr>
									  '.$TextExe.'<br> ';
					
									if($Logs['Harmony'] != 0){
										echo '<h4>Opcion Harmony</h4><hr>  ';
										if($Logs['Grupo'] < 5) $ArrayHarmony = $ClassShop->iHarmony_Weapons_Array;
										else if($Logs['Grupo'] == 5) $ArrayHarmony = $ClassShop->iHarmony_Staff_Array;
										else $ArrayHarmony = $ClassShop->iHarmony_Set_Array;
										foreach( $ArrayHarmony as $HarmonyID => $HarmonyOP ){ 
											if($HarmonyID == $Logs['Harmony']) $MiHH = $HarmonyOP;
										}
										echo '<b>Harmony: </b>'.$MiHH.'<br>';
									}  
									if($Logs['Socket1'] != 255){
										if($Logs['Grupo'] < 6) $ArrayOpSockets = $ClassShop->iSocket_Weapons_Array;
										else $ArrayOpSockets = $ClassShop->iSocket_Set_Array;
											echo '<h4>Opciones Sockets</h4><hr>  ';
												foreach( $ArrayOpSockets as $SocketID => $iSocketOP ){ 
													if($SocketID == $Logs['Socket1']) $MiSocket1 = $iSocketOP;
													if($SocketID == $Logs['Socket2']) $MiSocket2 = $iSocketOP;
													if($SocketID == $Logs['Socket3']) $MiSocket3 = $iSocketOP;
													if($SocketID == $Logs['Socket4']) $MiSocket4 = $iSocketOP;
													if($SocketID == $Logs['Socket5']) $MiSocket5 = $iSocketOP;
												}
												echo '<b>Socket 1: </b>'.$MiSocket1.'<br>';
												echo '<b>Socket 2: </b>'.$MiSocket2.'<br>';
												echo '<b>Socket 3: </b>'.$MiSocket3.'<br>';
												echo '<b>Socket 4: </b>'.$MiSocket4.'<br>';
												echo '<b>Socket 5: </b>'.$MiSocket5.'<br>';
									} 
									echo '</div>
									<div class="modal-footer">
									  <button type="button" class="btn btn-primary" data-bs-dismiss="modal">Cerrar</button>
									</div>
								  </div>
								</div>
							  </div>';
							}
						echo '</tbody>';
						echo '</table>';

						echo '</div>';

					echo '</div>';
				echo '</div>';
			echo '</div>';
		echo '</div>';			
					} else {
						message('warning', 'No hay baneados temporalmente en los Logs.', ' ');
					}
}catch(Exception $ex) {
	message('error', $ex->getMessage());
}
				?>
				</div>
		</div>
	</div>
</div>