<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.1
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

try {
	
	// Module status
	if(!mconfig('active')) throw new Exception(lang('error_47',true));
	
	// Changelogs object
	$Changelogs = new Changelogs();
	$cachedChangelogs = loadCache('changelogs.cache');
	if(!is_array($cachedChangelogs)) throw new Exception(lang('error_61'));
	
	// Set changelogs language
	if(config('language_switch_active',true)) {
		if(check_value($_SESSION['language_display'])) {
			$Changelogs->setLanguage($_SESSION['language_display']);
		}
	}
	
	// Single changelogs
	$requestedChangelogsId = $_GET['subpage'];
	if(check_value($requestedChangelogsId) && $Changelogs->changelogsIdExists($requestedChangelogsId)) {
		$showSingleChangelogs = true;
		$changelogsID = $requestedChangelogsId;
	}
	
	// changelogs list
	$i = 0;

	echo '<div class="miniranks"><i class="fas fa-exchange-alt"></i> Changelogs</div>';
	echo '<div class="sidebar-block">';
	echo '<table class="table">';
			echo '<thead>';
				echo '<tr>';
					echo '<th scope="col"></th>';
					echo '<th scope="col">Cambio Realizado</th>';
					echo '<th scope="col" style="text-align:center;">Fecha</th>';
				echo '</tr>';
			echo '</thead>';
			echo '<tbody>';
	foreach($cachedChangelogs as $changelogsArticle) {
		if($showSingleChangelogs) if($changelogsArticle['changelogs_id'] != $changelogsID) continue;
		$Changelogs->setId($changelogsArticle['changelogs_id']);
		
		if($i > mconfig('changelogs_list_limit')) continue;
		
		$changelogs_id = $changelogsArticle['changelogs_id'];
		$changelogs_title = $changelogsArticle['changelogs_title'];
		$changelogs_author = $changelogsArticle['changelogs_author'];
		$changelogs_prefijo = $changelogsArticle['changelogs_prefijo'];
		$changelogs_date = $changelogsArticle['changelogs_date'];
		$changelogs_url = __BASE_URL__.'changelogs/'.$changelogs_id.'/';
		
		if($changelogs_prefijo == 1){
			$ColorBoton = '<button type="button" class="btn btn-success">Agregado</button>';
			$Fondo	= 'class="alert alert-success"';
		}elseif($changelogs_prefijo == 2){
			$ColorBoton = '<button type="button" class="btn btn-warning">Cambiado</button>';
			$Fondo	= 'class="alert alert-warning"';
		}elseif($changelogs_prefijo == 3){
			$ColorBoton = '<button type="button" class="btn btn-info">Arreglado</button>';
			$Fondo	= 'class="alert alert-info"';
		}elseif($changelogs_prefijo == 4){
			$ColorBoton = '<button type="button" class="btn btn-danger">Removido</button>';
			$Fondo	= 'class="alert alert-danger"';
		}

		// translated changelogs title
		if(config('language_switch_active',true)) {
			if(check_value($_SESSION['language_display']) && is_array($changelogsArticle['translations'])) {
				if(array_key_exists($_SESSION['language_display'], $changelogsArticle['translations'])) {
					$changelogs_title = $changelogsArticle['translations'][$_SESSION['language_display']];
				}
			}
		}

		$loadChangelogsCache = $Changelogs->LoadCachedchangelogs();

		echo '<tr '.$Fondo.'>';
			echo '<th scope="row" style="width:15%;text-align:center;">'.$ColorBoton.'</th>';
			echo '<td>'.$loadChangelogsCache.'</td>';
			echo '<td style="text-align:center;width:20%;">'.date("d/m/o",$changelogs_date).'</td>';
		echo '</tr>';

		$i++;
	}
	echo '</tbody>';
	echo '</table>';
	echo '</div>';
} catch(Exception $ex) {
	message('warning', $ex->getMessage());
}