<?php
try {
    (!isLoggedIn()) ? redirect(1,'login') : null;

    // Mercado Pago SDK
    include 'api/mercadopago/vendor/autoload.php';

    // Load Mercadopago Settings Settings
    loadModuleConfigs('mercadopago');
    $ConfigCoins = loadConfig("mp_packs_coin");
    $ConfigVip = loadConfig("mp_packs_vip");

    $common = new common();
    $accountInfo = $common->accountInformation($_SESSION['userid']);

    $token = mconfig('access_token');
    $description= mconfig('mercadopago_desc');
    $user = $accountInfo[_CLMN_USERNM_];
    $ReturnURL =  mconfig('mercadopago_return_url');  
    $ReturnAPI = mconfig('mercadopago_api_return_url'); 

    // Add Your credentials
    MercadoPago\SDK::setAccessToken($token);
    $preference = new MercadoPago\Preference();
    $item = new MercadoPago\Item();
    $item->id = "12345";
    $item->description = $description;
    $item->category_id = "home";
    $item->quantity = 1;
    $preference->back_urls = array(
        "success" => $ReturnURL,
        "failure" => $ReturnURL,
        "pending" => $ReturnURL
    );
    $preference->auto_return = "approved";
    $preference->notification_url = $ReturnAPI;

    echo '<div class="page-content">'; 
    if(mconfig('coins_status') == 1) {
        echo '<div class="donaciones-item border border-primary rounded">';
        echo '<h3 class="bg-primary p-3 text-white rounded"><div class="miniranks"><i class="fas fa-coins"></i> Donaciones por Coins</div></h3>';
                echo '<div class="alert alert-info m-0" role="alert" style="text-align:center;">';
                    echo '<i class="fas fa-exclamation-circle"></i> <b>ATENCION:</b> Al ser efectuado el pago, los <i class="fas fa-coins"></i> <b>COINS</b> seran acreditados automaticamente.';
                echo '</div>';
        echo '<div class="card-body">';
            echo '<div class="row">';	
            $creditSystem = new CreditSystem();
            foreach ($ConfigCoins as $id => $CoinElement) {
                if ($CoinElement["active"]) {
                    $price = $CoinElement["price"];
                    $amount = $CoinElement["amount"];
                    $type_M = $CoinElement["type_M"];
                    $money 	= $creditSystem->showCredits($type_M);
                    $money_F = $money['config_title'];
                    
                    $item->title = $user.'|'.$amount.'|COINS|'.$type_M;
                    $item->unit_price = $price;
                    $preference->items = array($item);
                    $preference->external_reference = $id;
                    $preference->save();
                    
                    echo '<div class="col-md-4 col-sm-12 p-2 col-12">';
                        echo '<div class="card">';
                            echo '<div class="card-footer">';
                                echo '<p class="card-text text-center text-uppercase"><span class="text-primary"><i class="fa-solid fa-database"></i> '.number_format($amount,0,',','.').' '.$money_F.'</span></p>';
                            echo '</div>';
                            echo '<div class="card-img-top d-flex flex-row justify-content-center alig-items-center" style="background-color: #565656 !important;">';
                                echo '<i class="fa-solid fa-coins" style="font-size: 65px;padding: 40px;color: #f1f1f1;"></i>';
                            echo '</div>';	
                            echo '<div class="card-body text-center">';
                                echo '<div class="btn btn-outline-primary disabled btn-lg" style="opacity:1;"><b>$'.number_format($price,0,',','.').' ARS</b></div>';
                            echo '</div>';
                            echo '<div class="card-footer">';
                                echo '<div class="row">';  
                                    echo '<div class="col-md-12 col-12 align-self-center text-center mb-1 botones-donaciones">';
                                        echo '<a class="btn btn-primary" href="'.$preference->init_point.'" target="_blank">Donar!</a>';
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                }
            }
            
            echo '</div>';
        echo '</div>';    
        echo '</div>';
        echo '<br>';
    }
    if(mconfig('vip_status') == 1){
        echo '<div class="donaciones-item border border-primary rounded">';
        echo '<h3 class="bg-primary p-3 text-white rounded"><div class="miniranks"><i class="fas fa-star"></i> Donaciones por Vip</div></h3>';
                echo '<div class="alert alert-warning m-0" role="alert" style="text-align:center;">';
                    echo '<i class="fas fa-exclamation-circle"></i> <b>ATENCION:</b> Al ser efectuado el pago, el <i class="fas fa-star"></i> <b>VIP</b> sera activado automaticamente.';
                echo '</div>';
        echo '<div class="card-body">';
            echo '<div class="row">';    
            foreach ($ConfigVip as $id => $VipElement) {
                if ($VipElement["active"]) {
                    $price = $VipElement["price"];
                    $amount = $VipElement["amount"];
                    $type_V = $VipElement["type_V"];

                    if($type_V == 1) { $Vip = 'Bronce'; $ColorVip = '813a01'; }
                    else if($type_V == 2) { $Vip = 'Plata'; $ColorVip = '818181'; }
                    else if($type_V == 3) { $Vip = 'Oro'; $ColorVip = 'fba900'; }

                    $item->title = $user.'|'.$amount.'|VIP|'.$type_V;
                    $item->unit_price = $price;
                    $preference->items = array($item);
                    $preference->save();
                    
                    echo '<div class="col-md-4 col-sm-12 p-2 col-12">';
                        echo '<div class="card">';
                            echo '<div class="card-footer">';
                                echo '<p class="card-text text-center text-uppercase"><span class="text-primary"><i class="fas fa-star"></i> '.number_format($amount,0,',','.').' dias Vip '.$Vip.'</span></p>';
                            echo '</div>';
                            echo '<div class="card-img-top d-flex flex-row justify-content-center alig-items-center" style="background-color: #'.$ColorVip.' !important;">';
                                echo '<i class="fa-solid fa-star" style="font-size: 65px;padding: 40px;color: #f1f1f1;"></i>';
                            echo '</div>';	
                            echo '<div class="card-body text-center">';
                                echo '<div class="btn btn-outline-primary disabled btn-lg" style="opacity:1;"><b>$'.number_format($price,0,',','.').' ARS</b></div>';
                            echo '</div>';
                            echo '<div class="card-footer">';
                                echo '<div class="row">';  
                                    echo '<div class="col-md-12 col-12 align-self-center text-center mb-1 botones-donaciones">';
                                        echo '<a class="btn btn-primary" href="'.$preference->init_point.'" target="_blank">Donar!</a>';
                                    echo '</div>';
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                    echo '</div>';
                }
            }
            
            echo '</div>';
        echo '</div>';
        echo '</div>';
    }
        
        
        
    echo '<hr>';
        echo '<div class="alert alert-info">';
            echo '<i class="fa fa-child mr-2"></i><strong>¿Sabías que...?</strong> Las donaciones son el pilar fundamental de nuestra comunidad. Ésto quiere decir que gracias a vos, ¡AIFOSMu sigue existiendo!.<br>Cada donación va destinada a un fondo común con el fin de cubrir mensualmente gastos para el mantenimiento de todos nuestros servidores: costos de alojamiento (servidores y webs), licencias de software de seguridad, campañas publicitarias y desarrollo constante. Tu aporte es el granito de arena para poder seguir creciendo como comunidad. Por eso te decimos <strong>¡GRACIAS POR AYUDARNOS A SEGUIR! <i class="fa fa-heart"></i></strong>';	
        echo '</div>';
        echo '<div class="alert alert-warning">';
            echo '<i class="fas fa-exclamation-circle mr-2"></i>';
            echo '<strong>Importante:</strong> la demora de entrega de <b>Coins</b> y/o <b>Vip</b> puede ser de hasta 24hs (hábiles), dependiendo siempre del medio de pago que se utilice (Esto aplica si lo hacen mediante <b>PagoFacil</b> / <b>RapiPago</b>). Nunca hagas un reclamo antes de las 24 horas (hábiles). Por favor, sé paciente y respeta los tiempos establecidos.';
                
            echo '</div>';	
    echo '</div>';
} catch (Exception $ex) {
    message("error", $ex->getMessage());
}
?>
