<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.1
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

try {
	
	// Module status
	if(!mconfig('active')) throw new Exception(lang('error_47',true));
	
	// guides object
	$Guides = new Guides();
	$cachedGuides = loadCache('guides.cache');
	if(!is_array($cachedGuides)) throw new Exception(lang('error_61'));
	
	// Set guides language
	if(config('language_switch_active',true)) {
		if(check_value($_SESSION['language_display'])) {
			$Guides->setLanguage($_SESSION['language_display']);
		}
	}
	
	// Single guides
	$requestedGuidesId = $_GET['subpage'];
	if(check_value($requestedGuidesId) && $Guides->guidesIdExists($requestedGuidesId)) {
		$showSingleGuides = true;
		$guidesID = $requestedGuidesId;
	}
	
	// guides list
	$i = 0;
	foreach($cachedGuides as $guidesArticle) {
		if($showSingleGuides) if($guidesArticle['guides_id'] != $guidesID) continue;
		$Guides->setId($guidesArticle['guides_id']);
		
		if($i > mconfig('guides_list_limit')) continue;
		
		$guides_id = $guidesArticle['guides_id'];
		$guides_title = $guidesArticle['guides_title'];
		$guides_author = $guidesArticle['guides_author'];
		$guides_date = $guidesArticle['guides_date'];
		$guides_url = __BASE_URL__.'guides/'.$guides_id.'/';
		
		// translated guides title
		if(config('language_switch_active',true)) {
			if(check_value($_SESSION['language_display']) && is_array($guidesArticle['translations'])) {
				if(array_key_exists($_SESSION['language_display'], $guidesArticle['translations'])) {
					$guides_title = $guidesArticle['translations'][$_SESSION['language_display']];
				}
			}
		}
		
		if(mconfig('guides_short')) {
			if($showSingleGuides) {
				$loadGuidesCache = $Guides->LoadCachedGuides();
			} else {
				$loadGuidesCache = $Guides->LoadCachedGuides(true);
				$loadGuidesCache .= '<a href="'.$guides_url.'" class="news-readmore">' . lang('guides_txt_3') . '</a>';
			}
		} else {
			$loadGuidesCache = $Guides->LoadCachedGuides();
		}
		
		echo '<div class="panel panel-news">';
			echo '<div class="panel-heading">';
				echo '<h3 class="panel-title"><a href="'.$guides_url.'">'.$guides_title.'</a></h3>';
			echo '</div>';
			if(mconfig('guides_expanded') > $i) {
				echo '<div class="panel-body">';
					echo $loadGuidesCache;
				echo '</div>';
				echo '<div class="panel-footer">';
					echo '<div class="col-xs-6 nopadding">';
					echo '</div>';
					echo '<div class="col-xs-6 nopadding text-right">';
						echo date("l, F jS Y",$guides_date);
					echo '</div>';
				echo '</div>';
			}
		echo '</div>';
		
		$i++;
	}

} catch(Exception $ex) {
	message('warning', $ex->getMessage());
}