<!DOCTYPE html>
<html lang="en">
<body>
<?php
	$ItemCFG = loadConfig('iteminfo');
	if(!is_array($ItemCFG)) throw new Exception('ItemInfo esta vacio.');

	loadModuleConfigs('iteminfo');

	$showDL 		= mconfig('darklord') ? true : false;
	$showSUM		= mconfig('summoner') ? true : false;
	$showRF 		= mconfig('fighter') ? true : false;


	echo '<div class="alert alert-info" role="alert">
			<h3 style="text-align:center;"><i class="fas fa-info-circle"></i> Informacion</h3>
			<hr>
			<p>
			<i class="fas fa-check" style="color:green;"></i> Significa que esta raza puede usar este item/set.<br>
			<i class="fas fa-times" style="color:red;""></i> Significa que esta raza no puede usar este item/set.</p>
	</div>';

	echo '<table class="table table-striped dataTableChar dataTable no-footer mt-2" style="white-space: nowrap;" id="DropList" role="grid">';
		echo '<thead>';
			echo '<tr>
					<th colspan="4" class="bg-dark text-light text-center table-bordered">Informacion General</td>';

					if(!$showDL){
						echo '<th colspan="4" class="bg-success text-light text-center table-bordered">Puede ser utilizado por</td>';
					}elseif(!$showSUM){
						echo '<th colspan="5" class="bg-success text-light text-center table-bordered">Puede ser utilizado por</td>';
					}elseif(!$showRF){
						echo '<th colspan="6" class="bg-success text-light text-center table-bordered">Puede ser utilizado por</td>';
					}else{
						echo '<th colspan="7" class="bg-success text-light text-center table-bordered">Puede ser utilizado por</td>';
					}
					
			echo '</tr>';
			echo '<tr role="row">';
				echo '<th style="text-align:center;">Tipo</th>';
				echo '<th style="text-align:center;">Item</th>';
				echo '<th style="text-align:center;">DEF</th>';
				echo '<th style="text-align:center;">DMG</th>';
				echo '<th style="text-align:center;">SM</th>';
				echo '<th style="text-align:center;">BK</th>';
				echo '<th style="text-align:center;">ELF</th>';
				echo '<th style="text-align:center;">MG</th>';
			if($showDL) echo '<th style="text-align:center;">DL</th>';
			if($showSUM) echo '<th style="text-align:center;">SUM</th>';
			if($showRF) echo '<th style="text-align:center;">RF</th>';
			echo '</tr>
			</thead>';
	echo '<tbody>';
	foreach($ItemCFG as $id => $DropListElement) {
		$Type			= $DropListElement['type'];	
		$Item			= $DropListElement['name'];	
		$Defense		= $DropListElement['defense'];	
		$Dmg			= $DropListElement['dmg'];	
		$Dmg2			= $DropListElement['dmg2'];	
		$SM 			= $DropListElement['sm'];
		$BK 			= $DropListElement['bk'];
		$ELF 			= $DropListElement['elf'];
		$MG 			= $DropListElement['mg'];
		$DL 			= $DropListElement['dl'];
		$SUM 			= $DropListElement['sum'];
		$RF 			= $DropListElement['rf'];
		$SetMG 			= $DropListElement['setmg'];

		if($Type == 1){
			$Tipo = "Sword";
		}elseif($Type == 2){
			$Tipo = "Axe";
		}elseif($Type == 3){
			$Tipo = "Mace";
		}elseif($Type == 4){
			$Tipo = "Spear";
		}elseif($Type == 5){
			$Tipo = "Bow";
		}elseif($Type == 6){
			$Tipo = "Staff";
		}elseif($Type == 7){
			$Tipo = "Shield";
		}elseif($Type == 8){
			$Tipo = "Set";
		}elseif($Type == 9){
			$Tipo = "Wings";
		}

		$maxLevel 		= mconfig('maxlevel');
		if($maxLevel == 2){
			$DefPlus = 81;
			$DmgPlus = 96;
		}elseif($maxLevel == 1){
			$DefPlus = 64;
			$DmgPlus = 79;
		}elseif($maxLevel == 0){
			$DefPlus = 51;
			$DmgPlus = 66;
		}

		if($SetMG == 1) $PartesSet = 4;
		else $PartesSet = 5;

		if($Type == 9) $DefTotal = $Defense;
		elseif($Type == 8) $DefTotal = $Defense + $DefPlus*$PartesSet;
		else $DefTotal = $Defense + $DefPlus;

		$Dmg1Total = $Dmg + $DmgPlus;
		$Dmg2Total = $Dmg2 + $DmgPlus;

		echo '<tr>';
		echo '<td style="font-weight: 300;text-align: center;">'.$Tipo.'</td>';
		echo '<td style="font-weight: 300;text-align: center;">'.$Item.'</td>';
		if($Defense == 0) echo '<td style="font-weight: bold;text-align: center;">-</td>';
		else echo '<td style="font-weight: bold;text-align: center;">'.$DefTotal.'</td>';
		if($Dmg == 0 || $Dmg2 == 0) echo '<td style="font-weight: bold;text-align: center;">-</td>';
		else echo '<td style="font-weight: bold;text-align: center;">'.$Dmg1Total.' - '.$Dmg2Total.'</td>';

		if($SM) 	echo '<td style="text-align:center;"><i class="fas fa-check" style="color:green;"></i></td>';
		else 		echo '<td style="text-align:center;"><i class="fas fa-times" style="color:red;"></i></td>';

		if($BK) 	echo '<td style="text-align:center;"><i class="fas fa-check" style="color:green;"></i></td>';
		else 		echo '<td style="text-align:center;"><i class="fas fa-times" style="color:red;"></i></td>';

		if($ELF) 	echo '<td style="text-align:center;"><i class="fas fa-check" style="color:green;"></i></td>';
		else 		echo '<td style="text-align:center;"><i class="fas fa-times" style="color:red;"></i></td>';

		if($MG) 	echo '<td style="text-align:center;"><i class="fas fa-check" style="color:green;"></i></td>';
		else 		echo '<td style="text-align:center;"><i class="fas fa-times" style="color:red;"></i></td>';

		if($showDL){
			if($DL) 	echo '<td style="text-align:center;"><i class="fas fa-check" style="color:green;"></i></td>';
			else 		echo '<td style="text-align:center;"><i class="fas fa-times" style="color:red;"></i></td>';
		}
		if($showSUM){
			if($SUM) 	echo '<td style="text-align:center;"><i class="fas fa-check" style="color:green;"></i></td>';
			else 		echo '<td style="text-align:center;"><i class="fas fa-times" style="color:red;"></i></td>';
		}
		if($showRF){
			if($RF) 	echo '<td style="text-align:center;"><i class="fas fa-check" style="color:green;"></i></td>';
			else 		echo '<td style="text-align:center;"><i class="fas fa-times" style="color:red;"></i></td>';
		}
		echo '</tr>';
		

		}
	echo '</tbody>';
echo '</table>';
?>
</body>
</html>
