<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

echo '<div class="page-title"><span>'.lang('profiles_txt_1',true).'</span></div>';

loadModuleConfigs('profiles');
if(mconfig('active')) {
	if(check_value($_GET['req'])) {
		try {
			$weProfiles = new weProfiles();
			$weProfiles->setType("guild");
			$weProfiles->setRequest($_GET['req']);
			$guildData = $weProfiles->data();
			
			$guildMembers = explode(",", $guildData[6]);
			$guildAlli = explode(",", $guildData[7]);
			$displayData = array(
				'gname' => $guildData[1],
				'glogo' => returnGuildLogo($guildData[2],200),
				'gmaster' => $guildData[4],
				'gscore' => $guildData[3],
				'gnotice' => $guildData[5],
				'gmembers' => count($guildMembers),
			);

			$charactersCountry = loadCache('character_country.cache');
			if(!is_array($charactersCountry)) $showPlayerCountry = false;

			
			echo '<div class="table-responsive">';
			echo '<table class="table text-center table-bordered">';
				echo '<thead class="thead-dark">';
					  echo '<tr>';
						echo '<th scope="col" colspan="6"><i class="fas fa-shield-alt"></i> '.$displayData['gname'].'</th>';
					  echo '</tr>';
				echo '</thead>';
				echo '<tbody>';
					echo '<tr>';
						echo '<th rowspan="6">'.$displayData['glogo'].'</th>';
						echo '<th colspan="4" width="70%" style="font-weight:600;font-family: \'Dosis\', sans-serif;font-size:20px;"><i class="fas fa-user-tie"></i> Master</th>';
					echo '</tr>';
					echo '<tr>';
						echo '<td colspan="4" style="font-weight:600;font-family: \'Dosis\', sans-serif;font-size:26px;"><img style="padding-bottom:5px;" src="'.getCountryFlag($charactersCountry[$guildData[4]]).'" height="23"/> '.playerProfile($displayData['gmaster']).' </td>';
					echo '</tr>';
					echo '<tr>';
						echo '<th colspan="4"><i class="fas fa-exclamation-triangle"></i> Noticia del Clan</th>';
					echo '</tr>';
					echo '<tr>';
					if($displayData['gnotice']){
						echo '<td colspan="4" style="font-weight: 700;font-size: 17px;font-family: Roboto, sans-serif;color: green;">'.$displayData['gnotice'].'</td>';
					}else{
						echo '<td colspan="4" style="font-weight: 700;font-size: 17px;font-family: Roboto, sans-serif;color: red;"><i class="fas fa-times"></i>  El guild no tiene noticia.</td>';
					}
					echo '</tr>';
					echo '<tr>';
						echo '<th width="30%"><i class="fa fa-bolt"></i> Score</th>';
						echo '<th width="40%"><i class="fas fa-shield-alt"></i> Alianzas</th>';
						echo '<th width="30%"><i class="fas fa-users"></i> Miembros</th>';
					echo '</tr>';
					echo '<tr>';
						echo '<td>'.number_format($displayData['gscore']).'</td>';
						echo '<td>';
						if(!in_array("",$guildAlli)){
							if(is_array($guildAlli)) {
								foreach($guildAlli as $Alliance) {
									echo guildProfile($Alliance).', ';
								}
							}
						}else echo '-'; 
						echo '</td>';
						echo '<td style="color:red;font-weight:600;">'.number_format($displayData['gmembers']).''; if(number_format($displayData['gmembers'])==1){echo ' Miembro';}else{echo ' Miembros';} echo'</td>';
					echo '</tr>';
				echo '</tbody>';
			echo '</table>';
		echo '</div>';		
		echo '<br>';

		echo '<div class="table-responsive">';
			echo '<table class="table text-center table-bordered">';
				echo '<thead class="thead-dark">';
					  echo '<tr>';
						echo '<th scope="col" colspan="6"><i class="fas fa-user-shield"></i> '.lang('profiles_txt_6',true).'</th>';
					  echo '</tr>';
				echo '</thead>';
				echo '<tbody>';
					echo '<tr>';
						echo '<td style="padding:0;"><div class="container"><div class="row">';
						if(is_array($guildMembers)) {
							foreach($guildMembers as $memberName) {
								if(substr(strrchr($memberName, "-"), 1) == 128){
									$G_Status = '<font style="font-weight: 700;font-size: 13px;font-family: Roboto, sans-serif;color: #0071e6;">(Guild Master)</font>';
								}else if(substr(strrchr($memberName, "-"), 1) == 64){
									$G_Status = '<font style="font-weight: 700;font-size: 13px;font-family: Roboto, sans-serif;color: green;">(Assistant Master)</font>';
								}else if(substr(strrchr($memberName, "-"), 1) == 32){
									$G_Status = '<font style="font-weight: 700;font-size: 13px;font-family: Roboto, sans-serif;color: red;">(Battle Master)</font>';
								}else if(substr(strrchr($memberName, "-"), 1) == 0){
									$G_Status = '';
								}
								echo '<div class="col-md-3 col-6" style="padding:10px;border:1px solid #dee2e6;text-align:left;"><img src="'.getCountryFlag($charactersCountry[strtok($memberName, '-')]).'" height="15"/> '.playerProfile(strtok($memberName, '-')).' '.$G_Status.'</div>';
							}
						}
						echo '</div></div></td>';
					echo '</tr>';
				echo '</tbody>';
			echo '</table>';
		echo '</div>';

		} catch(Exception $e) {
			message('error', $e->getMessage());
		}
	} else {
		message('error', lang('error_25',true));
	}
} else {
	message('error', lang('error_47',true));
}