<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

echo '<div class="page-title"><span>'.lang('profiles_txt_2',true).'</span></div>';

loadModuleConfigs('profiles');
if(mconfig('active')) {
	if(check_value($_GET['req'])) {
		try {
			$weProfiles = new weProfiles();
			$szItems	= new Items();
			$weProfiles->setType("player");
			$weProfiles->setRequest($_GET['req']);
			$cData = $weProfiles->data();

			$Guild_Data = LoadCacheData('rankings_guilds.cache');

			if($cData[2] == 0 || $cData[2] == 1 || $cData[2] == 2 || $cData[2] == 3 || $cData[2] == 7){
				$ColorBorder = '#2f7dcc';
				$BackColor		=	'rgba(47, 125, 204, 0.1)';
			}
			else if($cData[2] == 16 || $cData[2] == 17 || $cData[2] == 18 || $cData[2] == 19 || $cData[2] == 23){
				$ColorBorder = '#cc2f2f';	
				$BackColor		=	'rgba(204, 47, 47, 0.1)';
			}
			else if($cData[2] == 32 || $cData[2] == 33 || $cData[2] == 34 || $cData[2] == 35 || $cData[2] == 39){
				$ColorBorder = '#33cc2f';	
				$BackColor		=	'rgba(51, 204, 47, 0.1)';
			}
			else if($cData[2] == 48 || $cData[2] == 49 || $cData[2] == 50 || $cData[2] == 54){
				$ColorBorder = '#712fcc';
				$BackColor		=	'rgba(113, 47, 204, 0.1)';
			}
			else if($cData[2] == 64 || $cData[2] == 65 || $cData[2] == 66 || $cData[2] == 67){
				$ColorBorder = '#cc9e2f';	
				$BackColor		=	'rgba(204, 158, 47, 0.1)';
			}
			else if($cData[2] == 80 || $cData[2] == 81 || $cData[2] == 82 || $cData[2] == 83 || $cData[2] == 87){
				$ColorBorder = '#bf2fcc';	
				$BackColor		=	'rgba(191, 47, 204, 0.1)';
			}
			else if($cData[2] == 96 || $cData[2] == 97 || $cData[2] == 98 || $cData[2] == 99 || $cData[2] == 102){
				$ColorBorder = '#cc542f';	
				$BackColor		=	'rgba(204, 84, 47, 0.1)';
			}

			if($custom['character_class'][$cData[2]]['base_stats']['cmd'] > 0) {
				$ColSpan = 5;
				$Width = 20;
			}else {
				$ColSpan = 4;
				$Width = 25;
			}

			$characterIMG = getPlayerClassAvatar($cData[2], false);
			
			$charactersCountry = loadCache('character_country.cache');
			if(!is_array($charactersCountry)) $showPlayerCountry = false;

		echo '<div class="table-responsive">';
			echo '<table class="table text-center table-bordered">';
				echo '<thead class="thead-dark">';
					  echo '<tr>';
						echo '<th scope="col" colspan="6"><i class="fas fa-user"></i> '.lang('profiles_txt_2',true).'</th>';
					  echo '</tr>';
				echo '</thead>';
				echo '<tbody>';
					echo '<tr>';
						echo '<th rowspan="4" style="background-image: url('.$characterIMG.');background-size:cover;height:200px;width:200px;border:4px solid '.$ColorBorder.';"></th>';
						echo '<th colspan="2"><i class="fas fa-user-tag"></i> Nombre</th>';
						echo '<th colspan="2"><i class="fas fa-user-ninja"></i> Raza</th>';
					echo '</tr>';
					echo '<tr>';
						echo '<td colspan="2"><img src="'.getCountryFlag($charactersCountry[$cData[1]]).'" height="15"/> '.$cData[1].'</td>';
						echo '<td colspan="2" style="color:'.$ColorBorder.';font-weight:600;font-family: \'Dosis\', sans-serif;font-size: 18px !important;">'.$custom['character_class'][$cData[2]][0].'</td>';
					echo '</tr>';
					echo '<tr>';
						echo '<th><i class="fas fa-angle-up"></i> Nivel</th>';
						echo '<th><i class="fas fa-angle-double-up"></i> Master LVL</th>';
						echo '<th><i class="fas fa-redo-alt"></i> Resets</th>';
						echo '<th><i class="fas fa-recycle"></i> Grand Resets</th>';
					echo '</tr>';
					echo '<tr>';
						echo '<td>'.number_format($cData[3]).'</td>';
						echo '<td style="color:red;font-weight:600;">'.number_format($cData[14]).'</td>';
						echo '<td style="color:green;font-weight:600;">'.number_format($cData[4],0,",",".").'</td>';
						echo '<td>'.number_format($cData[11],0,",",".").'</td>';
					echo '</tr>';
				echo '</tbody>';
			echo '</table>';
		echo '</div>';		

		echo '<br>';

		
if(mconfig('stats')){
	echo '<div class="table-responsive">';
		echo '<table class="table text-center table-bordered">';
			echo '<thead class="thead-dark">';
		  		echo '<tr>';
					echo '<th scope="col" colspan="'.$ColSpan.'"><i class="fas fa-chart-bar"></i> Stats</th>';
		  		echo '</tr>';
			echo '</thead>';
			echo '<tbody>';
				echo '<tr>';
					echo '<th><i class="fas fa-fist-raised"></i> '.lang('profiles_txt_10',true).'</th>';
					echo '<th><i class="fab fa-gg"></i> '.lang('profiles_txt_11',true).'</th>';
					echo '<th><i class="fas fa-heartbeat"></i> '.lang('profiles_txt_12',true).'</th>';
					echo '<th><i class="fas fa-hat-wizard"></i> '.lang('profiles_txt_13',true).'</th>';
					if($custom['character_class'][$cData[2]]['base_stats']['cmd'] > 0) {
						echo '<th><i class="fab fa-phoenix-framework"></i> '.lang('profiles_txt_14',true).'</th>';
					}
				echo '</tr>';
		  		echo '<tr>';
		  			echo '<td style="width:'.$Width.'%;">';
		  				echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
  							echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($cData[5]/650).'%; min-width:40%;" aria-valuenow="'.number_format($cData[5]/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($cData[5],0,",",".").'</div>';
						echo '</div>';
					echo '</td>';
					echo '<td style="width:'.$Width.'%;">';
		  				echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
  							echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($cData[6]/650).'%; min-width:40%;" aria-valuenow="'.number_format($cData[6]/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($cData[6],0,",",".").'</div>';
						echo '</div>';
					echo '</td>';
					echo '<td style="width:'.$Width.'%;">';
						echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
							echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($cData[7]/650).'%; min-width:40%;max-width:100%" aria-valuenow="'.number_format($cData[7]/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($cData[7],0,",",".").'</div>';
				 	 	echo '</div>';
			  		echo '</td>';
					echo '<td style="width:'.$Width.'%;">';
						echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
							echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($cData[8]/650).'%; min-width:40%;max-width:100%" aria-valuenow="'.number_format($cData[8]/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($cData[8],0,",",".").'</div>';
				 	 	echo '</div>';
			  		echo '</td>';
					if($custom['character_class'][$cData[2]]['base_stats']['cmd'] > 0) {
					echo '<td style="width:'.$Width.'%;">';
					  echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
						  echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($cData[9]/650).'%; min-width:40%;max-width:100%" aria-valuenow="'.number_format($cData[9]/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($cData[9],0,",",".").'</div>';
						echo '</div>';
					echo '</td>';
					}
					echo '</tr>';
			echo '</tbody>';
		echo '</table>';
	echo '</div>';

	echo '<br>';
}
if(mconfig('online')){
	echo '<div class="table-responsive">';
			echo '<table class="table text-center table-bordered">';
				echo '<thead class="thead-dark">';
					  echo '<tr>';
						echo '<th scope="col" colspan="6"><i class="fas fa-info-circle"></i> Mas Info </th>';
					  echo '</tr>';
				echo '</thead>';
				echo '<tbody>';
					echo '<tr>';
						echo '<th colspan="4"><i class="fas fa-shield-alt"></i> '.lang('profiles_txt_16',true).'</th>';
					echo '</tr>';
					echo '<tr>';
					if(check_value($cData[12])) {
						echo '<td colspan="4" style="color:green;font-weight:600;font-family: \'Dosis\', sans-serif;"><i class="fas fa-check"></i> '.guildProfile($cData[12]).'</td>';
					}else{
						echo '<td colspan="4" style="color:red;font-weight:600;font-family: \'Dosis\', sans-serif;"><i class="fas fa-times"></i> Sin Guild</td>';
					}
					echo '</tr>';
					echo '<tr>';
						echo '<th><i class="fas fa-coins"></i> Zen</th>';
						echo '<th><i class="fas fa-map-marker-alt"></i> Mapa</th>';
						echo '<th><i class="fas fa-skull-crossbones"></i> Kills</th>';
						if($cData[13]) {
							echo '<th><i class="fas fa-toggle-on"></i> '.lang('profiles_txt_17',true).'</th>';
						}else{
							echo '<th><i class="fas fa-toggle-off"></i> '.lang('profiles_txt_17',true).'</th>';
						}
					echo '</tr>';
					echo '<tr>';
						echo '<td style="color:green;font-weight:600;font-size: 18px !important;">'.number_format($cData[15],0,",",".").'</td>';
						echo '<td>'.returnMapName($cData[16]).' <b>('.$cData[17].' - '.$cData[18].')</b></td>';
						echo '<td style="color:red;font-weight:600;font-family: \'Dosis\', sans-serif;font-size: 18px !important;">'.number_format($cData[10]).'</td>';
						if($cData[13]) {
							echo '<td style="background:green;font-family: \'Dosis\', sans-serif;font-size: 20px !important;color:#f1f1f1;">'.lang('profiles_txt_18',true).'</td>';
						} else {
							echo '<td style="background:red;font-family: \'Dosis\', sans-serif;font-size: 20px !important;color:#f1f1f1;">'.lang('profiles_txt_19',true).'</td>';
						}
					echo '</tr>';
				echo '</tbody>';
			echo '</table>';
		echo '</div>';		
}
if(mconfig('inventario')){
		$inventory = $szItems->GetCharInventoryResponsive($cData[1]);

		echo '<div class="table-responsive">';
			echo '<table class="table text-center table-bordered">';
				echo '<thead style="background-color:'.$ColorBorder.';color:#f1f1f1;border: 2px solid '.$ColorBorder.';">';
					  echo '<tr>';
						echo '<th scope="col" colspan="6" style="border-bottom: 1px solid '.$ColorBorder.';"><i class="fas fa-gavel"></i> Inventario </th>';
					  echo '</tr>';
				echo '</thead>';
				echo '<tbody>';
					echo '<tr>';
						echo '<th colspan="4" style="color:'.$ColorBorder.';border-left: 1px solid '.$ColorBorder.';border-right: 1px solid '.$ColorBorder.';"><i class="fas fa-users"></i> Inventario de '.$cData[1].'</th>';
					echo '</tr>';					
					echo '<tr>';
						echo '<td style="border-bottom: 1px solid; border-color:'.$ColorBorder.';background-color:'.$BackColor.'">' . $inventory . '</td>';
					echo '</tr>';
				echo '</tbody>';
			echo '</table>';
		echo '</div>';		
}
		} catch(Exception $e) {
			message('error', $e->getMessage());
		}
	} else {
		message('error', lang('error_25',true));
	}
} else {
	message('error', lang('error_47',true));
}