<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
 
$this->dB = Connection::Database('MuOnline');

try {
	echo '<h3 class="nk-decorated-h-2"><div class="page-title">Top Blood Castle</div></h3>';
	
	$Rankings = new Rankings();
    
	$ranking_data = LoadCacheData('rankings_chaoscastle.cache');
	
	if(!is_array($ranking_data)) throw new Exception(lang('error_58',true));
	
	$showPlayerCountry = mconfig('show_country_flags') ? true : false;

	$charactersCountry = loadCache('character_country.cache');
	if(!is_array($charactersCountry)) $showPlayerCountry = false;
	
	if(mconfig('show_online_status')) $onlineCharacters = loadCache('online_characters.cache');
	if(!is_array($onlineCharacters)) $onlineCharacters = array();

	$Rankings->rankingsMenu();


	echo '<table class="table dataTableChar dataTable no-footer general-rank text-center mt-2" style="white-space: nowrap;" id="RankingGeneral" role="grid">';
	echo '<thead class="bg-primary text-white">';
	echo '<tr role="row">';
	if(mconfig('rankings_show_place_number')) {
		echo '<th style="font-weight:bold;"><i class="fas fa-list-ol"></i></th>';
	}
	echo '<td style="font-weight:bold;" class="text-start"><i class="far fa-user"></i> '.lang('rankings_txt_10').'</td>';
	echo '		<th><center><i class="fas fa-star"></i> Score</center></th>';
	echo '		<th class="text-start"><i class="fas fa-shield-alt"></i> Guild</th>';
	if($showPlayerCountry) echo '<td style="font-weight:bold;"><i class="fa fa-globe"></i></td>';
			echo '</tr>
			</thead>';
	$i = 0;
	echo '<tbody>';
	foreach($ranking_data as $rdata) {
		$G_Score = $rdata[5];
	    
		$onlineStatus = mconfig('show_online_status') ? in_array($rdata[0], $onlineCharacters) ? 'aifos-char-online' : 'aifos-char-offline' : '';
		$characterIMG = getPlayerClassAvatar($rdata[3], true, true, 'rankings-class-image rounded-circle '.$onlineStatus.'');
		
		if($i>=1) {
			echo '<tr data-class-id='.$rdata[3].'>';
		
			echo '<td class="rankings-table-place"><i class="fas fa-medal"></i> '.$i.'</td>';
			

			echo '<td class="text-start">'.$characterIMG.' '.playerProfile($rdata[0]).'</td>';
			echo '<td style="font-weight: 300;text-align: center;color:green;">'.number_format($rdata[1],0,'','.').'</td>';
			if($rdata[4] != null){
				echo '<td style="padding-top: unset;padding-bottom: unset;" class="text-center"><table style="margin-left:-4px;">
									<tbody><tr style="background: unset !important;"><td align="left" style="border:0;">
										'.returnGuildLogo($rdata[6], 30).'
									</td>
									<td style="border:0;">
										<div style="margin-left:3px;font-size:13px;font-family: Roboto, sans-serif;">'.$rdata[4].'
										<div style="font-size:8.5px;margin-top:-0;">
											Score '.$G_Score.'
										</div>
										</div>
									</td>
								</tr></tbody></table></td>';
			}else{
			echo '<td style="padding-top: unset;padding-bottom: unset;" class="text-center"><table style="margin-left:-4px;">
									<tbody><tr style="background: unset !important;">
									<td style="border:0;">
										<div style="font-weight:700;font-size:13px;font-family: Roboto, sans-serif;color:red;"><i class="fas fa-times-circle"></i> Sin Guild
										<div style="font-size:8.5px;margin-top:-0;">
											
										</div>
										</div>
									</td>
								</tr></tbody></table></td>';
			}
            if($showPlayerCountry) echo '<td><center><img src="'.getCountryFlag($charactersCountry[$rdata[0]]).'" height="15"/></center></td>';
			echo '</tr>';
		}
		$i++;
	}
	echo '</tbody>';
	echo '</table>';

		echo '<br><div class="alert alert-info m-t-10">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';

	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}