<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
 
$this->dB = Connection::Database('MuOnline');

try {
	echo '<h3 class="nk-decorated-h-2"><div class="page-title">Top General</div></h3>';
	
	$Rankings = new Rankings();
    
	$ranking_data = LoadCacheData('rankings_general.cache');
	
	if(!is_array($ranking_data)) throw new Exception(lang('error_58',true));
	
	$showPlayerCountry = mconfig('show_country_flags') ? true : false;
	$showGens = mconfig('show_general_gens') ? true : false;
	$showResets = mconfig('show_general_resets') ? true : false;
	$showMResets = mconfig('show_general_mresets') ? true : false;
	$showLevel = mconfig('show_general_level') ? true : false;
	$showMasterLevel = mconfig('show_general_masterlevel') ? true : false;
	$showGuild = mconfig('show_general_guild') ? true : false;
	$ShowMapa = mconfig('show_location') ? true : false;

	$charactersCountry = loadCache('character_country.cache');
	if(!is_array($charactersCountry)) $showPlayerCountry = false;
	
	if(mconfig('show_online_status')) $onlineCharacters = loadCache('online_characters.cache');
	if(!is_array($onlineCharacters)) $onlineCharacters = array();

	$Rankings->rankingsMenu();


	echo '<table class="table dataTableChar dataTable no-footer general-rank text-center mt-2" style="white-space: nowrap;" id="RankingGeneral" role="grid">';
	echo '<thead class="bg-primary text-white">';
	echo '		<tr role="row">';
	echo '		<th class="text-start"><i class="fas fa-list-ol"></i></th>';
	echo '		<th class="text-start"><i class="far fa-user"></i> Personaje</th>';
	if($showMResets) echo '		<th><center><i class="fas fa-redo-alt"></i> GResets</center></th>';
	if($showResets) echo '		<th><center><i class="fas fa-redo-alt"></i> Resets</center></th>';
	if($showLevel) echo '		<th><center><i class="fas fa-angle-up"></i> Level</center></th>';
	if($showMasterLevel) echo '		<th><center><i class="fas fa-angle-double-up"></i> MLevel</center></th>';
	if($showGuild) echo '		<th class="text-center"><i class="fas fa-shield-alt"></i> Guild</th>';
	if($ShowMapa) echo '<th><center><i class="fas fa-map-marker-alt"></i> Mapa</center></th>';
	if($showPlayerCountry) echo '<th class="sorting_disabled" rowspan="1" colspan="1" aria-label=""><center><i class="fa fa-globe"></i></center></th>';
			echo '</tr>
			</thead>';
	$i = 0;
	echo '<tbody>';
	foreach($ranking_data as $rdata) {
		$GuildMember = $rdata[6];
 
	    if($GuildMember == 128){
	        $G_Status = '<font color=blue>Guild Master</font>';
	    }else if($GuildMember == 64){
	        $G_Status = '<font color=green>Assistant Master</font>';
	    }else if($GuildMember == 32){
	        $G_Status = '<font color=red>Battle Master</font>';
	    }else if($GuildMember == 0){
	        $G_Status = 'Miembro';
	    }
	    
		$onlineStatus = mconfig('show_online_status') ? in_array($rdata[0], $onlineCharacters) ? 'aifos-char-online' : 'aifos-char-offline' : '';
		$characterIMG = getPlayerClassAvatar($rdata[3], true, true, 'rankings-class-image rounded-circle '.$onlineStatus.'');
		
		$gensType = $rdata[8] == 1 ? '<img class="rankings-gens-img" src="'.__PATH_TEMPLATE_IMG__.'gens_1.png" title="'.lang('rankings_txt_26',true).'" height="20" alt="'.lang('rankings_txt_26',true).'"/>' : '<img class="rankings-gens-img" src="'.__PATH_TEMPLATE_IMG__.'gens_2.png" title="'.lang('rankings_txt_27',true).'" height="20" alt="'.lang('rankings_txt_27',true).'"/>';
		
		if($i>=1) {
			echo '<tr data-class-id='.$rdata[3].'>';
		
			echo '<td scope="row"><center><i class="fas fa-medal"></i> '.$i.'</center></td>';
			
			if($showGens && $rdata[8] != null){
				echo '<td class="text-start">'.$characterIMG.' '.playerProfile($rdata[0]).' '.$gensType.'</td>';
			}else{
				echo '<td class="text-start">'.$characterIMG.' '.playerProfile($rdata[0]).'</td>';
			}
			if($showMResets) echo '<td style="font-weight: 300;text-align: center;color:#008aca;">'.number_format($rdata[9]).'</td>';
			if($showResets) echo '<td style="font-weight: 300;text-align: center;color:green;">'.number_format($rdata[1]).'</td>';
			if($showLevel) echo '<td class="ranking_new" style="text-align: center;">'.number_format($rdata[2]).'</td>';
			if($showMasterLevel) echo '<td class="ranking_new" style="font-weight: 300;text-align: center;color:red;">'.number_format($rdata[7]).'</td>';
			if($showGuild){ 
				if($rdata[4] != null){
					echo '<td style="padding-top: unset;padding-bottom: unset;" class="text-center"><table style="margin-left:-4px;">
										<tbody><tr style="background: unset !important;"><td align="left" style="border:0;">
											'.returnGuildLogo($rdata[5], 30).'
										</td>
										<td style="border:0;">
											<div style="margin-left:3px;font-size:13px;font-family: Roboto, sans-serif;">'.$rdata[4].'
											<div style="font-size:8.5px;margin-top:-0;">
												'.$G_Status.'
											</div>
											</div>
										</td>
									</tr></tbody></table></td>';
				}else{
				echo '<td style="padding-top: unset;padding-bottom: unset;" class="text-center"><table style="margin-left:-4px;">
										<tbody><tr style="background: unset !important;">
										<td style="border:0;">
											<div style="font-weight:700;font-size:13px;font-family: Roboto, sans-serif;color:red;"><i class="fas fa-times-circle"></i> Sin Guild
											<div style="font-size:8.5px;margin-top:-0;">
												
											</div>
											</div>
										</td>
									</tr></tbody></table></td>';
				}
			}
			if($ShowMapa) echo '<td style="font-weight:700;font-size:13px;font-family: Roboto, sans-serif;color:green;"><center>'.returnMapName($rdata[10]).'</center></td>';
            if($showPlayerCountry) echo '<td><center><img src="'.getCountryFlag($charactersCountry[$rdata[0]]).'" height="15"/></center></td>';
			echo '</tr>';
		}
		$i++;
	}
	echo '</tbody>';
	echo '</table>';

		echo '<br><div class="alert alert-info m-t-10">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';

	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}