<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

try {
    
    echo '<div class="page-title"><span>Top King Guild</span></div>';
	
	$Rankings = new Rankings();
	$Rankings->rankingsMenu();
	loadModuleConfigs('rankings');
	
	if(!mconfig('rankings_enable_kg')) throw new Exception(lang('error_44',true));
	if(!mconfig('active')) throw new Exception(lang('error_44',true));
	
	$ranking_data = LoadCacheData('rankings_kingguild.cache');
	if(!is_array($ranking_data)) throw new Exception(lang('error_58',true));
		
	
	echo '<table class="table dataTableChar dataTable no-footer general-rank text-center mt-2" style="white-space: nowrap;" id="RankingGeneral" role="grid">';
	echo '<thead class="bg-primary text-white">';
	echo '<tr role="row">';
	if(mconfig('rankings_show_place_number')) {
		echo '<td style="font-weight:bold;"><i class="fas fa-list-ol"></i></td>';
	}
	echo '<td style="font-weight:bold;"><i class="fa-solid fa-shield-halved"></i> Clan</td>';
	echo '<td style="font-weight:bold;"><i class="fa-solid fa-star"></i> Puntaje</td>';
	echo '<td style="font-weight:bold;"><i class="fa-solid fa-star-half-stroke"></i> Puntaje Semanal</td>';
	echo '</tr>';
	echo '</thead>';
	$i = 0;
	echo '<tbody>';
	foreach($ranking_data as $rdata) {
		if($i>=1) {
			echo '<tr data-class-id='.$rdata[1].'>';
			if(mconfig('rankings_show_place_number')) {
				echo '<td class="rankings-table-place"><i class="fas fa-medal"></i> '.$i.'</td>';
			}
			echo '<td style="padding-left: 20px !important;">'.guildProfile($rdata[1]).'</td>';
			echo '<td class="ranking_new" style="text-align: center;">'.number_format($rdata[2],0,'','.').'</td>';
			echo '<td class="ranking_new" style="text-align: center;">'.number_format($rdata[3],0,'','.').'</td>';
			echo '</tr>';
		}
		$i++;
	}
	echo '</table>';
	if(mconfig('rankings_show_date')) {
		echo '<div class="rankings-update-time">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';
	}
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}