<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
 
$this->dB = Connection::Database('MuOnline');

try {
	echo '<h3 class="nk-decorated-h-2"><div class="page-title">Ranking de Ligas</div></h3>';
	
	$Rankings = new Rankings();
    
	$ranking_data = LoadCacheData('rankings_liga.cache');
	
	if(!is_array($ranking_data)) throw new Exception(lang('error_58',true));
	
	$showPlayerCountry = mconfig('show_country_flags') ? true : false;

	$showDuelosJugados	=	mconfig('rankings_liga_show_jugadas') ? true : false;
	$showDuelosGanados	=	mconfig('rankings_liga_show_ganadas') ? true : false;
	$showDuelosPerdidos	=	mconfig('rankings_liga_show_perdidas') ? true : false;
	$showWinRate		=	mconfig('rankings_liga_show_winrate') ? true : false;
	$showLiga			=	mconfig('rankings_liga_show_liga') ? true : false;

	$charactersCountry = loadCache('character_country.cache');
	if(!is_array($charactersCountry)) $showPlayerCountry = false;
	
	if(mconfig('show_online_status')) $onlineCharacters = loadCache('online_characters.cache');
	if(!is_array($onlineCharacters)) $onlineCharacters = array();

	$Rankings->rankingsMenu();

	echo '<div class="alert alert-dark">';
	echo '	<center><h1 style="font-family: \'Dosis\', sans-serif;"><i class="fas fa-award" style="font-size: 35px;"></i> RANGOS</h1><center><br>';
		echo '<div class="row">';
		echo '	<div class="col">';
		echo '  		<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_hierro3').'" title="Hierro" height="40"/><br>';
		echo '  		<p>Hierro</p>';
		echo '	</div>';
		echo '	<div class="col">';
		echo '  		<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_bronce3').'" title="Bronce" height="40"/><br>';
		echo '  		<p>Bronce</p>';
		echo '	</div>';
		echo '	<div class="col">';
		echo '  		<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_plata3').'" title="Plata" height="40"/><br>';
		echo '  		<p>Plata</p>';
		echo '	</div>';
		echo '	<div class="col">';
		echo '  		<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_oro3').'" title="Oro" height="40"/><br>';
		echo '  		<p>Oro</p>';
		echo '	</div>';
		echo '	<div class="col">';
		echo '  		<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_platino3').'" title="Platino" height="40"/><br>';
		echo '  		<p>Platino</p>';
		echo '	</div>';
		echo '	<div class="col">';
		echo '  		<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_diamante3').'" title="Diamante" height="40"/><br>';
		echo '  		<p>Diamante</p>';
		echo '	</div>';
		echo '	<div class="col">';
		echo '  		<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_leyenda3').'" title="Leyenda" height="40"/><br>';
		echo '  		<p>Leyenda</p>';
		echo '	</div>';
		echo '	<div class="col">';
		echo '  		<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_challenger').'" title="Challenger" height="40"/><br>';
		echo '  		<p>Challenger</p>';
		echo '	</div>';
		echo '</div>';


	echo '<br>';

	echo '	<center><h3 style="font-family: \'Dosis\', sans-serif;"><i class="fas fa-exclamation-circle" style="font-size: 25px;"></i> Informacion</h3><center>';

	echo '<p>Cada Rango tiene 3 divisiones <b>(1, 2 ,3, siendo la 3 la mayor)</b>, a excepcion de <b>Challenger</b>.<br>
		 Por ejemplo: Vas a escalar de la siguiente manera:<br>
		 <b>Hierro 1</b> -> <b>Hierro 2</b> -> <b>Hierro 3</b> -> <b>Bronce 1</b> -> Etc...
	</p>';

	echo '<p>Para subir de liga tenes que jugar <b>Duelos</b>, con estos si ganas ganaras <b>'.mconfig('rankings_liga_ganadas').' puntos</b>, si pierdes, son <b>'.mconfig('rankings_liga_perdidas').' puntos</b> menos.<br>
		 En otras palabras, si pierden, <b>pierden mas puntos de los que ganan</b>, asi que siempre tienen que tener un <b>winrate positivo</b> para poder escalar.
	</p>';

	echo '</div>';

	echo '<div class="alert alert-danger">';
	echo '	<h1>Reglas</h1>';
	echo '	<p><b>-</b> Esta totalmente prohibido falsear score.<b> (Castigo: Ban Permanente de Cuenta.)</b><br>';
	echo '	<b>-</b> Si no juegas duelo en <b>4 dias</b>, sumaras <b>4 Derrotas</b>.</p>';
	echo '</div>';

	echo '<table class="table dataTableChar dataTable no-footer general-rank text-center mt-2" style="white-space: nowrap;" id="RankingGeneral" role="grid">';
	echo '<thead class="bg-primary text-white">';
	echo '<tr role="row">';
	if(mconfig('rankings_show_place_number')) {
		echo '<td style="font-weight:bold;"><i class="fas fa-list-ol"></i></td>';
	}
	echo '<td style="font-weight:bold;" class="text-start"><i class="far fa-user"></i> '.lang('rankings_txt_10').'</td>';
 	if($showDuelosJugados) 			echo '		<th><center><i class="fas fa-play-circle"></i> Jugadas</center></th>';
 	if($showDuelosGanados) 			echo '		<th><center><i class="fas fa-user-check"></i> Ganadas</center></th>';
	if($showDuelosPerdidos)			echo '		<th><center><i class="fas fa-user-times"></i> Perdidas</center></th>';
	if($showWinRate) 				echo '		<th><center><i class="fas fa-divide"></i> Win Rate</center></th>';
	if($showLiga) 					echo '		<th><center><i class="fas fa-award"></i> Liga</center></th>';
	if($showPlayerCountry) echo '<td style="font-weight:bold;"><i class="fa fa-globe"></i></td>';
			echo '</tr>
			</thead>';
	$i = 0;
	echo '<tbody>';
	foreach($ranking_data as $rdata) {

		$Ganadas 		= 		$rdata[2];
		$Perdidas 		= 		$rdata[3];
		$Jugadas        =       $rdata[3] + $rdata[2];
		$TotalPartidas	=		number_format((float)$Ganadas) + number_format((float)$Perdidas);
		if($Jugadas > 0) 		$WR1 = number_format((float)$Ganadas) / number_format((float)$TotalPartidas) * 100.0;
		if($WR1 != null){
    		$WR = number_format((float)$WR1, 2, '.', '');
		}else{
			$WR = "0.00";
		}

		if($WR < 50){
			$WinRate = "<span style='color:#dc3545;font-weight: 600;'>".$WR."%</span>";
		}
		elseif($WR >= 50){
			$WinRate = "<span style='color:#28a745;font-weight: 600;'>".$WR."%</span>";
		}
		
		// Puntaje
		$EloPorGanar	=	mconfig('rankings_liga_ganadas');
		$EloPorPerder	=	mconfig('rankings_liga_perdidas');

		$EloWin			=	$EloPorGanar 	* 	$Ganadas;
		$EloLoss		=	$EloPorPerder	*	$Perdidas;
	
		$TotalElo		=	$EloWin			-	$EloLoss;
		if($TotalElo<0) $TotalElo = 0;

		if($TotalElo >= mconfig('rankings_liga_elo_challenger')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/Challenger.png" title="Challenger" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_leyenda3')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_leyenda3').'" title="Leyenda 3" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_leyenda2')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_leyenda2').'" title="Leyenda 2" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_leyenda1')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_leyenda1').'" title="Leyenda 1" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_diamante3')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_diamante3').'" title="Diamante 3" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_diamante2')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_diamante2').'" title="Diamante 2" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_diamante1')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_diamante1').'" title="Diamante 1" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_platino3')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_platino3').'" title="Platino 3" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_platino2')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_platino2').'" title="Platino 2" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_platino1')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_platino1').'" title="Platino 1" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_oro3')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_oro3').'" title="Oro 3" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_oro2')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_oro2').'" title="Oro 2" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_oro1')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_oro1').'" title="Oro 1" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_plata3')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_plata3').'" title="Plata 3" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_plata2')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_plata2').'" title="Plata 2" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_plata1')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_plata1').'" title="Plata 1" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_bronce3')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_bronce3').'" title="Bronce 3" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_bronce2')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_bronce2').'" title="Bronce 2" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_bronce1')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_bronce1').'" title="Bronce 1" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_hierro3')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_hierro3').'" title="Hierro 3" height="40"/>';
		}elseif($TotalElo >= mconfig('rankings_liga_elo_hierro2')){
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_hierro2').'" title="Hierro 2" height="40"/>';
		}else{
			$Liga	= '<img src="'.__PATH_TEMPLATE_IMG__.'ligas/'.mconfig('rankings_liga_img_hierro1').'" title="Hierro 1" height="40"/>';
		}
		
	    
		$onlineStatus = mconfig('show_online_status') ? in_array($rdata[1], $onlineCharacters) ? 'aifos-char-online' : 'aifos-char-offline' : '';
		$characterIMG = getPlayerClassAvatar($rdata[0], true, true, 'rankings-class-image rounded-circle '.$onlineStatus.'');
		
		if($i>=1) {
			echo '<tr data-class-id='.$rdata[0].'>';
		
			echo '<td class="rankings-table-place"><i class="fas fa-medal"></i> '.$i.'</td>';
			
			
			echo '<td class="text-start">'.$characterIMG.' '.playerProfile($rdata[1]).'</td>';
			if($showDuelosJugados) 	echo '<td style="font-weight: 300;text-align: center;color:#008aca;">'.$Jugadas.'</td>';
			if($showDuelosGanados) 	echo '<td style="font-weight: 300;text-align: center;color:green;">'.$rdata[2].'</td>';
			if($showDuelosPerdidos)	echo '<td class="ranking_new" style="text-align: center;color:red;">'.$rdata[3].'</td>';
			if($showWinRate) 		echo '<td class="ranking_new" style="text-align: center;">'.$WinRate.'</td>';
			//echo '<td class="ranking_new" style="text-align: center;color:red;">'.$TotalElo.'</td>';
			if($showLiga) 			echo '<td><center>'.$Liga.'</center></td>';

			if($showPlayerCountry) echo '<td><center><img src="'.getCountryFlag($charactersCountry[$rdata[1]]).'" height="15"/></center></td>';
			echo '</tr>';
		}
		$i++;
	}
	echo '</tbody>';
	echo '</table>';

		echo '<br><div class="alert alert-info m-t-10">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';

	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}