<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */
 
$this->dB = Connection::Database('MuOnline');

try {
	echo '<h3 class="nk-decorated-h-2"><div class="page-title">Top Monster Kill</div></h3>';
	
	$Rankings = new Rankings();
	loadModuleConfigs('rankings');

	if(!mconfig('rankings_enable_mk')) throw new Exception("El ranking de Monster Kill esta deshabilitado");
	if(!mconfig('active')) throw new Exception("El ranking esta deshabilitado");

	$ShowGreatDragon = mconfig('show_mk_greatdragon');
	$ShowGiantCrab = mconfig('show_mk_giantcrab');
	$ShowErohim = mconfig('show_mk_erohim');
	$ShowProtoDrakan = mconfig('show_mk_protodrakan');
	$ShowKundun = mconfig('show_mk_kundun');
	$ShowMedusa = mconfig('show_mk_medusa');
	$ShowAtikus = mconfig('show_mk_atikus');
	$ShowLordSilvester = mconfig('show_mk_lordsilvester');
	$ShowLordFerea = mconfig('show_mk_lordferea');


	switch($_REQUEST['request'])
	{
		case "greatdragon" :  $ranking_data = LoadCacheData('rankings_mk_greatdragon.cache'); $DefaultRanking = 0; $SetGreatDragon = 1; break;
		case "giantcrab" :  $ranking_data = LoadCacheData('rankings_mk_giantcrab.cache'); $DefaultRanking = 0; $SetGiantCrab = 1; break;
		case "erohim" :  $ranking_data = LoadCacheData('rankings_mk_erohim.cache'); $DefaultRanking = 0; $SetErohim = 1; break;
		case "protodrakan" :  $ranking_data = LoadCacheData('rankings_mk_protodrakan.cache'); $DefaultRanking = 0; $SetProtoDrakan = 1; break;
		case "kundun" :  $ranking_data = LoadCacheData('rankings_mk_kundun.cache'); $DefaultRanking = 0; $SetKundun = 1; break;
		case "medusa" :  $ranking_data = LoadCacheData('rankings_mk_medusa.cache'); $DefaultRanking = 0; $SetMedusa = 1; break;
		case "atikus" :  $ranking_data = LoadCacheData('rankings_mk_atikus.cache'); $DefaultRanking = 0; $SetAtikus = 1; break;
		case "lordsilvester" : $ranking_data = LoadCacheData('rankings_mk_lordsilvester.cache'); $DefaultRanking = 0; $SetLordSilvester = 1; break;
		case "lordferea" : $ranking_data = LoadCacheData('rankings_mk_lordferea.cache'); $DefaultRanking = 0; $SetLordFerea = 1; break;
		default : $ranking_data = LoadCacheData('rankings_mk_general.cache'); $DefaultRanking = 1; break;
	}
	
	if(!is_array($ranking_data)) throw new Exception(lang('error_58',true));

	$charactersCountry = loadCache('character_country.cache');
	if(!is_array($charactersCountry)) $showPlayerCountry = false;
	
	if(mconfig('show_online_status')) $onlineCharacters = loadCache('online_characters.cache');
	if(!is_array($onlineCharacters)) $onlineCharacters = array();

	$Rankings->rankingsMenu();

	$ActiveGen 	=	($DefaultRanking == 1) ? 'active' : '';
	$ActiveGD 	=	($SetGreatDragon == 1) ? 'active' : '';
	$ActiveGC 	=	($SetGiantCrab == 1) ? 'active' : '';
	$ActiveEro 	=	($SetErohim == 1) ? 'active' : '';
	$ActivePD 	=	($SetProtoDrakan == 1) ? 'active' : '';
	$ActiveKun 	=	($SetKundun == 1) ? 'active' : '';
	$ActiveMed 	=	($SetMedusa == 1) ? 'active' : '';
	$ActiveAti 	=	($SetAtikus == 1) ? 'active' : '';
	$ActiveLS 	=	($SetLordSilvester == 1) ? 'active' : '';
	$ActiveLF 	=	($SetLordFerea == 1) ? 'active' : '';

	echo '<hr>';
	echo '<center>';
		echo '<a href="'.__BASE_URL__.'rankings/monsterkill" class="btn btn-sm btn-outline-warning mr-2 mb-2 '.$ActiveGen.'"><i class="fas fa-list-ol"></i> General</a>';
		if($ShowGreatDragon == 1) echo '<a href="'.__BASE_URL__.'rankings/monsterkill/greatdragon" class="btn btn-sm btn-outline-primary mr-2 mb-2 '.$ActiveGD.'"><i class="fas fa-dragon"></i> Great Dragon</a>';
		if($ShowGiantCrab == 1) echo '<a href="'.__BASE_URL__.'rankings/monsterkill/giantcrab" class="btn btn-sm btn-outline-success mr-2 mb-2 '.$ActiveGC.'"><i class="fas fa-pastafarianism"></i> Gian Crab</a>';
		if($ShowErohim == 1) echo '<a href="'.__BASE_URL__.'rankings/monsterkill/erohim" class="btn btn-sm btn-outline-danger mr-2 mb-2 '.$ActiveEro.'"><i class="fas fa-skull-crossbones"></i> Erohim</a>';
		if($ShowProtoDrakan == 1) echo '<a href="'.__BASE_URL__.'rankings/monsterkill/protodrakan" class="btn btn-sm btn-outline-warning mr-2 mb-2 '.$ActivePD.'"><i class="fab fa-phoenix-framework"></i> Proto Drakan</a>';
		if($ShowKundun == 1) echo '<a href="'.__BASE_URL__.'rankings/monsterkill/kundun" class="btn btn-sm btn-outline-info mr-2 mb-2 '.$ActiveKun.'"><i class="fas fa-hat-wizard"></i> Kundun</a>';
		if($ShowMedusa == 1) echo '<a href="'.__BASE_URL__.'rankings/monsterkill/medusa" class="btn btn-sm btn-outline-dark mr-2 mb-2 '.$ActiveMed.'"><i class="fas fa-biohazard"></i> Medusa</a>';
		if($ShowAtikus == 1) echo '<a href="'.__BASE_URL__.'rankings/monsterkill/atikus" class="btn btn-sm btn-outline-primary mr-2 mb-2 '.$ActiveAti.'"><i class="fas fa-bolt"></i> Atikus</a>';
		if($ShowLordSilvester == 1) echo '<a href="'.__BASE_URL__.'rankings/monsterkill/lordsilvester" class="btn btn-sm btn-outline-success mr-2 mb-2 '.$ActiveLS.'"><i class="fas fa-horse-head"></i> Lord Silvester</a>';
		if($ShowLordFerea == 1) echo '<a href="'.__BASE_URL__.'rankings/monsterkill/lordferea" class="btn btn-sm btn-outline-danger mr-2 mb-2 '.$ActiveLF.'"><i class="fas fa-crown"></i> Lord Ferea</a>';
	echo '</center>';	
	echo '<hr>';

	echo '<div class="table-responsive">';
	echo '<table class="table dataTableChar dataTable no-footer general-rank text-center mt-2" style="white-space: nowrap;" id="RankingGeneral" role="grid">';
	echo '<thead class="bg-primary text-white">';
				echo '<tr role="row">';
					echo '<th style="text-align:center;"><i class="fas fa-list-ol"></i></th>';
					echo '<th class="text-start"><i class="far fa-user"></i> Personaje</th>';
					if($ShowGreatDragon == 1) { if($DefaultRanking == 1 || $SetGreatDragon == 1) echo '<th><i class="fas fa-dragon"></i> Great Dragon</th>'; }
					if($ShowGiantCrab == 1) { if($DefaultRanking == 1 || $SetGiantCrab == 1)  echo '<th><i class="fas fa-pastafarianism"></i> Gian Crab</th>'; }
					if($ShowErohim == 1) { if($DefaultRanking == 1 || $SetErohim == 1)  echo '<th><i class="fas fa-skull-crossbones"></i> Erohim</th>'; }
					if($ShowProtoDrakan == 1) { if($DefaultRanking == 1 || $SetProtoDrakan == 1)  echo '<th><i class="fab fa-phoenix-framework"></i> Proto Drakan</th>'; }
					if($ShowKundun == 1) { if($DefaultRanking == 1 || $SetKundun == 1)  echo '<th><i class="fas fa-hat-wizard"></i> Kundun</th>'; }
					if($ShowMedusa == 1) { if($DefaultRanking == 1 || $SetMedusa == 1)  echo '<th><i class="fas fa-biohazard"></i> Medusa</th>'; }
					if($ShowAtikus == 1) { if($DefaultRanking == 1 || $SetAtikus == 1)  echo '<th><i class="fas fa-bolt"></i> Atikus</th>'; }
					if($ShowLordSilvester == 1) { if($DefaultRanking == 1 || $SetLordSilvester == 1)  echo '<th><i class="fas fa-horse-head"></i> Lord Silvester</th>'; }
					if($ShowLordFerea == 1) { if($DefaultRanking == 1 || $SetLordFerea == 1)  echo '<th><i class="fas fa-crown"></i> Lord Ferea</th>'; }
					echo '<th class="text-start text-left"><i class="fas fa-shield-alt"></i> Clan</th>';
				echo '</tr>';
			echo '</thead>';
			$i = 0;
			echo '<tbody>';
			foreach($ranking_data as $rdata) {
				$GuildMember = $rdata[4];
				if($GuildMember == 128){
					$G_Status = '<font color=blue>Guild Master</font>';
				}else if($GuildMember == 64){
					$G_Status = '<font color=green>Assistant Master</font>';
				}else if($GuildMember == 32){
					$G_Status = '<font color=red>Battle Master</font>';
				}else if($GuildMember == 0){
					$G_Status = 'Miembro';
				}

				$onlineStatus = mconfig('show_online_status') ? in_array($rdata[0], $onlineCharacters) ? 'aifos-char-online' : 'aifos-char-offline' : '';
				$characterIMG = getPlayerClassAvatar($rdata[1], true, true, 'rankings-class-image rounded-circle '.$onlineStatus.'');
				if($i>=1) {
					echo '<tr>';
						echo '<td scope="row"><center><i class="fas fa-medal"></i> '.$i.'</center></td>';
						echo '<td class="text-start"><img src="'.getCountryFlag($charactersCountry[$rdata[0]]).'" height="15"/> '.$characterIMG.' '.playerProfile($rdata[0]).'</td>';
						if($ShowGreatDragon == 1) { if($DefaultRanking == 1) { echo '<td>'.number_format($rdata[5],0,",",".").'</td>'; } else if($SetGreatDragon == 1){ echo '<td>'.number_format($rdata[5],0,",",".").'</td>'; } }
						if($ShowGiantCrab == 1) { if($DefaultRanking == 1) { echo '<td>'.number_format($rdata[6],0,",",".").'</td>'; } else if($SetGiantCrab == 1){ echo '<td>'.number_format($rdata[5],0,",",".").'</td>';  } }
						if($ShowErohim == 1) { if($DefaultRanking == 1) { echo '<td>'.number_format($rdata[7],0,",",".").'</td>'; } else if($SetErohim == 1){ echo '<td>'.number_format($rdata[5],0,",",".").'</td>';  } }
						if($ShowProtoDrakan == 1) { if($DefaultRanking == 1) { echo '<td>'.number_format($rdata[8],0,",",".").'</td>'; } else if($SetProtoDrakan == 1){ echo '<td>'.number_format($rdata[5],0,",",".").'</td>';  } }
						if($ShowKundun == 1) { if($DefaultRanking == 1) { echo '<td>'.number_format($rdata[9],0,",",".").'</td>'; } else if($SetKundun == 1){ echo '<td>'.number_format($rdata[5],0,",",".").'</td>';  } }
						if($ShowMedusa == 1) { if($DefaultRanking == 1) { echo '<td>'.number_format($rdata[10],0,",",".").'</td>'; } else if($SetMedusa == 1){ echo '<td>'.number_format($rdata[5],0,",",".").'</td>';  } }
						if($ShowAtikus == 1) { if($DefaultRanking == 1) { echo '<td>'.number_format($rdata[11],0,",",".").'</td>'; } else if($SetAtikus == 1){ echo '<td>'.number_format($rdata[5],0,",",".").'</td>';  } }
						if($ShowLordSilvester == 1) { if($DefaultRanking == 1) { echo '<td>'.number_format($rdata[12],0,",",".").'</td>'; } else if($SetLordSilvester == 1){ echo '<td>'.number_format($rdata[5],0,",",".").'</td>';  } }
						if($ShowLordFerea == 1) { if($DefaultRanking == 1) { echo '<td>'.number_format($rdata[13],0,",",".").'</td>'; } else if($SetLordFerea == 1){ echo '<td>'.number_format($rdata[5],0,",",".").'</td>';  } }
						if($rdata[2] != null){
							echo '<td style="padding-top: unset;padding-bottom: unset;"><table style="margin-left:-4px;">
												<tbody><tr style="background: unset !important;"><td align="left" style="border:0;">
													'.returnGuildLogo($rdata[3], 30).'
												</td>
												<td style="border:0;">
													<div style="margin-left:3px;font-size:13px;font-family: Roboto, sans-serif;">'.$rdata[2].'
													<div style="font-size:8.5px;margin-top:-0;">
														'.$G_Status.'
													</div>
													</div>
												</td>
											</tr></tbody></table></td>';
						}else{
						echo '<td style="padding-top: unset;padding-bottom: unset;"><table style="margin-left:-4px;">
												<tbody><tr style="background: unset !important;">
												<td style="border:0;">
													<div style="font-weight:700;font-size:13px;font-family: Roboto, sans-serif;color:red;"><i class="fas fa-times-circle"></i> Sin Guild
													<div style="font-size:8.5px;margin-top:-0;">
														
													</div>
													</div>
												</td>
											</tr></tbody></table></td>';
						}
					echo '</tr>';
				}
				$i++;
			}
			echo '</tbody>';
		echo '</table>';
	echo '</div>';
		echo '<br><div class="alert alert-info m-t-10">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';

	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}