<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

try {
    
    echo '<div class="page-title"><span>Top PvP Championship</span></div>';

	$Rankings = new Rankings();
	$Rankings->rankingsMenu();
	loadModuleConfigs('rankings');
	
	if(!mconfig('rankings_enable_pvp')) throw new Exception(lang('error_44',true));
	if(!mconfig('active')) throw new Exception(lang('error_44',true));
	
	$ranking_data = LoadCacheData('rankings_pvpchampionship.cache');
	if(!is_array($ranking_data)) throw new Exception(lang('error_58',true));
	
	$showPlayerCountry = mconfig('show_country_flags') ? true : false;
	$charactersCountry = loadCache('character_country.cache');
	if(!is_array($charactersCountry)) $showPlayerCountry = false;
	
	if(mconfig('show_online_status')) $onlineCharacters = loadCache('online_characters.cache');
	if(!is_array($onlineCharacters)) $onlineCharacters = array();
	
	echo '<table class="table dataTableChar dataTable no-footer general-rank text-center mt-2" style="white-space: nowrap;" id="RankingGeneral" role="grid">';
	echo '<thead class="bg-primary text-white">';
	echo '<tr role="row">';
	if(mconfig('rankings_show_place_number')) {
		echo '<td style="font-weight:bold;"><i class="fas fa-list-ol"></i></td>';
	}
	echo '<td style="font-weight:bold;" class="text-start"><i class="far fa-user"></i> '.lang('rankings_txt_10').'</td>';
	echo '<td style="font-weight:bold;"><i class="fa-solid fa-check"></i> Ganadas</td>';
	echo '<th style="font-weight:bold;"><i class="fa-solid fa-khanda"></i> Asesinatos</th>';
	echo '<th style="font-weight:bold;"><i class="fa-solid fa-skull-crossbones"></i> Muertes</th>';
	if($showPlayerCountry) echo '<td style="font-weight:bold;"><i class="fa fa-globe"></i></td>';
	echo '</tr>';
	echo '</thead>';
	$i = 0;
	echo '<tbody>';
	foreach($ranking_data as $rdata) {
		$onlineStatus = mconfig('show_online_status') ? in_array($rdata[1], $onlineCharacters) ? 'aifos-char-online' : 'aifos-char-offline' : '';
		$characterIMG = getPlayerClassAvatar($rdata[0], true, true, 'rankings-class-image rounded-circle '.$onlineStatus.'');
		if($i>=1) {
			echo '<tr data-class-id='.$rdata[1].'>';
			if(mconfig('rankings_show_place_number')) {
				echo '<td class="rankings-table-place"><i class="fas fa-medal"></i> '.$i.'</td>';
			}
			echo '<td class="text-start">'.$characterIMG.' '.playerProfile($rdata[1]).'</td>';
			echo '<td class="ranking_new fw-bold text-success" style="text-align: center;">'.number_format($rdata[2],0,'','.').'</td>';
			echo '<td class="ranking_new" style="text-align: center;">'.number_format($rdata[3],0,'','.').'</td>';
			echo '<td class="ranking_new" style="text-align: center;">'.number_format($rdata[4],0,'','.').'</td>';
			if($showPlayerCountry) echo '<td align="center"><img src="'.getCountryFlag($charactersCountry[$rdata[1]]).'" /></td>';
			echo '</tr>';
		}
		$i++;
	}
	echo '</tbody>';
	echo '</table>';
	if(mconfig('rankings_show_date')) {
		echo '<div class="rankings-update-time">';
		echo ''.lang('rankings_txt_20',true).' ' . date("m/d/Y - h:i A",$ranking_data[0][0]);
		echo '</div>';
	}
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}