<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.1
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

if(!isLoggedIn()) redirect(1,'login');

echo'<h2 class="character-header text-center"><i class="fas fa-gift"></i> Codigo de Regalo</h2><hr>';

try {
	$Character  =   new Character();
	$AccountCharacters = $Character->AccountCharacter($_SESSION['username']);
	if(!is_array($AccountCharacters)) throw new Exception(lang('error_46',true));
	
	if(check_value($_POST['submit'])) {
        try{
            $GiftCode   =   new GiftCode();
            $GiftCode->Verificaciones($_SESSION['username'], $_POST['character'],$_POST['gift_code']);
        } catch(Exception $ex) {
            message('error', $ex->getMessage());
        }
	}

    echo '<div class="alert alert-primary text-center" role="alert">';
        echo 'Ingresa el codigo de regalo y <b>OBTIENE</b> tus recompensas.';
    echo '</div>';

	echo '<form action="" method="post">';
		echo '<table class="table table-bordered">';
            echo '<thead class="thead-dark">';
                echo '<tr>';
                    echo '<th scope="col"><i class="fas fa-ticket-alt"></i> Ingresa el Codigo</th>';
                    echo '<th scope="col"><i class="fas fa-user"></i> Seleciona Personaje</th>';
                echo '</tr>';
            echo '</thead>';
            echo '<tbody>';
                echo '<tr>';
                    echo '<td>';
                        echo'<input type="text" class="form-control" name="gift_code" minlength="15" maxlength="15" required>';
                    echo '</td>';
                    echo '<td>';
                        echo '<select class="form-control optionfix" name="character" required>';
                        foreach($AccountCharacters as $thisCharacter) {
                                $characterData = $Character->CharacterData($thisCharacter);
                            echo'<option value="'.$characterData[_CLMN_CHR_NAME_].'">'.$characterData[_CLMN_CHR_NAME_].'</option>';
                        }
                        echo'</select>';
                    echo '</td>';
                echo '</tr>';
                echo '<tr>';
                    echo '<td colspan="2" class="text-center">';
                        echo '<button name="submit" value="submit" class="btn btn-primary"><i class="fas fa-gift"></i> Obtener recompensa</button>';
                    echo '</td>';
                echo '</tr>';
            echo '</tbody>';
        echo '</table>';
        echo'<div align="center"></div>';
	echo '</form>';
    } catch(Exception $ex) {
	message('error', $ex->getMessage());
}
