<?php
if(!isLoggedIn()) redirect(1,'login');
function log_trans_sell($message)
{
	$logFile = fopen(__PATH_LOGS__."market/".$_SESSION['username'].".txt", 'a');
	fwrite($logFile, "\n[".date("d/m/Y H:i:s")."] ".$message);
	fclose($logFile);
}

loadModuleConfigs('marketchar');

if(!mconfig('active')) throw new Exception(lang('error_47',true)); 

$common = new common();
$this->muonline = Connection::Database('MuOnline');

$szItems = new Items();

function safe_input($string){
	$string = preg_replace('[^A-Za-z0-9]', "", $string );

	return $string;
}

echo '<div class="page-title"><span>Comprar Personaje</span></div>';
echo '<div class="alert alert-info">';
	echo '<h3 class="tips-ayudas-color">&nbsp;REQUISITOS</h3>';
	echo '<p class="alert-info">';
		echo '<ul>';
			echo '<li>Tener los <b>'.mconfig('moneda_v').'</b> necesarios que pide el personaje.</li>';
			echo '<li>Slot Disponible de personaje en la cuenta actual.</li>';
			echo '<li>Debes elegir un nuevo nombre para el personaje.</li>';
			echo '<li>El nuevo nombre no puede ser igual al anterior.</li>';
			echo '<li>El nombre no puede contener caracteres raros.</li>';
			echo '<li>El nombre debe ser de 4 a 10 caracteres.</li>';
		echo '</ul>';	
		echo 'Si cumples con los requisitos, pulsa el boton COMPRAR<br>';
		echo '<br><b>ATENCION: Una vez que hayas comprado el personaje, no hay devoluciones. Ten en cuenta antes de comprar!</b>';
	echo '</p>';
echo '</div>';

if(isset($_POST['id']) && isset($_POST['comprar']))
{
	$costo = 0;
	$id = safe_input($_POST['id']);
	
	$id = explode("|", $id);

	$CharacteSell = $id[0];
	$AccountSell = $id[1];
	$PrecioPub = $id[2];
	
	if($common->accountOnline($_SESSION['username'])) 
	{
		$bloquear = 1;
		message("error", "Debes estar desconectado.");
		log_trans_sell('El usuario '.$_SESSION['username'].' Quiso comprar un personaje estando conectado');
	}else{
		if(empty($_POST['name']))
		{
			$bloquear = 1;
			message("error", "Debes colocar un nuevo nombre");
			log_trans_sell('El usuario '.$_SESSION['username'].' no pudo comprar el personaje porque no eligio nuevo nombre.');
		}else{
			$NameCharacter = safe_input($_POST['name']);
			if($NameCharacter == $CharacteSell){
				$bloquear = 1;
				message("error", "Debes colocar un nombre diferente al que posee el personaje actualmente.");
				log_trans_sell('El usuario '.$_SESSION['username'].' no pudo comprar el personaje porque puso el mismo nombre que tenia.');
			}else{
				if(strlen($NameCharacter) < 4 || strlen($NameCharacter) > 10)
				{
					$bloquear = 1;
					message("error", "El nombre del Personaje debe tener entre 4 y 10 caracteres");
					log_trans_sell('El usuario '.$_SESSION['username'].' Quiso comprar un personaje con menos de 4 caracteres o mas de 10');
				}
			}
		}
	}
	
	$check = $this->muonline->query_fetch_single("SELECT * FROM Character  WHERE Name='".$CharacteSell."'");
	$coins = $this->muonline->query_fetch_single("SELECT * FROM ".mconfig('tabla_moneda')."  WHERE AccountID='".$_SESSION['username']."'");
	
	if($PrecioPub != $check['PrecioPJ'])
	{
		message("error", "El precio del personaje fue actualizado, la compra no pudo ser completada.");
		log_trans_sell('El usuario '.$_SESSION['username'].' Quiso comprar un personaje por '.$PrecioPub.' y el precio fue actualizado a '.$check['PrecioPJ'].'.');
		$bloquear = 1;
		
	}
	if(mconfig('comission'))
	{
		$Comision = ($check['PrecioPJ'] * mconfig('comission_porc') / 100);
		$ComTotal = $check['PrecioPJ'] - $Comision;
	}else $ComTotal  = $check['PrecioPJ'];
		
	$PrecioPersonaje = $check['PrecioPJ'];

	if($coins[mconfig('moneda')] >= $PrecioPersonaje )
	{
		if($check['AccountID'] != $_SESSION['username']) 
		{
			if($check['AccountID'] == $AccountSell) 
			{
				if($check['PrecioPJ'] > 10)
				{
					$row = $this->muonline->query_fetch_single("SELECT * FROM AccountCharacter  WHERE Id='".$_SESSION['username']."'");
					
					if(is_array($row))
					{
						
						if(strlen($row['GameID1']) == 0 || empty($row['GameID1']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID1='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else if(strlen($row['GameID2']) == 0 || empty($row['GameID2']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID2='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else if(strlen($row['GameID3']) == 0 || empty($row['GameID3']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID3='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else if(strlen($row['GameID4']) == 0 || empty($row['GameID4']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID4='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else if(strlen($row['GameID5']) == 0 || empty($row['GameID5']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID5='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else if(strlen($row['GameID6']) == 0 || empty($row['GameID6']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID6='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else if(strlen($row['GameID7']) == 0 || empty($row['GameID7']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID7='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else if(strlen($row['GameID8']) == 0 || empty($row['GameID8']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID8='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else if(strlen($row['GameID9']) == 0 || empty($row['GameID9']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID9='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else if(strlen($row['GameID10']) == 0 || empty($row['GameID10']))
						{
							$querybuy = "UPDATE AccountCharacter SET GameID10='".$CharacteSell."' WHERE Id='".$_SESSION['username']."'";
						}
						else 
						{
							message("error", "No tienes espacio para un nuevo personaje.");
							log_trans_sell('El usuario '.$_SESSION['username'].' Quiso comprar un personaje por y no tenia espacio.');
							$bloquear = 1;
						}
					}

					if($bloquear == 0)
					{
						$this->muonline->query($querybuy);
						$this->muonline->query("UPDATE AccountCharacter SET  GameID1= NULL WHERE Id='".$AccountSell."' AND GameID1='".$CharacteSell."'");
						$this->muonline->query("UPDATE AccountCharacter SET  GameID2= NULL WHERE Id='".$AccountSell."' AND GameID2='".$CharacteSell."'");
						$this->muonline->query("UPDATE AccountCharacter SET  GameID3= NULL WHERE Id='".$AccountSell."' AND GameID3='".$CharacteSell."'");
						$this->muonline->query("UPDATE AccountCharacter SET  GameID4= NULL WHERE Id='".$AccountSell."' AND GameID4='".$CharacteSell."'");
						$this->muonline->query("UPDATE AccountCharacter SET  GameID5= NULL WHERE Id='".$AccountSell."' AND GameID5='".$CharacteSell."'");
						$this->muonline->query("UPDATE AccountCharacter SET  GameID6= NULL WHERE Id='".$AccountSell."' AND GameID6='".$CharacteSell."'");
						$this->muonline->query("UPDATE AccountCharacter SET  GameID7= NULL WHERE Id='".$AccountSell."' AND GameID7='".$CharacteSell."'");
						$this->muonline->query("UPDATE AccountCharacter SET  GameID8= NULL WHERE Id='".$AccountSell."' AND GameID8='".$CharacteSell."'");
						$this->muonline->query("UPDATE AccountCharacter SET  GameID9= NULL WHERE Id='".$AccountSell."' AND GameID9='".$CharacteSell."'");
						$this->muonline->query("UPDATE AccountCharacter SET  GameID10= NULL WHERE Id='".$AccountSell."' AND GameID10='".$CharacteSell."'");
						
						$this->muonline->query("UPDATE ".mconfig('tabla_moneda')." SET  ".mconfig('moneda')."= ".mconfig('moneda')."+".$ComTotal." WHERE AccountID='".$AccountSell."'");
						$this->muonline->query("UPDATE ".mconfig('tabla_moneda')." SET  ".mconfig('moneda')."= ".mconfig('moneda')."-".$PrecioPersonaje." WHERE AccountID='".$_SESSION['username']."'");
						
						$this->muonline->query("UPDATE Character SET  AccountID='".$_SESSION['username']."', PrecioPJ = 0, CtlCode= 0 WHERE Name='".$CharacteSell."'"); 
						$this->muonline->query("WZ_RenameCharacter '".$_SESSION['username']."','".$CharacteSell."','".$NameCharacter."'");
						$coins2 = $this->muonline->query_fetch_single("SELECT * FROM ".mconfig('tabla_moneda')."  WHERE AccountID='".$AccountSell."'");
						
						log_trans_sell('El usuario '.$_SESSION['username'].' compro el personaje '.$CharacteSell.', y le cambio el nombre a '.$NameCharacter.'.');
						log_trans_sell('El usuario '.$_SESSION['username'].' tenia '.$coins[mconfig('moneda')].', ahora tiene '.($coins[mconfig('moneda')] - $PrecioPersonaje).'.');
						log_trans_sell('El usuario '.$AccountSell.' tenia '.$coins2[mconfig('moneda')].', ahora tiene '.($coins[mconfig('moneda')] + $ComTotal).'.');
						
						message("success", "Compraste el personaje correctamente.");
					}
				}else {
					message("error", "El personaje no esta disponible.");
					log_trans_sell('El usuario '.$_SESSION['username'].' intento comprar el personaje '.$CharacteSell.', pero no esta disponible.');
				}
			}else {
				message("error", "El personaje no esta disponible.");
				log_trans_sell('El usuario '.$_SESSION['username'].' intento comprar el personaje '.$CharacteSell.', pero no esta disponible.');
			}
		}else {
			message("error", "No puedes comprar tu personaje.");
			log_trans_sell('El usuario '.$_SESSION['username'].' intento comprar el personaje '.$CharacteSell.', pero es de la misma cuenta.');
		}
	}else
	{
			message("error", "No tienes ". mconfig('moneda_v') . " suficientes. ");
			log_trans_sell('El usuario '.$_SESSION['username'].' intento comprar el personaje '.$CharacteSell.', pero no tiene creditos suficientes.');
		} 
}

else if(isset($_POST['id']) && isset($_POST['infopj']))
{
	if($common->accountOnline($_SESSION['username'])) 
	{
		message("error", "Debes estar desconectado.");
	}
	$id = safe_input($_POST['id']);
	
	$id = explode("|", $id);

	$CharacteSell = $id[0];
	$AccountSell = $id[1];
	
	$result = $this->muonline->query_fetch_single("select * from [Character] where [Name]= '".$CharacteSell."'");
	$result2 = $this->muonline->query_fetch_single("select * from [MasterSkillTree] where [Name]= '".$CharacteSell."'");
	$result3 = $this->muonline->query_fetch_single("select * from [Gens_Duprian] where [Name]= '".$CharacteSell."'");
	
	echo '<div class="panel panel-success text-center">'; 

	if($result['Class'] == 0 || $result['Class'] == 1 || $result['Class'] == 2){
		$ColorBorder 	= 	'#2f7dcc';
		$ColorText		=	'#f1f1f1';
		$BackColor		=	'rgba(47, 125, 204, 0.1)';
	}
	else if($result['Class'] == 16 || $result['Class'] == 17 || $result['Class'] == 18){
		$ColorBorder 	= 	'#cc2f2f';	
		$ColorText		=	'#f1f1f1';
		$BackColor		=	'rgba(204, 47, 47, 0.1)';
	}
	else if($result['Class'] == 32 || $result['Class'] == 33 || $result['Class'] == 34){
		$ColorBorder 	= 	'#33cc2f';
		$ColorText		=	'#f1f1f1';		
		$BackColor		=	'rgba(51, 204, 47, 0.1)';
	}
	else if($result['Class'] == 48 || $result['Class'] == 49 || $result['Class'] == 50){
		$ColorBorder 	= 	'#712fcc';
		$ColorText		=	'#f1f1f1';
		$BackColor		=	'rgba(113, 47, 204, 0.1)';
	}
	else if($result['Class'] == 64 || $result['Class'] == 65 || $result['Class'] == 66){
		$ColorBorder 	= 	'#cc9e2f';	
		$ColorText		=	'#f1f1f1';
		$BackColor		=	'rgba(204, 158, 47, 0.1)';
	}
	else if($result['Class'] == 80 || $result['Class'] == 81 || $result['Class'] == 82){
		$ColorBorder 	= 	'#bf2fcc';	
		$ColorText		=	'#f1f1f1';
		$BackColor		=	'rgba(191, 47, 204, 0.1)';
	}
	else if($result['Class'] == 96 || $result['Class'] == 97 || $result['Class'] == 98){
		$ColorBorder 	= 	'#cc542f';	
		$ColorText		=	'#f1f1f1';
		$BackColor		=	'rgba(204, 84, 47, 0.1)';
	}

	if($result['Leadership'] > 0) {
		$ColSpan = 5;
		$Width = 20;
	}else {
		$ColSpan = 4;
		$Width = 25;
	}

	$inventory = $szItems->GetCharInventoryResponsive($CharacteSell);
	
		echo '<form action="" method="post" class="text-center">';
			  echo '<h1 class="text-success">Comprar Personaje</h1>';
			  echo '<h5>Precio del personaje:</h5>';
			  echo '<h3 class="text-danger"><b> <i class="fas fa-coins"></i> '.number_format($result['PrecioPJ'],0,",",".").'</b></h3>';
			  echo '<input type="hidden" id="id" name="id" value="'.$result['Name'].'|'.$result['AccountID'].'|'.$result['PrecioPJ'].'"><br>';
			  echo '<input class="form-control input-lg" type="text" id="name" name="name" placeholder="Nuevo Nombre" ><br>';
			  echo '<p>Ingresa el nuevo nombre del personaje en el recuadro de arriba.</p></b>';
			  echo '<input class="btn btn-success btn-lg" name="comprar" type="submit" value="Comprar">';
			echo '</form>';
	
			echo '</div>';
			echo '<hr>';
	
	
	echo '<table class="table table-bordered">';
		echo '<thead style="background-color:'.$ColorBorder.';">';
			echo '<tr>';
				echo '<th class="text-start" scope="col" style="color:'.$ColorText.';border-right: unset;"><i class="fas fa-user"></i> '.$CharacteSell.'</th>';
				echo '<th class="text-end" scope="col" style="color:'.$ColorText.';border-left: unset;"><i class="fas fa-coins"></i> '. number_format($result['PrecioPJ'],0,",","."). ' ' . mconfig('moneda_v') .'</th>';
			echo '</tr>';
		echo '</thead>';
		echo '<tbody>';
			echo '<tr>';
				echo '<td style="border-color:'.$ColorBorder.';background-color:'.$BackColor.'" colspan="2">';
				echo '<div class="container position-relative">';
			echo '<div class="row">';
				echo '<div class="col-12">';

				echo $inventory;
				
				echo '</div> ';
			echo '</div>';		
		echo '</div>';
				echo '</td>';
			echo '</tr>';
		echo '</tbody>';
	echo '</table>';
		

echo '<div class="table-responsive">';
echo '<table class="table text-center table-bordered">';
	echo '<thead style="background-color:'.$ColorBorder.';">';
		  echo '<tr>';
			echo '<th scope="col" colspan="6" style="color:'.$ColorText.';"><i class="fas fa-exclamation-circle"></i> Informacion</th>';
		  echo '</tr>';
	echo '</thead>';
	echo '<tbody>';
		echo '<tr>';
			echo '<th><i class="fas fa-angle-up"></i> Nivel</th>';
			echo '<th><i class="fas fa-angle-double-up"></i> Master LVL</th>';
			echo '<th><i class="fas fa-angle-double-up"></i> Master Points</th>';
			echo '<th><i class="fas fa-redo-alt"></i> Resets</th>';
			echo '<th><i class="fas fa-recycle"></i> Grand Resets</th>';
		echo '</tr>';
		echo '<tr>';
			echo '<td>'.number_format($result['cLevel']).'</td>';
			echo '<td style="color:red;font-weight:600;">'.number_format($result2['MasterLevel']).'</td>';
			echo '<td style="color:red;font-weight:600;">'.number_format($result2['MasterPoint']).'</td>';
			echo '<td style="color:green;font-weight:600;">'.number_format($result['ResetCount'],0,",",".").'</td>';
			echo '<td>'.number_format($cData[11],0,",",".").'</td>';
		echo '</tr>';
	echo '</tbody>';
echo '</table>';
echo '</div>';		

echo '<br>';


echo '<div class="table-responsive">';
		echo '<table class="table text-center table-bordered">';
			echo '<thead style="background-color:'.$ColorBorder.';">';
		  		echo '<tr>';
					echo '<th scope="col" colspan="'.$ColSpan.'" style="color:'.$ColorText.';"><i class="fas fa-chart-bar"></i> Stats</th>';
		  		echo '</tr>';
			echo '</thead>';
			echo '<tbody>';
				echo '<tr>';
					echo '<th><i class="fas fa-fist-raised"></i> '.lang('profiles_txt_10',true).'</th>';
					echo '<th><i class="fab fa-gg"></i> '.lang('profiles_txt_11',true).'</th>';
					echo '<th><i class="fas fa-heartbeat"></i> '.lang('profiles_txt_12',true).'</th>';
					echo '<th><i class="fas fa-hat-wizard"></i> '.lang('profiles_txt_13',true).'</th>';
					if($result['Leadership'] > 0) {
						echo '<th><i class="fab fa-phoenix-framework"></i> '.lang('profiles_txt_14',true).'</th>';
					}
				echo '</tr>';
		  		echo '<tr>';
		  			echo '<td style="width:'.$Width.'%;">';
		  				echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
  							echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($result['Strength']/320).'%; min-width:40%;" aria-valuenow="'.number_format($result['Strength']/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($result['Strength'],0,",",".").'</div>';
						echo '</div>';
					echo '</td>';
					echo '<td style="width:'.$Width.'%;">';
		  				echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
  							echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($result['Dexterity']/320).'%; min-width:40%;" aria-valuenow="'.number_format($result['Dexterity']/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($result['Dexterity'],0,",",".").'</div>';
						echo '</div>';
					echo '</td>';
					echo '<td style="width:'.$Width.'%;">';
						echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
							echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($result['Vitality']/320).'%; min-width:40%;max-width:100%" aria-valuenow="'.number_format($result['Vitality']/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($result['Vitality'],0,",",".").'</div>';
				 	 	echo '</div>';
			  		echo '</td>';
					echo '<td style="width:'.$Width.'%;">';
						echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
							echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($result['Energy']/320).'%; min-width:40%;max-width:100%" aria-valuenow="'.number_format($result['Energy']/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($result['Energy'],0,",",".").'</div>';
				 	 	echo '</div>';
			  		echo '</td>';
					if($result['Leadership'] > 0) {
					echo '<td style="width:'.$Width.'%;">';
					  echo '<div class="progress" style="height: 20px;font-family: \'Dosis\', sans-serif;font-size: 15px !important;">';
						  echo '<div class="progress-bar bg-dark" role="progressbar" style="width: '.number_format($result['Leadership']/320).'%; min-width:40%;max-width:100%" aria-valuenow="'.number_format($result['Leadership']/650).'" aria-valuemin="0" aria-valuemax="100">'.number_format($result['Leadership'],0,",",".").'</div>';
						echo '</div>';
					echo '</td>';
					}
					echo '</tr>';
			echo '</tbody>';
		echo '</table>';
	echo '</div>';

}
else {
	if($common->accountOnline($_SESSION['username'])) 
	{
		message("error", "Debes estar desconectado.");
	}
	$result = $this->muonline->query_fetch("SELECT * FROM Character  WHERE CtlCode = 1 AND PrecioPJ > 10");
	if(is_array($result))
	{
		echo '<div class="row">';
		foreach($result as $row)
		{
			if($row['Class'] == 0 || $row['Class'] == 1 || $row['Class'] == 2){
				$ClassRaza		=	'RazaSM';
				$ClassBtnRaza	=	'BtnSM';
				$ColorTextRaza 	=	'#2f7dcc';
			}
			else if($row['Class'] == 16 || $row['Class'] == 17 || $row['Class'] == 18){
				$ClassRaza		=	'RazaDK';
				$ClassBtnRaza	=	'BtnDK';
				$ColorTextRaza 	=	'#cc2f2f';
			}
			else if($row['Class'] == 32 || $row['Class'] == 33 || $row['Class'] == 34){
				$ClassRaza		=	'RazaELF';
				$ClassBtnRaza	=	'BtnELF';
				$ColorTextRaza 	=	'#33cc2f';
			}
			else if($row['Class'] == 48 || $row['Class'] == 49 || $row['Class'] == 50){
				$ClassRaza		=	'RazaMG';
				$ClassBtnRaza	=	'BtnMG';
				$ColorTextRaza 	=	'#712fcc';
			}
			else if($row['Class'] == 64 || $row['Class'] == 65 || $row['Class'] == 66){
				$ClassRaza		=	'RazaDL';
				$ClassBtnRaza	=	'BtnDL';
				$ColorTextRaza 	=	'#cc9e2f';
			}
			else if($row['Class'] == 80 || $row['Class'] == 81 || $row['Class'] == 82){
				$ClassRaza		=	'RazaSUM';
				$ClassBtnRaza	=	'BtnSUM';
				$ColorTextRaza 	=	'#bf2fcc';
			}
			else if($row['Class'] == 96 || $row['Class'] == 97 || $row['Class'] == 98){
				$ClassRaza		=	'RazaRF';
				$ClassBtnRaza	=	'BtnRF';
				$ColorTextRaza 	=	'#cc542f';
			}

			$result2 = $this->muonline->query_fetch_single("select * from [MasterSkillTree] where [Name]= '".$row['Name']."'");
			if($result2['MasterLevel'] == NULL) $result2['MasterLevel'] = 0;

			$characterIMG = getPlayerClassAvatar($row['Class'], false);
			echo '<div class="col-sm-12 col-md-12" style="margin-bottom:15px;">';

			echo '<div class="card mb-3 '.$ClassRaza.'"">';
			echo '<div class="row g-0">';
			  echo '<div class="col-md-4">';
				echo '<img src="'.getPlayerClassAvatar($row['Class'],0,1).'" class="img-fluid rounded-start" alt="'.getPlayerClass($row['Class']).'" style="width:100%;height:100%;">';
			  echo '</div>';
			  echo '<div class="col-md-8">';
				echo '<div class="card-body" style="padding:10px;">';
					echo '<span class="h5 align-items-center"><b>'.$row['Name'].'';
					echo '<small class="card-title" style="color:'.$ColorTextRaza.';">[ '.getPlayerClass($row['Class']).' ]</b></small></span>';
					echo '<p class="card-text">';
					echo '<div class="input-group input-group-sm mb-1">';
						echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-redo-alt"></i>&nbsp;Resets</span>';
						echo '<span class="form-control">'.$row['ResetCount'].'</span>';
					echo '</div>';
					echo '<div class="input-group input-group-sm mb-1">';
						echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-angle-up"></i>&nbsp;Nivel</span>';
						echo '<span class="form-control">'.$row['cLevel'].'</span>';
						echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-angle-double-up"></i>&nbsp;Master&nbsp;Level</span>';
						echo '<span class="form-control">'.$result2['MasterLevel'].'</span>';
					echo '</div>';
					echo '<div class="input-group input-group-sm mb-1">';
						echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-coins"></i>&nbsp;Precio</span>';
						echo '<span class="form-control text-danger"><b>'.number_format($row['PrecioPJ'],0,",",".").' '.mconfig('moneda_v').'</b></span>';
					echo '</div>';
				echo '</p>';
				echo '</div>';
				echo '<div class="card-footer">';
					echo '<p class="card-text">';
					echo '<form action="" method="post"><div class="input-group">';
						echo '<input type="hidden" id="id" name="id" value="'.$row['Name'].'">';
					    echo '<input type="hidden" id="rst" name="rst" value="'.$row['ResetCount'].'">';
					    echo '<input class="form-control" type="text" placeholder="Informacion Completa del Personaje" disabled>';
						echo '<form action="" method="post">';
						echo '<input type="hidden" id="id" name="id" value="'.$row['Name'].'|'.$row['AccountID'].'"><br>';
						echo '<input class="btn btn-outline-secondary '.$ClassBtnRaza.'" name="infopj" type="submit" value="Ver">';
					  echo '</form>';
					echo '</div></form>';
					echo '</p>';
				echo '</div>';
			  echo '</div>';
			echo '</div>';
		 echo ' </div>';

		echo '</div>';


		}
		echo '</div>';
	}
}



?>
