<?php
/**
 * WebEngine CMS
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2019 Lautaro Angelico, All Rights Reserved
 * 
 * Licensed under the MIT license
 * http://opensource.org/licenses/MIT
 */

if(!isLoggedIn()) redirect(1,'login');
echo '<div class="miniranks border border-primary fs-3 rounded text-primary text-center text-uppercase"><i class="fas fa-user-circle"></i> '.lang('module_titles_txt_4',true).'</div><hr>';

// module status
if(!mconfig('active')) throw new Exception(lang('error_47',true));

// Webengine cfg
$newCfg = loadConfig('webengine');

// common class
$common = new common();

// Retrieve Account Information
$accountInfo = $common->accountInformation($_SESSION['userid']);
if(!is_array($accountInfo)) throw new Exception(lang('error_12',true));

$UltimaConexion = $common->accountMembStat($_SESSION['username']);

# account online status
$onlineStatus = ($common->accountOnline($_SESSION['username']) ? '<span class="form-control bg-success text-white"><i class="fas fa-toggle-on"></i> '.lang('myaccount_txt_9',true).'</span>' : '<span class="form-control bg-danger text-white"><i class="fas fa-toggle-off"></i> '.lang('myaccount_txt_10',true).'</span>');

# account status
$accountStatus = ($accountInfo[_CLMN_BLOCCODE_] == 1 ? '<span class="label label-danger">'.lang('myaccount_txt_8',true).'</span>' : '<span class="label label-default">'.lang('myaccount_txt_7',true).'</span>');

# characters info
$Character = new Character();
$AccountCharacters = $Character->AccountCharacter($_SESSION['username']);

echo '<div class="row">';
	try {
	$creditSystem = new CreditSystem();
	$creditCofigList = $creditSystem->showConfigs();
	if(is_array($creditCofigList)) {
		foreach($creditCofigList as $myCredits) {
			if(!$myCredits['config_display']) continue;
			
			$creditSystem->setConfigId($myCredits['config_id']);
			switch($myCredits['config_user_col_id']) {
				case 'userid':
					$creditSystem->setIdentifier($accountInfo[_CLMN_MEMBID_]);
					break;
				case 'username':
					$creditSystem->setIdentifier($accountInfo[_CLMN_USERNM_]);
					break;
				case 'email':
					$creditSystem->setIdentifier($accountInfo[_CLMN_EMAIL_]);
					break;
				default:
					continue 2;
			}
			
			$configCredits = $creditSystem->getCredits();

			?>
			<div class="col-md-4">
				<div class="card text-center" style="text-transform: uppercase;">
					<div class="card-header">
						<i class="fa fa-database"></i> <?php echo $myCredits['config_title'];?>
					</div>
					<div class="card-body">
						<h3 class="card-text text-success" style="font-family: sans-serif;text-transform: uppercase;"><?php echo number_format($configCredits,0,",",".");?></h3>
					</div>
				</div>
			</div>
			<?php
		}
	}
} catch(Exception $ex) {}
		?>
		<div class="col-md-4">
			<div class="card text-center" style="text-transform: uppercase;">
				<div class="card-header">
					<i class="fa fa-star"></i> VIP
				</div>
				<div class="card-body">
					<?php 
						if($accountInfo[_CLMN_VIP_TYPE_] == 0){
							echo '<h3 class="card-text text-danger" style="font-family: sans-serif;text-transform: uppercase;"> Sin Vip</h3>';
						}
						elseif($accountInfo[_CLMN_VIP_TYPE_] == 1){
							echo '<h3 class="card-text" style="font-family: sans-serif;text-transform: uppercase;color:#af6941 !important;"> VIP BRONCE</h3>';
						}
						elseif($accountInfo[_CLMN_VIP_TYPE_] == 2){
							echo '<h3 class="card-text text-secondary" style="font-family: sans-serif;text-transform: uppercase;"> VIP PLATA</h3>';
						}
						elseif($accountInfo[_CLMN_VIP_TYPE_] == 3){
							echo '<h3 class="card-text text-warning" style="font-family: sans-serif;text-transform: uppercase;"> VIP ORO</h3>';
						}
					?>
				</div>
			</div>
		</div>

		</div>
		<br>

		<div class="card mb-3">
			<div class="row g-0">
				<div class="col-md-2">
				<img src="<?php echo __PATH_TEMPLATE__; ?>favicon.png" class="img-fluid rounded-start" alt="<?=$newCfg['server_name'];?>">
				</div>
				<div class="col-md-10">
				<div class="card-body">
					<h5 class="card-title">Hola <font class="text-success"><?php echo $accountInfo[_CLMN_USERNM_]; ?></font> !</h5>
					<p class="card-text">Bienvenido nuevamente a <?=$newCfg['server_name'];?>, disfruta de tu estadia.</p>
				</div>
				</div>
			</div>
		</div>

		<?php

echo '<div class="input-group mb-2">';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-user"></i></span>';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm">'.lang('myaccount_txt_1',true).'</span>';
	echo '<span class="form-control bg-success text-white"><i class="fas fa-check-square"></i> '.$accountStatus.'</span>';
echo '</div>';

echo '<div class="input-group mb-2">';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-envelope"></i></span>';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm">'.lang('myaccount_txt_3',true).'</span>';
	echo '<span class="form-control">'.$accountInfo[_CLMN_EMAIL_].' <a href="'.__BASE_URL__.'usercp/myemail/" class="btn btn-sm btn-primary pull-right"><i class="fas fa-sync-alt"></i></a></span>';
echo '</div>';

echo '<div class="input-group mb-2">';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-lock"></i></span>';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm">'.lang('myaccount_txt_4',true).'</span>';
	echo '<span class="form-control">&#8226;&#8226;&#8226;&#8226;&#8226;&#8226;&#8226;&#8226; <a href="'.__BASE_URL__.'usercp/mypassword/" class="btn btn-sm btn-primary pull-right"><i class="fas fa-sync-alt"></i></a></span>';
echo '</div>';

echo '<div class="input-group mb-2">';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-eye"></i></span>';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm">'.lang('myaccount_txt_5',true).'</span>';
	echo $onlineStatus;
echo '</div>';

setlocale(LC_TIME, 'es_ES.UTF-8');
setlocale(LC_TIME, 'spanish');
$Horario = strftime("%d de %B del %Y @ %H:%M:%S", strtotime($UltimaConexion['ConnectTM']));

echo '<div class="input-group mb-2">';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-network-wired"></i></span>';
	echo '<span class="input-group-text" id="inputGroup-sizing-sm">Ultima conexion</span>';
	echo '<span class="form-control"><i class="far fa-clock"></i>&nbsp;'.$Horario.'</span>';
echo '</div>';

if($accountInfo[_CLMN_VIP_TYPE_] > 0){
	$Vencimiento = strftime("%d de %B del %Y @ %H:%M", strtotime($accountInfo[_CLMN_VIP_DATE_]));	

	echo '<div class="input-group mb-2">';
		echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-star"></i></span>';
		echo '<span class="input-group-text" id="inputGroup-sizing-sm">Vencimiento VIP</span>';
		echo '<span class="form-control bg-success text-white"><i class="far fa-clock"></i>&nbsp;'.$Horario.'</span>';
	echo '</div>';
}
		
		echo '<br><div class="miniranks border border-dark fs-5 rounded text-dark text-center text-uppercase"><i class="fas fa-users"></i> '.lang('myaccount_txt_15',true).'</div><hr>';

			if(is_array($AccountCharacters)) {
				foreach($AccountCharacters as $characterName) {
					$Personajes = $Character->CharacterData($characterName);
					$FormStr = $Personajes[_CLMN_CHR_STAT_STR_] / 650;
					$FormAgi = $Personajes[_CLMN_CHR_STAT_AGI_] / 650;
					$FormVit = $Personajes[_CLMN_CHR_STAT_VIT_] / 650;
					$FormEne = $Personajes[_CLMN_CHR_STAT_ENE_] / 650;
					$FormCom = $Personajes[_CLMN_CHR_STAT_CMD_] / 650;
					?>
					<div class="mini-ranks-hard card card-default" style="width:unset !important;height:unset !important;">
		  			<div class="card-body">
		  				<div class="row" style="display: flex;align-items: center;">
							<div class="col-md-4 col-lg-4" style="display:inline-block; vertical-align: top; padding-right: 15px; padding-left: 0px;" align="center">
								<h3 class="mini-ranks-hard-text"><?php echo $characterName; ?></h3>
								<?php echo '<img src="'.getPlayerClassAvatar($Personajes[_CLMN_CHR_CLASS_], false).'" width="70%" height="auto" style="-moz-border-radius: 2%;-webkit-border-radius: 2%;border-radius: 2%;-khtml-border-radius: 2%;border: 4px solid #151515;"/>'; ?>
								<br>

							</div>
							<div class="col-md-8 col-lg-8">
								<div class="row">
									<div class="col-md-12 col-lg-12" style="display:inline-block; vertical-align: top; padding-right: 15px;">
										<h3 class="mini-ranks-hard-text"><i class="fas fa-chart-bar"></i>&nbsp;Stats</h3>
										<div class="row justify-content-center align-items-center">
											<div class="col-md-4 col-lg-4 mini-ranks-hard-text mb-1"><i class="fas fa-fist-raised"></i>&nbsp;<strong>Fuerza:</strong></div>
											<div class="col-md-8 col-lg-8 justify-content-center mb-1" style="padding-left:unset !important;padding-right:unset !important;">
												<div class="progress progress-lg" style="height: 25px !important;background:#cacaca !important;">
												  	<div class="progress-bar bg-aifos" role="progressbar" aria-valuenow="28" aria-valuemin="0" aria-valuemax="32767" style="width: <?php echo $FormStr;?>%;min-width:10%;max-width:100%;;font-size: 15px;font-weight: 400;font-family: H67, Arial;text-transform: uppercase;">
													  <?php echo number_format("".$Personajes[_CLMN_CHR_STAT_STR_]."",0,",","."); ?>
												  	</div>
												</div>
											</div>
										</div>
										<div class="row justify-content-center align-items-center">
											<div class="col-md-4 col-lg-4 mini-ranks-hard-text mb-1"><i class="fab fa-gg"></i>&nbsp;<strong>Agilidad:</strong></div>
											<div class="col-md-8 col-lg-8 mb-1" style="padding-left:unset !important;padding-right:unset !important;">
												<div class="progress progress-lg" style="height: 25px !important;background:#cacaca !important;">
												  	<div class="progress-bar bg-aifos" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="32767" style="width: <?php echo $FormAgi;?>%;min-width:10%;max-width:100%;;font-size: 15px;font-weight: 400;font-family: H67, Arial;text-transform: uppercase;">
													  <?php echo number_format("".$Personajes[_CLMN_CHR_STAT_AGI_]."",0,",","."); ?>
												  	</div>
												</div>
											</div>
										</div>
										<div class="row justify-content-center align-items-center">
											<div class="col-md-4 col-lg-4 mini-ranks-hard-text mb-1"><i class="fas fa-heartbeat"></i>&nbsp;<strong>Vitalidad:</strong></div>
											<div class="col-md-8 col-lg-8 mb-1" style="padding-left:unset !important;padding-right:unset !important;">
												<div class="progress progress-lg" style="height: 25px !important;background:#cacaca !important;">
												  	<div class="progress-bar bg-aifos" role="progressbar" aria-valuenow="25" aria-valuemin="0" aria-valuemax="32767" style="width: <?php echo $FormVit;?>%;min-width:10%;max-width:100%;;font-size: 15px;font-weight: 400;font-family: H67, Arial;text-transform: uppercase;">
													  <?php echo number_format("".$Personajes[_CLMN_CHR_STAT_VIT_]."",0,",","."); ?>
												  	</div>
												</div>
											</div>
										</div>
										<div class="row justify-content-center align-items-center">
											<div class="col-md-4 col-lg-4 mini-ranks-hard-text mb-1"><i class="fas fa-hat-wizard"></i>&nbsp;<strong>Energia:</strong></div>
											<div class="col-md-8 col-lg-8 mb-1" style="padding-left:unset !important;padding-right:unset !important;">
												<div class="progress progress-lg" style="height: 25px !important;background:#cacaca !important;">
												  	<div class="progress-bar bg-aifos" role="progressbar" aria-valuenow="10" aria-valuemin="0" aria-valuemax="32767" style="width: <?php echo $FormEne;?>%;min-width:10%;max-width:100%;;font-size: 15px;font-weight: 400;font-family: H67, Arial;text-transform: uppercase;">
													  <?php echo number_format("".$Personajes[_CLMN_CHR_STAT_ENE_]."",0,",","."); ?>
												  	</div>
												</div>
											</div>
										</div>
										<?php
										if($Personajes[_CLMN_CHR_STAT_CMD_] > 0){
										?>
										<div class="row justify-content-center align-items-center">
											<div class="col-md-4 col-lg-4 mini-ranks-hard-text mb-1"><i class="fab fa-phoenix-framework"></i>&nbsp;<strong>Comando:</strong></div>
											<div class="col-md-8 col-lg-8 mb-1" style="padding-left:unset !important;padding-right:unset !important;">
												<div class="progress progress-lg" style="height: 25px !important;background:#cacaca !important;">
												  	<div class="progress-bar bg-aifos" role="progressbar" aria-valuenow="10" aria-valuemin="0" aria-valuemax="32767" style="width: <?php echo $FormCom;?>%;min-width:10%;max-width:100%;;font-size: 15px;font-weight: 400;font-family: H67, Arial;text-transform: uppercase;">
													  <?php echo number_format("".$Personajes[_CLMN_CHR_STAT_CMD_]."",0,",","."); ?>
												  	</div>
												</div>
											</div>
										</div>
										<?php } ?>
									</div>
								</div>
							</div>
						</div>
						<br>
						<div class="row">
									<div class="col-md-12 col-lg-12" style="display:inline-block; vertical-align: top; padding-right: 15px;">
										<center>
											<span class="btn btn-outline-dark m-1"><i class="fas fa-angle-up"></i>&nbsp;<b>Nivel:</b> <?php echo $Personajes[_CLMN_CHR_LVL_]; ?></span>
											<span class="btn btn-outline-dark m-1"><i class="fas fa-undo-alt"></i>&nbsp;<b>Resets:</b> <?php echo $Personajes[_CLMN_CHR_RSTS_]; ?></span>
											<span class="btn btn-outline-dark m-1"><i class="fas fa-coins"></i>&nbsp;<b>Zen:</b> <?php echo number_format("".$Personajes[_CLMN_CHR_ZEN_]."",0,",","."); ?></span>
											<span class="btn btn-outline-dark m-1"><i class="fa fa-map-marker-alt"></i>&nbsp;<?php echo '<b>Ubicacion:</b> '.returnMapName($Personajes[_CLMN_CHR_MAP_]).' ('.$Personajes[_CLMN_CHR_MAP_X_].' - '.$Personajes[_CLMN_CHR_MAP_Y_].')</span>'; ?>
										</center>
									</div>
								</div>
					</div>
				</div>
				<br>
				<?php
				}
			} else {
				lang('myaccount_txt_16', false);
			}

			$this->muonline = Connection::Database('MuOnline');

			$PaypalDonations = $this->muonline->query_fetch("SELECT * FROM ".WEBENGINE_PAYPAL_TRANSACTIONS." WHERE user_id= ? ORDER BY id DESC", $_SESSION['userid']);
			$MPDonations = $this->muonline->query_fetch("SELECT * FROM WEBENGINE_MERCADOPAGO_TRANSACTION WHERE AccountID= ? ORDER BY id DESC", $_SESSION['username']);
			if(is_array($MPDonations) || is_array($PaypalDonations)){
			
			echo '<br><div class="miniranks"><i class="fas fa-wallet"></i> Historial de Donaciones</div><br>';
	
			if(is_array($MPDonations))
			{
				echo '<center><table id="paypal_donations" class="table table-condensed table-striped text-center table-bordered">';
				echo '<thead class="thead-dark">';
					echo '<tr>';
						echo '<th colspan="5"><h4><i class="far fa-handshake"></i> Mercado Pago<h4></td>';
					echo '</tr>';
					echo '<tr>';
						echo '<th>ID Operacion</th>';
						echo '<th>Cantidad</th>';
						echo '<th>Creditos</th>';
						echo '<th>Fecha</th>';
						echo '<th>Estado</th>';
					echo '</tr>';
				echo '</thead>';
				echo '<tbody>';
				foreach($MPDonations as $data) {
					 
					$donation_status = ($data['transaction_status'] == 1 ? '<span class="badge badge-success">Aprobada</span>' : '<span class="badge badge-important">Cancelado</span>');
					
					echo '<tr>';
						echo '<td class="text-info font-weight-bold">'.$data['transaction_order_id'].'</td>';
						echo '<td class="text-danger font-weight-bold">$'.$data['payment_amout'].' ARS</td>';
						echo '<td>'.number_format($data['transaction_amout_credits'],0,',','.').'</td>';
						echo '<td>'.date("d/m/Y H:i",$data['transaction_date']).'</td>';
						echo '<td>'.$donation_status.'</td>';
					echo '</tr>';
				}
			}
			echo '</tbody>
			</table></center>';

			if(is_array($PaypalDonations))
			{
				echo '<hr>';
				echo '<center><table id="paypal_donations" class="table table-condensed table-striped text-center table-bordered">';
				echo '<thead class="thead-dark">';
					echo '<tr>';
						echo '<th colspan="5"><h4><i class="fab fa-paypal"></i> Paypal<h4></td>';
					echo '</tr>';
					echo '<tr>';
						echo '<th>ID Operacion</th>';
						echo '<th>Cantidad</th>';
						echo '<th>Creditos</th>';
						echo '<th>Fecha</th>';
						echo '<th>Estado</th>';
					echo '</tr>';
				echo '</thead>';
				echo '<tbody>';
				foreach($PaypalDonations as $data) {
					 
					$donation_status = ($data['transaction_status'] == 1 ? '<span class="badge badge-success">Aprobada</span>' : '<span class="badge badge-important">Cancelado</span>');
					
					echo '<tr>';
						echo '<td class="text-info font-weight-bold">'.$data['transaction_id'].'</td>';
						echo '<td class="text-danger font-weight-bold">$'.$data['payment_amount'].' USD</td>';
						echo '<td> - </td>';
						echo '<td>'.date("d/m/Y H:i",$data['transaction_date']).'</td>';
						echo '<td>'.$donation_status.'</td>';
					echo '</tr>';
				}
			}
		}
			echo '
			</tbody>
			</table></center>';			