<?php
if(!isLoggedIn()) redirect(1,'login');
function log_trans_sell($message)
{
	$logFile = fopen(__PATH_LOGS__."market/".$_SESSION['username'].".txt", 'a');
	fwrite($logFile, "\n[".date("d/m/Y H:i:s")."] ".$message);
	fclose($logFile);	
}

loadModuleConfigs('marketchar');

if(!mconfig('active')) throw new Exception(lang('error_47',true)); 

$common = new common();
$this->muonline = Connection::Database('MuOnline');

$accountInfo = $common->accountInformation($_SESSION['userid']);
if(!is_array($accountInfo)) throw new Exception(lang('error_12',true));

function safe_input($string){
	$string = preg_replace('[^A-Za-z0-9]', "", $string );

	return $string;
}


if(isset($_POST['vender']) && isset($_POST['id']) && isset($_POST['precio']))
{
	$datoschar = $this->muonline->query_fetch_single("SELECT * FROM Character  WHERE Name=?",$_POST['id']);
	$inventory = $this->muonline->query_fetch_single("SELECT CONVERT(VARCHAR(MAX), (SELECT Inventory FROM Character WHERE Name = ?), 2) AS items", [$_POST['id']]);
	$NivelChar = $datoschar[_CLMN_CHR_LVL_];
	$ResetChar = $datoschar[_CLMN_CHR_RSTS_];
	$MResetChar = $datoschar[_CLMN_CHR_GRSTS_];

	if($common->accountOnline($_SESSION['username'])) 
	{
		message("error", "Debes estar desconectado.");
		log_trans_sell('El usuario '.$_SESSION['username'].' Quiso vender un personaje estando conectado');
	}else {
		if($_POST['precio'] >= mconfig('precio_min'))
		{
			if($MResetChar >= mconfig('precio_mreset')){
				if($ResetChar >= mconfig('precio_reset')){
					if($NivelChar >= mconfig('precio_level')){
						$precio = safe_input($_POST['precio']);
						$id = safe_input($_POST['id']);
						$result = $this->muonline->query("UPDATE Character SET CtlCode=1, PrecioPJ=? WHERE  Name= ?",array($precio,$id));
						log_trans_sell('El usuario '.$_SESSION['username'].' Publico el personaje '. $id.' a '.$precio.' CC.');
						message('success', 'Personaje publicado correctamente.');
					}else{
						message('error', 'Debes tener minimo nivel '.mconfig('precio_level').' en tu personaje para ponerlo a la venta. ');
						log_trans_sell('El usuario '.$_SESSION['username'].' intento vender un personaje de nivel menor al requerido.');
					}
				}else{
					message('error', 'Debes tener minimo '.mconfig('precio_reset').' resets en tu personaje para ponerlo a la venta. ');
					log_trans_sell('El usuario '.$_SESSION['username'].' intento vender un personaje de reset menor al requerido.');
				}

			}else{
				message('error', 'Debes tener minimo '.mconfig('precio_mreset').' Grand Resets / Master Resets en tu personaje para ponerlo a la venta. ');
				log_trans_sell('El usuario '.$_SESSION['username'].' intento vender un personaje de Grand Resets / Master Resets menor al requerido.');
			}

		} else {
			
			message('error', 'El precio debe ser mayor a '.mconfig('precio_min').' '.mconfig('moneda_v').'. ');
			log_trans_sell('El usuario '.$_SESSION['username'].' intento vender un personaje a '.$_POST['precio'].'.');
		}
	}
}

if(isset($_POST['actualizar']) && isset($_POST['id']) && isset($_POST['precio']))
{
	if($common->accountOnline($_SESSION['username'])) 
	{
		message("error", "Debes estar desconectado.");
		log_trans_sell('El usuario '.$_SESSION['username'].' Quiso comprar un personaje estando conectado');
	}else {
		if($_POST['precio'] >= mconfig('precio_min'))
		{
			if($MResetChar >= mconfig('precio_mreset')){
				if($ResetChar >= mconfig('precio_reset')){
					if($NivelChar >= mconfig('precio_level')){
						$precio = safe_input($_POST['precio']);
						$id = safe_input($_POST['id']);
						$result = $this->muonline->query("UPDATE Character SET CtlCode=1, PrecioPJ=? WHERE  Name= ?",array($precio,$id));
						log_trans_sell('El usuario '.$_SESSION['username'].' Actualizo el precio del personaje '. $id.' a '.$precio.' CC.');
						message('success', 'Precio actualizado correctamente.');
					}else{
						message('error', 'Debes tener minimo nivel '.mconfig('precio_level').' en tu personaje para actualizar el precio. ');
						log_trans_sell('El usuario '.$_SESSION['username'].' intento actualizar el precio de un personaje de nivel menor al requerido.');
					}
				}else{
					message('error', 'Debes tener minimo '.mconfig('precio_reset').' resets en tu personaje para actualizar el precio. ');
					log_trans_sell('El usuario '.$_SESSION['username'].' intento actualizar el precio de un personaje de reset menor al requerido.');
				}

			}else{
				message('error', 'Debes tener minimo '.mconfig('precio_mreset').' Grand Resets / Master Resets en tu personaje para actualizar el precio. ');
				log_trans_sell('El usuario '.$_SESSION['username'].' intento actualizar el precio de un personaje de Grand Resets / Master Resets menor al requerido.');
			}
		} else {
			
			message('error', 'El precio debe ser mayor a '.mconfig('precio_min').' '.mconfig('moneda_v').'. ');
			log_trans_sell('El usuario '.$_SESSION['username'].' intento actualizar el precio de un personaje a '.$_POST['precio'].'.');
		}
	}
}

if(isset($_POST['removerpj']) && isset($_POST['id']))
{
	if($common->accountOnline($_SESSION['username'])) 
	{
		message("error", "Debes estar desconectado.");
		log_trans_sell('El usuario '.$_SESSION['username'].' Quiso comprar un personaje estando conectado');
	}else{
		$id = safe_input($_POST['id']);
		$result = $this->muonline->query("UPDATE Character SET CtlCode=0, PrecioPJ=0 WHERE  Name= ?",array($id));
		message('success', 'El Personaje fue removido de el market correctamente.');
		log_trans_sell('El usuario '.$_SESSION['username'].' removio el personaje '.$id.' del market.');
	}
}


echo '<div class="page-title"><span>Vender Personaje</span></div>';
	echo '<div class="alert alert-info">';
		echo '<h3 class="tips-ayudas-color">&nbsp;Requisitos</h3>';
		echo '<p class="alert-info">';
			echo '<ul>';
				echo '<li>Estar desconectado del juego.</li>';
				echo '<li>El personaje seleccionado no debe tener Guild.</li>';
				echo '<li>El personaje debe tener <b>'.mconfig('precio_mreset').' Grand / Master Resets</b> minimo.</li>';
				echo '<li>El personaje debe tener <b>'.mconfig('precio_reset').' resets</b> minimo..</li>';
				echo '<li>El personaje debe ser nivel <b>'.mconfig('precio_level').'</b> minimo.</li>';
			echo '</ul>		';	
		echo '</p>';
	echo '</div>';

if(mconfig('comission')){
	$TotalARecibir = (10000 - (10000 * mconfig('comission_porc') / 100));
	echo '<div class="alert alert-danger">';
		echo '<h3 class="tips-ayudas-color">&nbsp;ATENCION</h3>';
		echo '<p class="alert-danger">';
			echo '<ul>';
				echo '<li>Al vender el personaje tendras una comision del <b>'.mconfig('comission_porc').'%.</b></li>';
			echo '</ul>';
			echo '&nbsp;';
			echo '<b>Ejemplo:</b> Vendes un personaje a <b>'.number_format('10000',0,",",".").' '.mconfig('moneda_v').'</b>. En vez de recibir el total, recibiras <b>'.number_format($TotalARecibir,0,",",".").' '.mconfig('moneda').'</b>	';	
		echo '</p>';
	echo '</div>';
}
	$result = $this->muonline->query_fetch("SELECT * FROM Character  WHERE AccountID=?",$_SESSION['username']);
	$result2 = $this->muonline->query_fetch_single("SELECT * FROM MEMB_INFO  WHERE memb___id=?",$_SESSION['username']);
	
	if(is_array($result))
	{
		echo '<div class="row">';
		 
		foreach($result as $row)
		{
			$result3 = $this->muonline->query_fetch_single("SELECT * FROM GuildMember  WHERE Name=?",$row['Name']);
			$result4 = $this->muonline->query_fetch_single("select * from [MasterSkillTree] where [Name]= '".$CharacteSell."'");
			if($result4['MasterLevel'] == NULL) $result4['MasterLevel'] = 0;
	
			if($row['Class'] == 0 || $row['Class'] == 1 || $row['Class'] == 2){
				$ClassRaza		=	'RazaSM';
				$ClassBtnRaza	=	'BtnSM';
				$ColorTextRaza 	=	'#2f7dcc';
			}
			else if($row['Class'] == 16 || $row['Class'] == 17 || $row['Class'] == 18){
				$ClassRaza		=	'RazaDK';
				$ClassBtnRaza	=	'BtnDK';
				$ColorTextRaza 	=	'#cc2f2f';
			}
			else if($row['Class'] == 32 || $row['Class'] == 33 || $row['Class'] == 34){
				$ClassRaza		=	'RazaELF';
				$ClassBtnRaza	=	'BtnELF';
				$ColorTextRaza 	=	'#33cc2f';
			}
			else if($row['Class'] == 48 || $row['Class'] == 49 || $row['Class'] == 50){
				$ClassRaza		=	'RazaMG';
				$ClassBtnRaza	=	'BtnMG';
				$ColorTextRaza 	=	'#712fcc';
			}
			else if($row['Class'] == 64 || $row['Class'] == 65 || $row['Class'] == 66){
				$ClassRaza		=	'RazaDL';
				$ClassBtnRaza	=	'BtnDL';
				$ColorTextRaza 	=	'#cc9e2f';
			}
			else if($row['Class'] == 80 || $row['Class'] == 81 || $row['Class'] == 82){
				$ClassRaza		=	'RazaSUM';
				$ClassBtnRaza	=	'BtnSUM';
				$ColorTextRaza 	=	'#bf2fcc';
			}
			else if($row['Class'] == 96 || $row['Class'] == 97 || $row['Class'] == 98){
				$ClassRaza		=	'RazaRF';
				$ClassBtnRaza	=	'BtnRF';
				$ColorTextRaza 	=	'#cc542f';
			}

			if($result2['bloc_code'] == 1)
			{
				$Estado = 'BANEADO';
				$BGStatus = 'bg-dark';
				$InputName = '<input class="form-control text-center" type="text" id="precio" name="precio" placeholder="Personaje Baneado" disabled>';
				$SendBtn = '';
			}
			else if(strlen($result3['Name'])>= 1){
				$Estado = 'NO PUEDE VENDERSE - [ POSEE GUILD ]';
				$BGStatus = 'bg-danger';
				$InputName = '<input class="form-control text-center" type="text" id="precio" name="precio" placeholder="Personaje con Guild" disabled>';
				$SendBtn = '';
			}
			else if($row[_CLMN_CHR_GRSTS_] < mconfig('precio_mreset')){
				$Estado = 'NECESITAS '.mconfig('precio_mreset').' GRAND / MASTER RESET';
				$BGStatus = 'bg-danger';
				$InputName = '<input class="form-control text-center" type="text" id="precio" name="precio" placeholder="Necesita mas GR / MR " disabled>';
				$SendBtn = '';
			}
			else if($row[_CLMN_CHR_RSTS_] < mconfig('precio_reset')){
				$Estado = 'NECESITAS '.mconfig('precio_reset').' RESETS';
				$BGStatus = 'bg-danger';
				$InputName = '<input class="form-control text-center" type="text" id="precio" name="precio" placeholder="Necesita mas Resets" disabled>';
				$SendBtn = '';
			}
			else if($row[_CLMN_CHR_LVL_] < mconfig('precio_level')){
				$Estado = 'NECESITAS NIVEL '.mconfig('precio_level').'';
				$BGStatus = 'bg-danger';
				$InputName = '<input class="form-control text-center" type="text" id="precio" name="precio" placeholder="Necesita mas Nivel" disabled>';
				$SendBtn = '';
			}
			else if($row['CtlCode'] == 0)
			{
				$Estado = 'PUEDE VENDERSE';
				$BGStatus = 'bg-success';
				$InputName = '<input class="form-control text-center" type="text" id="precio" name="precio" placeholder="Precio del Personaje" >';
				$SendBtn = '<input class="btn btn-outline-secondary '.$ClassBtnRaza.'" name="vender" type="submit" value="Vender">';
			}
			else if($row['CtlCode'] == 1 && $row['PrecioPJ'] >= 1){
				$Estado = 'PUBLICADO';
				$BGStatus = 'bg-success';
				$InputName = '<input class="form-control text-center" type="text" id="precio" name="precio" placeholder="Actualizar Precio" >';
				$SendBtn = '<input class="btn btn-outline-secondary '.$ClassBtnRaza.'" name="actualizar" type="submit" value="Actualizar"><input class="btn btn-outline-secondary '.$ClassBtnRaza.'" name="removerpj" type="submit" value="Quitar">';
			}else{
				$Estado = 'BANEADO';
				$BGStatus = 'bg-dark';
				$InputName = '<input class="form-control text-center" type="text" id="precio" name="precio" placeholder="Personaje Baneado" disabled>';
				$SendBtn = '';
			}

			echo '<div class="col-sm-12 col-md-12">';
			echo '<div class="card mb-3 '.$ClassRaza.'"">';
			echo '<div class="row g-0">';
			  echo '<div class="col-md-5">';
				echo '<img src="'.getPlayerClassAvatar($row['Class'],0,1).'" class="img-fluid rounded-start" alt="'.getPlayerClass($row['Class']).'" style="width:100%;height:100%;">';
			  echo '</div>';
			  echo '<div class="col-md-7">';
				echo '<div class="card-body" style="padding:10px;">';
					echo '<span class="h5 align-items-center"><b>'.$row['Name'].'';
					echo '<small class="card-title" style="color:'.$ColorTextRaza.';"> [ '.getPlayerClass($row['Class']).' ]</b></small></span>';
					echo '<p class="card-text">';
					echo '<div class="input-group input-group-sm mb-1">';
						echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-redo-alt"></i>&nbsp;Resets</span>';
						echo '<span class="form-control">'.$row['ResetCount'].'</span>';
					echo '</div>';
					echo '<div class="input-group input-group-sm mb-1">';
						echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-angle-up"></i>&nbsp;Nivel</span>';
						echo '<span class="form-control">'.$row['cLevel'].'</span>';
						echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-angle-double-up"></i>&nbsp;Master&nbsp;Level</span>';
						echo '<span class="form-control">'.$result4['MasterLevel'].'</span>';
					echo '</div>';
					echo '<div class="input-group input-group-sm mb-1">';
						echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-exclamation-circle"></i>&nbsp;Estado</span>';
						echo '<span class="form-control '.$BGStatus.' text-white">'.$Estado.'</span>';
					echo '</div>';
					if($row['CtlCode'] == 1 && $row['PrecioPJ'] >= 1){
					echo '<div class="input-group input-group-sm mb-1">';
						echo '<span class="input-group-text" id="inputGroup-sizing-sm"><i class="fas fa-coins"></i>&nbsp;Precio</span>';
						echo '<span class="form-control text-danger"><b>'.number_format($row['PrecioPJ'],0,",",".").' '.mconfig('moneda_v').'</b></span>';
					echo '</div>';
					}
				echo '	
				</p>';
				echo '</div>';
				echo '<div class="card-footer">';
					echo '<p class="card-text">';
					echo '<form action="" method="post"><div class="input-group">';
						echo '<input type="hidden" id="id" name="id" value="'.$row['Name'].'">';
					    echo '<input type="hidden" id="rst" name="rst" value="'.$row['ResetCount'].'">';
					    echo $InputName;
						echo $SendBtn;
					echo '</div></form>';
					echo '</p>';
				echo '</div>';
			  echo '</div>';
			echo '</div>';
		  echo '</div>';

			echo '</div>';
		}
		echo '</div>';
	}else echo "<span class='text-danger'>No tienes ningun personaje.</span>";

?>
